/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;
import oshi.util.tuples.Triplet;

public class UndergroundTempModifier
extends TempModifier {
    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        if (entity.f_19853_.m_6042_().f_63856_()) {
            return temp -> temp;
        }
        double midTemp = (ConfigSettings.MAX_TEMP.get() + ConfigSettings.MIN_TEMP.get()) / 2.0;
        BlockPos playerPos = new BlockPos(entity.m_146892_());
        Level level = entity.f_19853_;
        ArrayList depthTable = new ArrayList();
        double biomeTempTotal = 0.0;
        int caveBiomeCount = 0;
        for (BlockPos pos : WorldHelper.getPositionCube(entity.m_20183_(), 5, 10)) {
            Holder holder;
            if (!level.m_46739_(pos)) continue;
            depthTable.add(Pair.of((Object)Math.max(0.0, (double)(WorldHelper.getHeight(pos, level) - playerPos.m_123342_())), (Object)Math.sqrt(pos.m_123331_((Vec3i)playerPos))));
            if ((double)WorldHelper.getHeight(pos, level) <= entity.m_20186_() || !(holder = level.m_7062_().m_204214_(pos)).m_203656_(Tags.Biomes.IS_UNDERGROUND) || holder.m_203543_().isEmpty()) continue;
            Biome biome = (Biome)holder.m_203334_();
            double baseTemp = biome.m_47554_();
            Triplet<Double, Double, Temperature.Units> cTemp = ConfigSettings.BIOME_TEMPS.get().getOrDefault(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)baseTemp, (Object)baseTemp, (Object)Temperature.Units.MC));
            Triplet<Double, Double, Temperature.Units> cOffset = ConfigSettings.BIOME_OFFSETS.get().getOrDefault(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)0.0, (Object)0.0, (Object)Temperature.Units.MC));
            double biomeTemp = CSMath.averagePair((Pair<? extends Number, ? extends Number>)Pair.of((Object)((Double)cTemp.getA()), (Object)((Double)cTemp.getB()))) + CSMath.averagePair((Pair<? extends Number, ? extends Number>)Pair.of((Object)((Double)cOffset.getA()), (Object)((Double)cOffset.getB())));
            biomeTempTotal += biomeTemp;
            ++caveBiomeCount;
        }
        if (depthTable.isEmpty()) {
            return temp -> temp;
        }
        double depth = CSMath.blend(0.0, CSMath.weightedAverage(depthTable), ConfigSettings.CAVE_INSULATION.get(), 0.0, 1.0);
        int biomeCount = Math.max(1, caveBiomeCount);
        double biomeTempAvg = biomeTempTotal / (double)biomeCount;
        return temp -> {
            double depthAvg = CSMath.weightedAverage(CSMath.blend(midTemp, temp, (double)entity.f_19853_.m_45517_(LightLayer.SKY, entity.m_20183_()), 0.0, 15.0), CSMath.blend(temp, midTemp, depth, 4.0, 20.0), 1.0, 2.0);
            return CSMath.blend(depthAvg, biomeTempAvg, (double)biomeCount, 0.0, (double)depthTable.size());
        };
    }
}

