/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.api.event.common.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.core.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.common.event.capability.EntityTempManager;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.TempModifiersSyncMessage;
import com.momosoftworks.coldsweat.core.network.message.TemperatureSyncMessage;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.InterruptableStreamer;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Temperature {
    static Map<ResourceLocation, DummyPlayer> DUMMIES = new HashMap<ResourceLocation, DummyPlayer>();

    private Temperature() {
    }

    public static double convert(double value, Units from, Units to, boolean absolute) {
        return switch (from) {
            default -> throw new IncompatibleClassChangeError();
            case Units.C -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield value;
                    }
                    case F: {
                        yield value * 1.8 + (absolute ? 32.0 : 0.0);
                    }
                    case MC: 
                }
                yield value / 25.0;
            }
            case Units.F -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield (value - (absolute ? 32.0 : 0.0)) / 1.8;
                    }
                    case F: {
                        yield value;
                    }
                    case MC: 
                }
                yield (value - (absolute ? 32.0 : 0.0)) / 45.0;
            }
            case Units.MC -> {
                switch (to) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case C: {
                        yield value * 25.0;
                    }
                    case F: {
                        yield value * 45.0 + (absolute ? 32.0 : 0.0);
                    }
                    case MC: 
                }
                yield value;
            }
        };
    }

    public static double get(LivingEntity entity, Trait trait) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.getTrait(trait)).orElse(0.0);
    }

    public static void set(LivingEntity entity, Trait trait, double value) {
        ((ITemperatureCap)EntityTempManager.getTemperatureCap((Entity)entity).orElse((Object)new PlayerTempCap())).setTrait(trait, value);
    }

    public static void add(LivingEntity entity, Trait trait, double value) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.setTrait(trait, cap.getTrait(trait) + value));
    }

    public static double apply(double currentTemp, LivingEntity entity, Trait trait, TempModifier ... modifiers) {
        double temp2 = currentTemp;
        for (TempModifier modifier : modifiers) {
            double newTemp;
            if (modifier == null) continue;
            double d = newTemp = entity.f_19797_ % modifier.getTickRate() == 0 || modifier.getTicksExisted() == 0 ? modifier.update(temp2, entity, trait) : modifier.getResult(temp2);
            if (Double.isNaN(newTemp)) continue;
            temp2 = newTemp;
        }
        return temp2;
    }

    public static double apply(double temp, LivingEntity entity, Trait trait, Collection<TempModifier> modifiers) {
        return Temperature.apply(temp, entity, trait, modifiers.toArray(new TempModifier[0]));
    }

    public static double getTemperatureAt(BlockPos pos, Level level) {
        ResourceLocation dimension = level.m_46472_().m_135782_();
        DummyPlayer dummy = DUMMIES.get(dimension);
        if (dummy == null || dummy.f_19853_ != level) {
            dummy = new DummyPlayer(level);
            DUMMIES.put(dimension, dummy);
            GatherDefaultTempModifiersEvent event = new GatherDefaultTempModifiersEvent((LivingEntity)dummy, Trait.WORLD);
            MinecraftForge.EVENT_BUS.post((Event)event);
            Temperature.addModifiers((LivingEntity)dummy, event.getModifiers(), Trait.WORLD, true);
        }
        dummy.m_146884_(CSMath.getCenterPos(pos));
        return Temperature.apply(0.0, (LivingEntity)dummy, Trait.WORLD, Temperature.getModifiers((LivingEntity)dummy, Trait.WORLD));
    }

    public static boolean hasModifier(LivingEntity entity, Trait trait, Class<? extends TempModifier> modClass) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.hasModifier(trait, modClass)).orElse(false);
    }

    public static <T extends TempModifier> Optional<T> getModifier(LivingEntity entity, Trait trait, Class<T> modClass) {
        return Temperature.getModifier((ITemperatureCap)EntityTempManager.getTemperatureCap((Entity)entity).orElse((Object)new PlayerTempCap()), trait, modClass);
    }

    public static <T extends TempModifier> Optional<T> getModifier(ITemperatureCap cap, Trait trait, Class<T> modClass) {
        return cap.getModifiers(trait).stream().filter(modClass::isInstance).findFirst();
    }

    @Nullable
    public static TempModifier getModifier(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        for (TempModifier modifier : ((ITemperatureCap)EntityTempManager.getTemperatureCap((Entity)entity).orElse((Object)new PlayerTempCap())).getModifiers(trait)) {
            if (!condition.test(modifier)) continue;
            return modifier;
        }
        return null;
    }

    public static void addOrReplaceModifier(LivingEntity entity, TempModifier modifier, Trait trait) {
        Temperature.addModifier(entity, modifier, trait, false, 1, Placement.of(Placement.Mode.REPLACE_OR_ADD, Placement.Order.FIRST, mod -> mod.equals(modifier)));
    }

    public static void replaceModifier(LivingEntity entity, TempModifier modifier, Trait trait) {
        Temperature.addModifier(entity, modifier, trait, false, 1, Placement.of(Placement.Mode.REPLACE, Placement.Order.FIRST, mod -> mod.equals(modifier)));
    }

    public static void addModifier(LivingEntity entity, TempModifier modifier, Trait trait, boolean allowDupes) {
        Temperature.addModifier(entity, modifier, trait, allowDupes, 1, Placement.AFTER_LAST);
    }

    public static void addModifier(LivingEntity entity, TempModifier modifier, Trait trait, boolean allowDupes, int times, Placement placement) {
        TempModifierEvent.Add event = new TempModifierEvent.Add(modifier, entity, trait);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
                if (Temperature.addModifier(cap.getModifiers(trait), event.getModifier(), allowDupes, times, placement)) {
                    Temperature.updateModifiers(entity, cap);
                }
            });
        }
    }

    public static boolean addModifier(List<TempModifier> modifiers, TempModifier modifier, boolean allowDupes, int maxCount, Placement placement) {
        int start;
        boolean isForward;
        boolean changed = false;
        Predicate<TempModifier> predicate = placement.predicate();
        if (predicate == null) {
            predicate = mod -> true;
        }
        boolean isReplacing = placement.mode() == Placement.Mode.REPLACE || placement.mode() == Placement.Mode.REPLACE_OR_ADD;
        boolean bl = isForward = placement.order() == Placement.Order.FIRST;
        if (!allowDupes && !isReplacing && modifiers.stream().anyMatch(mod -> mod.getClass().equals(modifier.getClass()))) {
            return false;
        }
        int hits = 0;
        int i = start = isForward ? 0 : modifiers.size() - 1;
        while (isForward ? i < modifiers.size() : i >= 0) {
            TempModifier mod2 = modifiers.get(i);
            if (predicate.test(mod2)) {
                if (isReplacing) {
                    modifiers.set(i, modifier);
                } else {
                    modifiers.add(i + (placement.mode() == Placement.Mode.AFTER ? 1 : 0), modifier);
                }
                changed = true;
                if (!allowDupes || ++hits >= maxCount) {
                    return true;
                }
            }
            i += isForward ? 1 : -1;
        }
        if (placement.mode() != Placement.Mode.REPLACE) {
            modifiers.add(modifier);
            changed = true;
        }
        return changed;
    }

    public static void addModifiers(LivingEntity entity, List<TempModifier> modifiers, Trait trait, boolean duplicates) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            for (TempModifier modifier : modifiers) {
                Temperature.addModifier(entity, modifier, trait, duplicates);
            }
            Temperature.updateModifiers(entity, cap);
        });
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, int maxCount, Placement.Order order, Predicate<TempModifier> condition) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            int i;
            List<TempModifier> modifiers = cap.getModifiers(trait);
            boolean forwardOrder = order == Placement.Order.FIRST;
            int removed = 0;
            int n = i = forwardOrder ? 0 : modifiers.size() - 1;
            while (i >= 0 && i < modifiers.size() && removed < maxCount) {
                TempModifier modifier = modifiers.get(i);
                TempModifierEvent.Remove event = new TempModifierEvent.Remove(entity, trait, maxCount, condition);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled() && event.getCondition().test(modifier)) {
                    ++removed;
                    modifiers.remove(i);
                    i += forwardOrder ? -1 : 1;
                }
                i += forwardOrder ? 1 : -1;
            }
            if (removed > 0) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        Temperature.removeModifiers(entity, trait, Integer.MAX_VALUE, Placement.Order.FIRST, condition);
    }

    public static List<TempModifier> getModifiers(LivingEntity entity, Trait trait) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.getModifiers(trait)).orElse(List.of());
    }

    public static void forEachModifier(LivingEntity entity, Trait trait, Consumer<TempModifier> action) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            if (cap.getModifiers(trait) != null) {
                cap.getModifiers(trait).forEach(action);
            }
        });
    }

    public static void forEachModifier(LivingEntity entity, Trait trait, BiConsumer<TempModifier, InterruptableStreamer<TempModifier>> action) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            if (cap.getModifiers(trait) != null) {
                CSMath.breakableForEach(cap.getModifiers(trait), action);
            }
        });
    }

    public static void updateTemperature(LivingEntity entity, ITemperatureCap cap, boolean instant) {
        if (!entity.f_19853_.f_46443_) {
            PacketDistributor.PacketTarget packetTarget;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                packetTarget = PacketDistributor.PLAYER.with(() -> player);
            } else {
                packetTarget = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity);
            }
            ColdSweatPacketHandler.INSTANCE.send(packetTarget, (Object)new TemperatureSyncMessage(entity, cap.serializeTraits(), instant));
        }
    }

    public static void updateModifiers(LivingEntity entity, ITemperatureCap cap) {
        if (!entity.f_19853_.f_46443_) {
            PacketDistributor.PacketTarget packetTarget;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                packetTarget = PacketDistributor.PLAYER.with(() -> player);
            } else {
                packetTarget = PacketDistributor.TRACKING_ENTITY.with(() -> entity);
            }
            ColdSweatPacketHandler.INSTANCE.send(packetTarget, (Object)new TempModifiersSyncMessage(entity, cap.serializeModifiers()));
        }
    }

    public static Map<Trait, Double> getTemperatures(LivingEntity entity) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(ITemperatureCap::getTraits).orElse(new EnumMap(Trait.class));
    }

    public static enum Units implements StringRepresentable
    {
        F("\u00b0F", "f"),
        C("\u00b0C", "c"),
        MC("MC", "mc");

        public static final Codec<Units> CODEC;
        private final String name;
        private final String id;

        private Units(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public static Units fromID(String id) {
            for (Units unit : Units.values()) {
                if (!unit.m_7912_().equals(id)) continue;
                return unit;
            }
            return null;
        }

        public String getFormattedName() {
            return this.name;
        }

        public String m_7912_() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Units::values);
        }
    }

    public static enum Trait implements StringRepresentable
    {
        WORLD("world"),
        CORE("core"),
        BASE("base"),
        BODY("body"),
        RATE("rate"),
        FREEZING_POINT("freezing_point"),
        BURNING_POINT("burning_point"),
        COLD_RESISTANCE("cold_resistance"),
        HEAT_RESISTANCE("heat_resistance"),
        COLD_DAMPENING("cold_dampening"),
        HEAT_DAMPENING("heat_dampening");

        public static final Codec<Trait> CODEC;
        private final String id;

        private Trait(String id) {
            this.id = id;
        }

        public static Trait fromID(String id) {
            for (Trait trait : Trait.values()) {
                if (!trait.m_7912_().equals(id)) continue;
                return trait;
            }
            return null;
        }

        public String m_7912_() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Trait::values);
        }
    }
}

