/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class IceboxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty FROSTED = BooleanProperty.m_61465_((String)"frosted");

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f);
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT);
    }

    public IceboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FROSTED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.ICEBOX ? IceboxBlockEntity::tick : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == ModItems.SMOKESTACK && rayTraceResult.m_82434_() == Direction.UP && level.m_8055_(pos.m_7494_()).m_60734_() instanceof AirBlock) {
                return InteractionResult.FAIL;
            }
            int itemFuel = icebox.getItemFuel(stack);
            if (itemFuel != 0 && (double)icebox.getFuel() + (double)itemFuel * 0.75 < (double)icebox.getMaxFuel()) {
                if (!player.m_7500_()) {
                    if (stack.hasCraftingRemainingItem()) {
                        ItemStack container = stack.getCraftingRemainingItem();
                        stack.m_41774_(1);
                        player.m_150109_().m_36054_(container);
                    } else {
                        stack.m_41774_(1);
                    }
                }
                icebox.setFuel(icebox.getFuel() + itemFuel);
                level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 0.9f + new Random().nextFloat() * 0.2f);
            } else if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)icebox, (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IceboxBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (neighborPos.equals((Object)pos.m_7494_()) && (blockEntity = level.m_7702_(pos)) instanceof IceboxBlockEntity) {
            IceboxBlockEntity icebox = (IceboxBlockEntity)blockEntity;
            icebox.checkForSmokestack();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (state.m_60734_() != newState.m_60734_() && (tileentity = world.m_7702_(pos)) instanceof IceboxBlockEntity) {
            IceboxBlockEntity te = (IceboxBlockEntity)tileentity;
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)te);
            world.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FROSTED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)FROSTED, (Comparable)Boolean.valueOf(false));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.m_61143_((Property)FROSTED)).booleanValue()) {
            return;
        }
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = pos.m_123342_();
        double d2 = (double)pos.m_123343_() + 0.5;
        boolean side = new Random().nextBoolean();
        double d5 = side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        double d6 = Math.random() * 0.3;
        double d7 = !side ? Math.random() - 0.5 : (Math.random() < 0.5 ? 0.55 : -0.55);
        level.m_7106_((ParticleOptions)ParticleTypesInit.GROUND_MIST.get(), d0 + d5, d1 + d6, d2 + d7, d5 / 40.0, 0.0, d7 / 40.0);
    }
}

