/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.mojang.math.Vector3f;
import com.momosoftworks.coldsweat.common.blockentity.ThermolithBlockEntity;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThermolithBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public ThermolithBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        ThermolithBlock.calculateFacingShapes(Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)5.0)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56730_).m_60978_(2.0f).m_155956_(10.0f).m_60955_().m_60988_().m_60953_(ThermolithBlock.getLightValueLit(5)).m_60924_((state, level, pos) -> true).m_60999_();
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? lightValue : 0;
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(64);
    }

    static void calculateFacingShapes(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            SHAPES.put(direction, CSMath.rotateShape(direction, shape));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ThermolithBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.THERMOLITH ? ThermolithBlockEntity::tick : null;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && blockEntity instanceof ThermolithBlockEntity) {
            ThermolithBlockEntity thermolith = (ThermolithBlockEntity)blockEntity;
            return thermolith.getSignal();
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            boolean xAxis = direction.m_122434_() == Direction.Axis.X;
            float headLength = 0.25f;
            float offset = xAxis ? (direction.m_122429_() < 0 ? headLength : -0.05f) : (direction.m_122431_() < 0 ? headLength : -0.05f);
            double pY = Math.random() * 0.625 + 0.375;
            double pX = xAxis ? (double)random.m_188503_(2) * 0.8 + (double)offset : 0.5;
            double pZ = xAxis ? 0.5 : (double)random.m_188503_(2) * 0.8 + (double)offset;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)4895036)), random.m_188501_() * 0.5f + 0.5f), (double)pos.m_123341_() + pX, (double)pos.m_123342_() + pY, (double)pos.m_123343_() + pZ, 0.0, 0.0, 0.0);
            if (random.m_188500_() < 0.5) {
                float rX = xAxis ? (float)Math.random() * 0.8f + offset : 0.5f;
                float rZ = xAxis ? 0.5f : (float)Math.random() * 0.8f + offset;
                level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)4895036)), random.m_188501_() * 0.5f + 0.5f), (double)((float)pos.m_123341_() + rX), (double)pos.m_123342_() + 1.05, (double)((float)pos.m_123343_() + rZ), 0.0, 0.0, 0.0);
            }
        }
    }
}

