/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data.edible;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.entity.data.edible.BiomeSearchingEdible;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;

public class ColdBiomeEdible
extends BiomeSearchingEdible {
    public ColdBiomeEdible() {
        super(holder -> {
            Pair<Double, Double> minMaxTemp = ConfigSettings.getBiomeTemperature((Holder<Biome>)holder);
            double biomeTemp = CSMath.averagePair(minMaxTemp);
            return biomeTemp <= 0.2;
        });
    }

    @Override
    public int getCooldown() {
        return (int)(Math.random() * 400.0 + 1200.0);
    }

    @Override
    public TagKey<Item> associatedItems() {
        return ModItemTags.CHAMELEON_COLD;
    }
}

