/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.goals;

import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.common.entity.data.edible.ChameleonEdibles;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.common.entity.goals.LazyLookGoal;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EatObjectsGoal
extends Goal {
    List<EntityType<?>> wantedEntities;
    Chameleon entity;
    Entity target;
    boolean stoppedTasks;
    Vec3 lookPos = null;

    public EatObjectsGoal(Chameleon chameleon, List<EntityType<?>> wantedEntities) {
        this.wantedEntities = wantedEntities;
        this.entity = chameleon;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && !this.target.m_213877_() || this.entity.getEatTimer() > 0.0f;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        List items = this.entity.f_19853_.m_45933_((Entity)this.entity, new AABB(this.entity.m_20183_()).m_82400_(5.0));
        for (Entity ent : items) {
            ItemEntity itemEntity;
            if (ent instanceof ItemEntity && (itemEntity = (ItemEntity)ent).m_32057_() != null && (this.entity.isPlayerTrusted(itemEntity.m_32057_()) || this.entity.isTamingItem(itemEntity.m_32055_()))) {
                ItemStack item = itemEntity.m_32055_();
                Optional<Edible> edible = ChameleonEdibles.getEdible(item);
                if (!edible.isPresent() || NBTHelper.getTagOrEmpty(item).m_128441_("Recipient") && !NBTHelper.getTagOrEmpty(item).m_128461_("Recipient").equals(this.entity.m_20148_().toString()) || (this.entity.getCooldown(edible.get()) > 0 || !edible.get().shouldEat(this.entity, itemEntity)) && !this.isBreedingItem(itemEntity.m_32055_())) continue;
                this.target = ent;
                this.lookPos = ent.m_20182_();
                break;
            }
            if (!this.wantedEntities.contains(ent.m_6095_())) continue;
            this.target = ent;
            this.lookPos = ent.m_20182_();
            break;
        }
    }

    public void m_8041_() {
        this.stoppedTasks = false;
        this.target = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if ((this.target == null || this.target.m_213877_()) && this.entity.getEatTimer() <= 0.0f) {
            this.m_8041_();
            return;
        }
        this.lookPos = this.target.m_20182_().m_82549_(this.target.m_20184_());
        this.entity.m_21563_().m_24964_(this.lookPos);
        if (this.entity.getEatTimer() <= 0.0f) {
            PathNavigation navigator = this.entity.m_21573_();
            Path path = navigator.m_6570_(this.target, 0);
            if (path != null) {
                navigator.m_26536_(path, 1.5);
            }
            if (Math.sqrt(this.entity.m_20280_(this.target)) < 1.5 && Math.abs(this.entity.m_20186_() - this.target.m_20186_()) < 1.0 && this.target.m_6084_()) {
                navigator.m_26573_();
                this.entity.m_21563_().m_24964_(this.lookPos);
                this.entity.eatAnimation();
                WorldHelper.playEntitySound(ModSounds.CHAMELEON_TONGUE_OUT, (Entity)this.entity, this.entity.m_5720_(), 1.0f, (float)Math.random() * 0.2f + 0.9f);
                TaskScheduler.scheduleServer(() -> {
                    if (this.target != null && this.target.m_6084_() && !this.target.m_213877_()) {
                        this.entity.onEatEntity(this.target);
                        this.target.m_142687_(Entity.RemovalReason.KILLED);
                        Entity patt5085$temp = this.target;
                        if (patt5085$temp instanceof ItemEntity) {
                            ItemEntity item = (ItemEntity)patt5085$temp;
                            this.entity.m_21053_(item);
                            UUID thrower = item.m_32057_();
                            if (item.m_32055_().m_41613_() > 0) {
                                ItemStack stack = item.m_32055_().m_41777_();
                                stack.m_41774_(1);
                                if (!stack.m_41619_()) {
                                    WorldHelper.entityDropItem((Entity)this.entity, stack).m_32052_(thrower);
                                }
                            }
                        }
                        WorldHelper.playEntitySound(ModSounds.CHAMELEON_TONGUE_IN, (Entity)this.entity, this.entity.m_5720_(), 1.0f, (float)Math.random() * 0.2f + 0.9f);
                    }
                }, this.entity.getEatAnimLength() / 2 + 2);
                TaskScheduler.scheduleServer(() -> this.target.m_20256_(this.entity.m_20182_().m_82546_(this.target.m_20182_()).m_82541_().m_82490_(0.75)), this.entity.getEatAnimLength() / 2);
            }
            this.entity.f_21345_.m_25386_().forEach(goal -> {
                Goal g = goal.m_26015_();
                if (g instanceof TemptGoal || g instanceof LookAtPlayerGoal || g instanceof RandomLookAroundGoal || g instanceof LazyLookGoal) {
                    this.stoppedTasks = true;
                    goal.m_8041_();
                }
            });
        }
    }

    public boolean m_8036_() {
        return this.entity.m_21188_() == null;
    }

    private boolean isBreedingItem(ItemStack stack) {
        return this.entity.m_5957_() && this.entity.m_6898_(stack);
    }
}

