/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.common.event.capability.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ArmorInsulation {
    @SubscribeEvent
    public static void applyArmorInsulation(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.f_19797_ % 20 == 0 && !player.f_19853_.f_46443_) {
                Advancement advancement;
                int fullyInsulated = 0;
                double cold = 0.0;
                double heat = 0.0;
                double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
                double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                for (ItemStack armorStack : player.m_6168_()) {
                    if (!(armorStack.m_41720_() instanceof ArmorItem)) continue;
                    Insulator armorInsulator = ConfigSettings.INSULATING_ARMORS.get().get(armorStack.m_41720_());
                    if (armorInsulator != null) {
                        if (!armorInsulator.predicate().test((Entity)serverPlayer) || !armorInsulator.data().test(armorStack, true)) continue;
                        cold += armorInsulator.insulation().getCold();
                        heat += armorInsulator.insulation().getHeat();
                    } else {
                        Object t;
                        LazyOptional<IInsulatableCap> iCap = ItemInsulationManager.getInsulationCap(armorStack);
                        List insulation = ((List)ItemInsulationManager.getInsulationCap(armorStack).map(IInsulatableCap::getInsulation).orElse(new ArrayList())).stream().filter(pair -> CSMath.getIfNotNull(ConfigSettings.INSULATION_ITEMS.get().get(((ItemStack)pair.getFirst()).m_41720_()), insulator -> insulator.test((Entity)serverPlayer, (ItemStack)pair.getFirst()), false)).map(pair -> (List)pair.getSecond()).flatMap(Collection::stream).toList();
                        for (Insulation value : insulation) {
                            if (value instanceof StaticInsulation) {
                                StaticInsulation insul = (StaticInsulation)value;
                                cold += insul.getCold();
                                heat += insul.getHeat();
                                continue;
                            }
                            if (!(value instanceof AdaptiveInsulation)) continue;
                            AdaptiveInsulation insul = (AdaptiveInsulation)value;
                            cold += CSMath.blend(insul.getInsulation() * 0.75, 0.0, insul.getFactor(), -1.0, 1.0);
                            heat += CSMath.blend(0.0, insul.getInsulation() * 0.75, insul.getFactor(), -1.0, 1.0);
                        }
                        if ((cold + heat) / 2.0 >= (double)ItemInsulationManager.getInsulationSlots(armorStack)) {
                            ++fullyInsulated;
                        }
                        if (iCap.resolve().isPresent() && (t = iCap.resolve().get()) instanceof ItemInsulationCap) {
                            ItemInsulationCap cap = (ItemInsulationCap)t;
                            cap.calcAdaptiveInsulation(worldTemp, minTemp, maxTemp);
                        }
                    }
                    double armorAmount = armorStack.m_41638_(LivingEntity.m_147233_((ItemStack)armorStack)).entries().stream().filter(entry -> ((Attribute)entry.getKey()).equals(Attributes.f_22284_)).map(entry -> ((AttributeModifier)entry.getValue()).m_22218_()).mapToDouble(Double::doubleValue).sum();
                    cold += Math.min(armorAmount, 20.0);
                    heat += Math.min(armorAmount, 20.0);
                }
                Temperature.addOrReplaceModifier((LivingEntity)player, new ArmorInsulationTempModifier(cold, heat).tickRate(20).expires(20), Temperature.Trait.RATE);
                if (fullyInsulated >= 4 && serverPlayer.m_20194_() != null && (advancement = serverPlayer.m_20194_().m_129889_().m_136041_(new ResourceLocation("cold_sweat:full_insulation"))) != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "requirement");
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source == DamageSource.f_19309_ && event.getEntity().m_6844_(EquipmentSlot.FEET).m_150930_(ModItems.HOGLIN_HOOVES)) {
            event.setCanceled(true);
        }
    }
}

