/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ColdSweatConfig;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TempEffectsCommon {
    @SubscribeEvent
    public static void onPlayerMine(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (!ColdSweatConfig.getInstance().coldMining() || player.m_21023_(ModEffects.ICE_RESISTANCE) || player.m_21023_(ModEffects.GRACE)) {
            return;
        }
        float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
        if (temp < -50.0f) {
            float minMiningSpeed = CSMath.blend(0.25f, 1.0f, TempEffectsCommon.getTempResistance(player, true), 0.0f, 4.0f);
            event.setNewSpeed(event.getNewSpeed() * CSMath.blend(minMiningSpeed, 1.0f, temp, -100.0f, -50.0f));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float temp;
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && (temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY)) < -50.0f) {
            float minMoveMultiplier;
            if (!ColdSweatConfig.getInstance().coldMovement() || player.m_21023_(ModEffects.ICE_RESISTANCE) || player.m_21023_(ModEffects.GRACE)) {
                return;
            }
            if (!player.m_21255_() && (minMoveMultiplier = CSMath.blend(player.m_20096_() ? 0.5f : 0.8f, 1.0f, TempEffectsCommon.getTempResistance(player, true), 0.0f, 4.0f)) != 1.0f) {
                float moveSpeed = CSMath.blend(minMoveMultiplier, 1.0f, temp, -100.0f, -50.0f);
                player.m_20256_(player.m_20184_().m_82542_((double)moveSpeed, 1.0, (double)moveSpeed));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntity().m_21188_();
        if (livingEntity instanceof Player) {
            float liningProtFactor;
            Player player = (Player)livingEntity;
            if (!ColdSweatConfig.getInstance().coldKnockback() || player.m_21023_(ModEffects.ICE_RESISTANCE) || player.m_21023_(ModEffects.GRACE)) {
                return;
            }
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            if (temp < -50.0f && (liningProtFactor = CSMath.blend(0.5f, 1.0f, TempEffectsCommon.getTempResistance(player, true), 0.0f, 4.0f)) != 1.0f) {
                event.setStrength(event.getStrength() * CSMath.blend(liningProtFactor, 1.0f, temp, -100.0f, -50.0f));
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            float minFrozenHealth;
            Player player = (Player)livingEntity;
            if (!ColdSweatConfig.getInstance().freezingHearts() || player.m_21023_(ModEffects.ICE_RESISTANCE) || player.m_21023_(ModEffects.GRACE)) {
                return;
            }
            float healing = event.getAmount();
            float temp = (float)Temperature.get((LivingEntity)player, Temperature.Trait.BODY);
            if (temp < -50.0f && (minFrozenHealth = CSMath.blend(0.5f, 1.0f, TempEffectsCommon.getTempResistance(player, true), 0.0f, 4.0f)) != 1.0f) {
                event.setAmount(CSMath.clamp(healing, 0.0f, (float)CSMath.ceil(player.m_21233_() * CSMath.blend(minFrozenHealth, 1.0f, temp, -100.0f, -50.0f)) - player.m_21223_()));
            }
        }
    }

    public static int getTempResistance(Player player, boolean cold) {
        int strength = 0;
        if (CompatManager.isArmorUnderwearLoaded()) {
            strength += ((Collection)player.m_6168_()).stream().map(stack -> cold ? CompatManager.hasOttoLiner(stack) : CompatManager.hasOllieLiner(stack)).filter(Boolean::booleanValue).mapToInt(i -> 1).sum();
        }
        strength = (int)((float)strength + CSMath.blend(0.0f, 4.0f, ((Number)CSMath.getIfNotNull(cold ? player.m_21051_(ModAttributes.COLD_RESISTANCE) : player.m_21051_(ModAttributes.HEAT_RESISTANCE), att -> att.m_22135_(), 0)).floatValue(), 0.0f, 1.0f));
        return CSMath.clamp(strength, 0, 4);
    }
}

