/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event.capability;

import com.google.common.collect.ImmutableSet;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.GatherDefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FireTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.UndergroundTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.temperature.AbstractTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.common.event.capability.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.InsulatingMount;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class EntityTempManager {
    public static final Temperature.Trait[] VALID_TEMPERATURE_TRAITS = new Temperature.Trait[]{Temperature.Trait.CORE, Temperature.Trait.BASE, Temperature.Trait.WORLD, Temperature.Trait.HEAT_RESISTANCE, Temperature.Trait.COLD_RESISTANCE, Temperature.Trait.HEAT_DAMPENING, Temperature.Trait.COLD_DAMPENING, Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT};
    public static final Temperature.Trait[] VALID_MODIFIER_TRAITS = new Temperature.Trait[]{Temperature.Trait.CORE, Temperature.Trait.BASE, Temperature.Trait.RATE, Temperature.Trait.WORLD, Temperature.Trait.HEAT_RESISTANCE, Temperature.Trait.COLD_RESISTANCE, Temperature.Trait.HEAT_DAMPENING, Temperature.Trait.COLD_DAMPENING, Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT};
    public static final Temperature.Trait[] VALID_ATTRIBUTE_TYPES = new Temperature.Trait[]{Temperature.Trait.WORLD, Temperature.Trait.BASE, Temperature.Trait.HEAT_RESISTANCE, Temperature.Trait.COLD_RESISTANCE, Temperature.Trait.HEAT_DAMPENING, Temperature.Trait.COLD_DAMPENING, Temperature.Trait.FREEZING_POINT, Temperature.Trait.BURNING_POINT};
    public static final Set<EntityType<? extends LivingEntity>> TEMPERATURE_ENABLED_ENTITIES = new HashSet<EntityType<? extends LivingEntity>>((Collection<EntityType<? extends LivingEntity>>)ImmutableSet.builder().add((Object)EntityType.f_20532_).build());
    public static final Map<Entity, LazyOptional<ITemperatureCap>> SERVER_CAP_CACHE = new HashMap<Entity, LazyOptional<ITemperatureCap>>();
    public static final Map<Entity, LazyOptional<ITemperatureCap>> CLIENT_CAP_CACHE = new HashMap<Entity, LazyOptional<ITemperatureCap>>();

    public static LazyOptional<ITemperatureCap> getTemperatureCap(Entity entity) {
        Map<Entity, LazyOptional<ITemperatureCap>> cache = entity.f_19853_.f_46443_ ? CLIENT_CAP_CACHE : SERVER_CAP_CACHE;
        return cache.computeIfAbsent(entity, e -> {
            LazyOptional cap = e.getCapability(entity instanceof Player ? ModCapabilities.PLAYER_TEMPERATURE : ModCapabilities.ENTITY_TEMPERATURE);
            cap.addListener(opt -> cache.remove(e));
            return cap;
        });
    }

    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)object;
            if (!TEMPERATURE_ENABLED_ENTITIES.contains(entity.m_6095_())) {
                return;
            }
            final AbstractTempCap tempCap = entity instanceof Player ? new PlayerTempCap() : new EntityTempCap();
            final LazyOptional capOptional = LazyOptional.of(() -> tempCap);
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == ModCapabilities.PLAYER_TEMPERATURE) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return tempCap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    tempCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "temperature"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void initModifiersOnEntity(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.f_19853_.m_5776_() && TEMPERATURE_ENABLED_ENTITIES.contains(living.m_6095_()) && living.m_20194_() != null) {
                living.m_20194_().execute(() -> {
                    for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                        GatherDefaultTempModifiersEvent gatherEvent = new GatherDefaultTempModifiersEvent(living, trait);
                        MinecraftForge.EVENT_BUS.post((Event)gatherEvent);
                        EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                            cap.clearModifiers(trait);
                            cap.getModifiers(trait).addAll(gatherEvent.getModifiers());
                        });
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void initAttributesFromOldCap(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (EntityTempManager.getEntitiesWithTemperature().contains(living.m_6095_()) && !living.getPersistentData().m_128441_("PersistentAttributes")) {
                TaskScheduler.schedule(() -> {
                    for (Temperature.Trait trait : VALID_ATTRIBUTE_TYPES) {
                        AttributeInstance attribute = EntityTempManager.getAttribute(trait, living);
                        if (attribute == null) continue;
                        attribute.m_22100_(attribute.m_22099_().m_22082_());
                        attribute.m_22132_();
                    }
                    living.getPersistentData().m_128365_("PersistentAttributes", (Tag)new CompoundTag());
                }, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!TEMPERATURE_ENABLED_ENTITIES.contains(entity.m_6095_())) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            if (!entity.f_19853_.f_46443_) {
                cap.tick(entity);
            } else {
                cap.tickDummy(entity);
            }
            for (Temperature.Trait trait : VALID_MODIFIER_TRAITS) {
                cap.getModifiers(trait).removeIf(modifier -> {
                    int expireTime = modifier.getExpireTime();
                    return modifier.setTicksExisted(modifier.getTicksExisted() + 1) > expireTime && expireTime != -1;
                });
            }
            if (entity instanceof Player && entity.f_19797_ % 60 == 0) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    @SubscribeEvent
    public static void returnFromEnd(PlayerEvent.Clone event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            Player oldPlayer = event.getOriginal();
            oldPlayer.reviveCaps();
            if (!event.isWasDeath()) {
                EntityTempManager.getTemperatureCap((Entity)event.getEntity()).ifPresent(cap -> EntityTempManager.getTemperatureCap((Entity)oldPlayer).ifPresent(cap::copy));
            }
            ((Collection)EntityTempManager.getTemperatureCap((Entity)oldPlayer).map(ITemperatureCap::getPersistentAttributes).orElse(new HashSet())).forEach(attr -> event.getEntity().m_21051_(attr).m_22100_(oldPlayer.m_21051_(attr).m_22115_()));
            oldPlayer.invalidateCaps();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void defineDefaultModifiers(GatherDefaultTempModifiersEvent event) {
        if (event.getEntity() instanceof Player && event.getTrait() == Temperature.Trait.WORLD) {
            event.addModifier(new BiomeTempModifier(25).tickRate(10), false, Placement.BEFORE_FIRST);
            event.addModifier(new UndergroundTempModifier().tickRate(10), false, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier(new BlockTempModifier().tickRate(4), false, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof UndergroundTempModifier));
            if (CompatManager.isSereneSeasonsLoaded()) {
                TempModifierRegistry.getValue(new ResourceLocation("sereneseasons:season")).ifPresent(mod -> event.addModifier(mod.tickRate(60), false, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier)));
            }
            if (CompatManager.isWeather2Loaded()) {
                TempModifierRegistry.getValue(new ResourceLocation("weather2:storm")).ifPresent(mod -> event.addModifier(mod.tickRate(60), false, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier)));
            }
        } else if (event.getTrait() == Temperature.Trait.WORLD && TEMPERATURE_ENABLED_ENTITIES.contains(event.getEntity().m_6095_())) {
            event.addModifier(new BiomeTempModifier(16).tickRate(40), false, Placement.BEFORE_FIRST);
            event.addModifier(new UndergroundTempModifier().tickRate(40), false, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof BiomeTempModifier));
            event.addModifier(new BlockTempModifier(4).tickRate(20), false, Placement.of(Placement.Mode.AFTER, Placement.Order.FIRST, mod -> mod instanceof UndergroundTempModifier));
            if (CompatManager.isSereneSeasonsLoaded()) {
                TempModifierRegistry.getValue(new ResourceLocation("sereneseasons:season")).ifPresent(mod -> event.addModifier(mod.tickRate(60), false, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier)));
            }
            if (CompatManager.isWeather2Loaded()) {
                TempModifierRegistry.getValue(new ResourceLocation("weather2:storm")).ifPresent(mod -> event.addModifier(mod.tickRate(60), false, Placement.of(Placement.Mode.BEFORE, Placement.Order.FIRST, mod2 -> mod2 instanceof UndergroundTempModifier)));
            }
        }
    }

    @SubscribeEvent
    public static void addSewingIngredientListener(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            final Player player = (Player)entity;
            player.f_36096_.m_38893_(new ContainerListener(){

                public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
                    Slot slot = menu.m_38853_(slotIndex);
                    if (!(slot instanceof ResultSlot) && slot.f_40218_ == player.m_150109_() && ConfigSettings.INSULATION_ITEMS.get().containsKey(stack.m_41720_())) {
                        player.m_7902_(new ResourceLocation[]{new ResourceLocation("cold_sweat", "sewing_table")});
                    }
                }

                public void m_142153_(AbstractContainerMenu menu, int slot, int value) {
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.f_19853_.f_46443_ && event.phase == TickEvent.Phase.START) {
            if (player.f_19797_ % 5 == 0) {
                if (WorldHelper.isInWater((Entity)player) || player.f_19797_ % 40 == 0 && WorldHelper.isRainingAt(player.f_19853_, player.m_20183_())) {
                    Temperature.addModifier((LivingEntity)player, new WaterTempModifier(0.01f).tickRate(5), Temperature.Trait.WORLD, false);
                }
                if (player.m_203117_()) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new FreezingTempModifier((float)player.m_146888_() / 13.5f).expires(5), Temperature.Trait.BASE);
                }
                if (player.m_6060_()) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new FireTempModifier().expires(5), Temperature.Trait.BASE);
                }
            }
            if (player.m_203117_() && player.m_146888_() > 0) {
                boolean hasIcePotion;
                AtomicReference<Double> insulation = new AtomicReference<Double>(0.0);
                boolean bl = hasIcePotion = player.m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get() != false;
                if (!hasIcePotion) {
                    Temperature.getModifier((LivingEntity)player, Temperature.Trait.RATE, ArmorInsulationTempModifier.class).ifPresent(insulModifier -> insulation.updateAndGet(v -> v + insulModifier.getNBT().m_128459_("Hot") + insulModifier.getNBT().m_128459_("Cold")));
                }
                if (!hasIcePotion && !(insulation.get() > 0.0) && (double)player.f_19797_ % Math.max(1.0, 37.0 - insulation.get()) == 0.0) {
                    player.m_146917_(player.m_146888_() - 1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void cancelFreezingDamage(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.f_146701_ && event.getEntity().m_21023_(ModEffects.ICE_RESISTANCE) && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInsulationUpdate(MobEffectEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().f_19853_.f_46443_ && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == ModEffects.INSULATION) {
                if (event instanceof MobEffectEvent.Added) {
                    MobEffectInstance effect = event.getEffectInstance();
                    TempModifier newMod = new BlockInsulationTempModifier(effect.m_19564_() + 1).expires(effect.m_19557_());
                    Temperature.addOrReplaceModifier((LivingEntity)player, newMod, Temperature.Trait.WORLD);
                } else if (event instanceof MobEffectEvent.Remove) {
                    Temperature.removeModifiers((LivingEntity)player, Temperature.Trait.WORLD, mod -> mod instanceof BlockInsulationTempModifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSleep(SleepFinishedTimeEvent event) {
        if (!event.getLevel().m_5776_()) {
            event.getLevel().m_6907_().forEach(player -> {
                if (player.m_5803_()) {
                    EntityTempManager.getTemperatureCap((Entity)player).ifPresent(cap -> {
                        double temp = cap.getTrait(Temperature.Trait.CORE);
                        cap.setTrait(Temperature.Trait.CORE, temp / 4.0);
                        Temperature.updateTemperature((LivingEntity)player, cap, true);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerRiding(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && !event.player.f_19853_.m_5776_() && event.player.f_19797_ % 5 == 0 && (player = event.player).m_20202_() != null) {
            Minecart minecart;
            Entity mount = player.m_20202_();
            if (mount instanceof Minecart && (minecart = (Minecart)mount).m_38178_().m_60734_() == ModBlocks.MINECART_INSULATION) {
                Temperature.addOrReplaceModifier((LivingEntity)player, new MountTempModifier(1.0, 1.0).tickRate(5).expires(5), Temperature.Trait.RATE);
            } else {
                InsulatingMount entityInsul = ConfigSettings.INSULATED_ENTITIES.get().get(mount.m_6095_());
                if (entityInsul != null && entityInsul.test(mount)) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new MountTempModifier(entityInsul.coldInsulation(), entityInsul.heatInsulation()).tickRate(5).expires(5), Temperature.Trait.RATE);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEatFood(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(event.getItem().m_41780_() != UseAnim.DRINK && event.getItem().m_41780_() != UseAnim.EAT || event.getEntity().f_19853_.f_46443_)) {
                float foodTemp = CSMath.getIfNotNull(ConfigSettings.FOOD_TEMPERATURES.get().get(event.getItem().m_41720_()), food -> food.test((Entity)player, event.getItem()) ? food.value() : 0.0, 0.0).floatValue();
                if (foodTemp != 0.0f) {
                    Temperature.addModifier((LivingEntity)player, new FoodTempModifier(foodTemp).expires(0), Temperature.Trait.CORE, true);
                } else if (event.getItem().m_41720_() == ModItems.SOUL_SPROUT) {
                    Temperature.addOrReplaceModifier((LivingEntity)player, new SoulSproutTempModifier().expires(900), Temperature.Trait.BASE);
                }
            }
        }
    }

    @SubscribeEvent
    public static void resetTempOnRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isEndConquered()) {
            EntityTempManager.getTemperatureCap((Entity)event.getEntity()).ifPresent(cap -> {
                cap.copy(new PlayerTempCap());
                if (!event.getEntity().f_19853_.f_46443_) {
                    Temperature.updateTemperature((LivingEntity)event.getEntity(), cap, true);
                }
            });
        }
    }

    public static Set<EntityType<? extends LivingEntity>> getEntitiesWithTemperature() {
        return ImmutableSet.copyOf(TEMPERATURE_ENABLED_ENTITIES);
    }

    public static void setAttribute(Temperature.Trait trait, LivingEntity entity, double value) {
        switch (trait) {
            case WORLD: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.WORLD_TEMPERATURE), att -> att.m_22100_(value));
                break;
            }
            case BASE: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.BASE_BODY_TEMPERATURE), att -> att.m_22100_(value));
                break;
            }
            case HEAT_RESISTANCE: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.HEAT_RESISTANCE), att -> att.m_22100_(value));
                break;
            }
            case COLD_RESISTANCE: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.COLD_RESISTANCE), att -> att.m_22100_(value));
                break;
            }
            case HEAT_DAMPENING: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.HEAT_DAMPENING), att -> att.m_22100_(value));
                break;
            }
            case COLD_DAMPENING: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.COLD_DAMPENING), att -> att.m_22100_(value));
                break;
            }
            case FREEZING_POINT: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.FREEZING_POINT), att -> att.m_22100_(value));
                break;
            }
            case BURNING_POINT: {
                CSMath.doIfNotNull(entity.m_21051_(ModAttributes.BURNING_POINT), att -> att.m_22100_(value));
            }
        }
    }

    @Nullable
    public static AttributeInstance getAttribute(Temperature.Trait trait, LivingEntity entity) {
        return switch (trait) {
            case Temperature.Trait.WORLD -> entity.m_21051_(ModAttributes.WORLD_TEMPERATURE);
            case Temperature.Trait.BASE -> entity.m_21051_(ModAttributes.BASE_BODY_TEMPERATURE);
            case Temperature.Trait.FREEZING_POINT -> entity.m_21051_(ModAttributes.FREEZING_POINT);
            case Temperature.Trait.BURNING_POINT -> entity.m_21051_(ModAttributes.BURNING_POINT);
            case Temperature.Trait.HEAT_RESISTANCE -> entity.m_21051_(ModAttributes.HEAT_RESISTANCE);
            case Temperature.Trait.COLD_RESISTANCE -> entity.m_21051_(ModAttributes.COLD_RESISTANCE);
            case Temperature.Trait.HEAT_DAMPENING -> entity.m_21051_(ModAttributes.HEAT_DAMPENING);
            case Temperature.Trait.COLD_DAMPENING -> entity.m_21051_(ModAttributes.COLD_DAMPENING);
            default -> throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        };
    }

    public static Collection<AttributeModifier> getAttributeModifiers(LivingEntity entity, AttributeInstance attribute, @Nullable AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation == null ? attribute.m_22122_() : attribute.m_22104_(operation));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = entity.m_6844_(slot)).m_41619_()) continue;
            modifiers.addAll(ItemInsulationManager.getAttributeModifiers(stack, attribute.m_22099_(), slot, operation, (Entity)entity));
        }
        return modifiers;
    }

    public static AttributeModifier makeAttributeModifier(Temperature.Trait trait, double value, AttributeModifier.Operation operation) {
        return switch (trait) {
            case Temperature.Trait.WORLD -> new AttributeModifier("World Temperature Modifier", value, operation);
            case Temperature.Trait.BASE -> new AttributeModifier("Base Body Temperature Modifier", value, operation);
            case Temperature.Trait.FREEZING_POINT -> new AttributeModifier("Freezing Point Modifier", value, operation);
            case Temperature.Trait.BURNING_POINT -> new AttributeModifier("Burning Point Modifier", value, operation);
            case Temperature.Trait.HEAT_RESISTANCE -> new AttributeModifier("Heat Resistance Modifier", value, operation);
            case Temperature.Trait.COLD_RESISTANCE -> new AttributeModifier("Cold Resistance Modifier", value, operation);
            case Temperature.Trait.HEAT_DAMPENING -> new AttributeModifier("Heat Dampening Modifier", value, operation);
            case Temperature.Trait.COLD_DAMPENING -> new AttributeModifier("Cold Dampening Modifier", value, operation);
            default -> throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("\"" + trait + "\" is not a valid trait!"));
        };
    }

    public static boolean isTemperatureAttribute(Attribute attribute) {
        return CSMath.containsAny(ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString(), (String[])Arrays.stream(VALID_ATTRIBUTE_TYPES).map(Temperature.Trait::m_7912_).toArray(String[]::new));
    }
}

