/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event.capability;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.ItemSettingsConfig;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Wearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ItemInsulationManager {
    public static Map<ItemStack, LazyOptional<IInsulatableCap>> ITEM_INSULATION_CAPS = new WeakHashMap<ItemStack, LazyOptional<IInsulatableCap>>();
    static ContainerListener INSULATION_LISTENER = new ContainerListener(){

        public void m_7934_(AbstractContainerMenu sendingContainer, int slot, ItemStack stack) {
            ItemStack containerStack = sendingContainer.m_38853_(slot).m_7993_();
            ItemInsulationManager.getInsulationCap(containerStack).ifPresent(cap -> containerStack.m_41784_().m_128391_((CompoundTag)cap.serializeNBT()));
        }

        public void m_142153_(AbstractContainerMenu sendingContainer, int slot, int value) {
        }
    };

    @SubscribeEvent
    public static void attachCapabilityToItemHandler(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (ItemInsulationManager.isInsulatable(stack)) {
            final ItemInsulationCap itemInsulationCap = new ItemInsulationCap();
            final LazyOptional capOptional = LazyOptional.of(() -> itemInsulationCap);
            final Capability<IInsulatableCap> capability = ModCapabilities.ITEM_INSULATION;
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                    if (cap == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return itemInsulationCap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    itemInsulationCap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "item_insulation"), (ICapabilityProvider)provider);
            CompoundTag stackNBT = NBTHelper.getTagOrEmpty(stack);
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                if (stackNBT.m_128471_("insulated")) {
                    stackNBT.m_128473_("insulated");
                    switch (armor.m_40402_()) {
                        case HEAD: {
                            itemInsulationCap.addInsulationItem(Items.f_42407_.m_7968_());
                            break;
                        }
                        case CHEST: {
                            itemInsulationCap.addInsulationItem(Items.f_42408_.m_7968_());
                            break;
                        }
                        case LEGS: {
                            itemInsulationCap.addInsulationItem(Items.f_42462_.m_7968_());
                            break;
                        }
                        case FEET: {
                            itemInsulationCap.addInsulationItem(Items.f_42463_.m_7968_());
                            break;
                        }
                        default: {
                            itemInsulationCap.addInsulationItem(ItemStack.f_41583_);
                        }
                    }
                }
            }
        }
    }

    public static LazyOptional<IInsulatableCap> getInsulationCap(ItemStack stack) {
        return ITEM_INSULATION_CAPS.computeIfAbsent(stack, s -> stack.getCapability(ModCapabilities.ITEM_INSULATION));
    }

    @SubscribeEvent
    public static void handleInventoryOpen(PlayerContainerEvent event) {
        event.getEntity().getPersistentData().m_128379_("InventoryOpen", event instanceof PlayerContainerEvent.Open);
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        event.getContainer().m_38893_(INSULATION_LISTENER);
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close event) {
        event.getContainer().m_38943_(INSULATION_LISTENER);
    }

    public static int getInsulationSlots(ItemStack item) {
        List<? extends Number> slots = ItemSettingsConfig.getInstance().getArmorInsulationSlots();
        return switch (LivingEntity.m_147233_((ItemStack)item)) {
            case EquipmentSlot.HEAD -> slots.get(0).intValue();
            case EquipmentSlot.CHEST -> slots.get(1).intValue();
            case EquipmentSlot.LEGS -> slots.get(2).intValue();
            case EquipmentSlot.FEET -> slots.get(3).intValue();
            default -> 0;
        };
    }

    public static boolean isInsulatable(ItemStack stack) {
        return stack.m_41720_() instanceof Wearable && !ConfigSettings.INSULATION_ITEMS.get().containsKey(stack.m_41720_());
    }

    public static List<AttributeModifier> getAttributeModifiers(ItemStack stack, Attribute attribute, EquipmentSlot slot, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation != null ? stack.m_41638_(slot).get((Object)attribute).stream().filter(mod -> mod.m_22217_() == operation).toList() : stack.m_41638_(slot).get((Object)attribute));
        ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
            for (Pair<ItemStack, List<Insulation>> pair : cap.getInsulation()) {
                CSMath.doIfNotNull(ConfigSettings.INSULATION_ITEMS.get().get(((ItemStack)pair.getFirst()).m_41720_()), insulator -> {
                    if (owner == null || insulator.test(owner, (ItemStack)pair.getFirst())) {
                        modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.m_22217_() == operation).toList());
                    }
                });
            }
        });
        CSMath.doIfNotNull(ConfigSettings.INSULATING_ARMORS.get().get(stack.m_41720_()), insulator -> {
            if (owner == null || insulator.test(owner, stack)) {
                modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.m_22217_() == operation).toList());
            }
        });
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiers(ItemStack stack, Attribute attribute, EquipmentSlot slot) {
        return ItemInsulationManager.getAttributeModifiers(stack, attribute, slot, null, null);
    }
}

