/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ColdSweatConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ColdSweatConfig INSTANCE;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<Integer> difficulty;
    public static final ForgeConfigSpec.ConfigValue<Double> maxHabitable;
    public static final ForgeConfigSpec.ConfigValue<Double> minHabitable;
    public static final ForgeConfigSpec.ConfigValue<Double> rateMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> tempDamage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fireResistanceEffect;
    public static final ForgeConfigSpec.ConfigValue<Boolean> iceResistanceEffect;
    public static final ForgeConfigSpec.ConfigValue<Boolean> damageScaling;
    public static final ForgeConfigSpec.ConfigValue<Boolean> requireThermometer;
    public static final ForgeConfigSpec.ConfigValue<Integer> gracePeriodLength;
    public static final ForgeConfigSpec.ConfigValue<Boolean> gracePeriodEnabled;
    public static final ForgeConfigSpec.ConfigValue<Boolean> heatstrokeFog;
    public static final ForgeConfigSpec.ConfigValue<Boolean> freezingHearts;
    public static final ForgeConfigSpec.ConfigValue<Boolean> coldKnockback;
    public static final ForgeConfigSpec.ConfigValue<Boolean> coldMining;
    public static final ForgeConfigSpec.ConfigValue<Boolean> coldMovement;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/main.toml");
    }

    public static ColdSweatConfig getInstance() {
        return INSTANCE;
    }

    public int getDifficulty() {
        return (Integer)difficulty.get();
    }

    public boolean isFireResistanceEnabled() {
        return (Boolean)fireResistanceEffect.get();
    }

    public boolean isIceResistanceEnabled() {
        return (Boolean)iceResistanceEffect.get();
    }

    public boolean thermometerRequired() {
        return (Boolean)requireThermometer.get();
    }

    public boolean doDamageScaling() {
        return (Boolean)damageScaling.get();
    }

    public double getTempDamage() {
        return (Double)tempDamage.get();
    }

    public double getMinTempHabitable() {
        return (Double)minHabitable.get();
    }

    public double getMaxTempHabitable() {
        return (Double)maxHabitable.get();
    }

    public double getRateMultiplier() {
        return (Double)rateMultiplier.get();
    }

    public int getGracePeriodLength() {
        return (Integer)gracePeriodLength.get();
    }

    public boolean isGracePeriodEnabled() {
        return (Boolean)gracePeriodEnabled.get();
    }

    public boolean heatstrokeFog() {
        return (Boolean)heatstrokeFog.get();
    }

    public boolean freezingHearts() {
        return (Boolean)freezingHearts.get();
    }

    public boolean coldKnockback() {
        return (Boolean)coldKnockback.get();
    }

    public boolean coldMining() {
        return (Boolean)coldMining.get();
    }

    public boolean coldMovement() {
        return (Boolean)coldMovement.get();
    }

    public synchronized void setDifficulty(int value) {
        difficulty.set((Object)value);
    }

    public synchronized void setMaxHabitable(double temp) {
        maxHabitable.set((Object)temp);
    }

    public synchronized void setMinHabitable(double temp) {
        minHabitable.set((Object)temp);
    }

    public synchronized void setRateMultiplier(double rate) {
        rateMultiplier.set((Object)rate);
    }

    public synchronized void setFireResistanceEnabled(boolean isEffective) {
        fireResistanceEffect.set((Object)isEffective);
    }

    public synchronized void setIceResistanceEnabled(boolean isEffective) {
        iceResistanceEffect.set((Object)isEffective);
    }

    public synchronized void setRequireThermometer(boolean required) {
        requireThermometer.set((Object)required);
    }

    public synchronized void setDamageScaling(boolean enabled) {
        damageScaling.set((Object)enabled);
    }

    public synchronized void setTempDamage(double damage) {
        tempDamage.set((Object)damage);
    }

    public synchronized void setGracePeriodLength(int ticks) {
        gracePeriodLength.set((Object)ticks);
    }

    public synchronized void setGracePeriodEnabled(boolean enabled) {
        gracePeriodEnabled.set((Object)enabled);
    }

    public synchronized void setHeatstrokeFog(boolean fog) {
        heatstrokeFog.set((Object)fog);
    }

    public synchronized void setFreezingHearts(boolean hearts) {
        freezingHearts.set((Object)hearts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdKnockback(boolean knockback) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = coldKnockback;
        synchronized (configValue) {
            coldKnockback.set((Object)knockback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdMining(boolean mining) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = coldMining;
        synchronized (configValue) {
            coldMining.set((Object)mining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdMovement(boolean movement) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = coldMovement;
        synchronized (configValue) {
            coldMovement.set((Object)movement);
        }
    }

    public void save() {
        SPEC.save();
    }

    static {
        INSTANCE = new ColdSweatConfig();
        BUILDER = new ForgeConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.push("Difficulty");
        difficulty = BUILDER.comment(new String[]{"Overrides all other config options for easy difficulty management", "This value is changed by the in-game config. It does nothing otherwise."}).defineInRange("Difficulty", defaultDiff.ordinal(), 0, ConfigSettings.Difficulty.values().length - 1);
        minHabitable = BUILDER.comment("Defines the minimum habitable temperature").defineInRange("Minimum Habitable Temperature", defaultDiff.getOrDefault("min_temp", Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true)).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        maxHabitable = BUILDER.comment("Defines the maximum habitable temperature").defineInRange("Maximum Habitable Temperature", defaultDiff.getOrDefault("max_temp", Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true)).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        rateMultiplier = BUILDER.comment("Rate at which the player's body temperature changes (default: 1.0 (100%))").defineInRange("Rate Multiplier", defaultDiff.getOrDefault("temp_rate", 1.0).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        tempDamage = BUILDER.comment("Damage dealt to the player when they are too hot or too cold").defineInRange("Temperature Damage", defaultDiff.getOrDefault("temp_damage", 2.0).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        damageScaling = BUILDER.comment("Sets whether damage scales with difficulty").define("Damage Scaling", (Object)defaultDiff.getOrDefault("damage_scaling", true));
        BUILDER.pop();
        BUILDER.push("Items");
        fireResistanceEffect = BUILDER.comment("Allow fire resistance to block overheating damage").define("Fire Resistance Immunity", (Object)defaultDiff.getOrDefault("fire_resistance_enabled", true));
        iceResistanceEffect = BUILDER.comment("Allow ice resistance to block freezing damage").define("Ice Resistance Immunity", (Object)defaultDiff.getOrDefault("ice_resistance_enabled", true));
        requireThermometer = BUILDER.comment("Thermometer item is required to see detailed world temperature").define("Require Thermometer", (Object)defaultDiff.getOrDefault("require_thermometer", true));
        BUILDER.pop();
        BUILDER.push("Temperature Effects");
        BUILDER.push("Hot");
        heatstrokeFog = BUILDER.comment("When set to true, the player's view distance will decrease when they are too hot").define("Heatstroke Fog", (Object)defaultDiff.getOrDefault("heatstroke_fog", true));
        BUILDER.pop();
        BUILDER.push("Cold");
        freezingHearts = BUILDER.comment("When set to true, some of the player's hearts will freeze when they are too cold, preventing regeneration").define("Freezing Hearts", (Object)defaultDiff.getOrDefault("freezing_hearts", true));
        coldKnockback = BUILDER.comment("When set to true, the player's attack knockback will be reduced when they are too cold").define("Cold Knockback Reduction", (Object)defaultDiff.getOrDefault("knockback_impairment", true));
        coldMovement = BUILDER.comment("When set to true, the player's movement speed will be reduced when they are too cold").define("Cold Slowness", (Object)defaultDiff.getOrDefault("cold_slowness", true));
        coldMining = BUILDER.comment("When set to true, the player's mining speed will be reduced when they are too cold").define("Cold Mining Fatigue", (Object)defaultDiff.getOrDefault("cold_break_speed", true));
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Grace Period");
        gracePeriodLength = BUILDER.comment("The number of ticks after the player spawns during which they are immune to temperature effects").defineInRange("Grace Period Length", defaultDiff.getOrDefault("grace_length", 6000).intValue(), 0, Integer.MAX_VALUE);
        gracePeriodEnabled = BUILDER.comment("Enables the grace period").define("Grace Period Enabled", (Object)defaultDiff.getOrDefault("grace_enabled", true));
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

