/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.api.event.core.EnableTemperatureEvent;
import com.momosoftworks.coldsweat.common.event.capability.EntityTempManager;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AddTempAttributes {
    @SubscribeEvent
    public static void onEntitiesCreated(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            if (type != EntityType.f_20532_) {
                EnableTemperatureEvent enableEvent = new EnableTemperatureEvent(type);
                ModLoader.get().postEvent((Event)enableEvent);
                if (!enableEvent.isEnabled() || enableEvent.isCanceled()) continue;
            }
            EntityTempManager.TEMPERATURE_ENABLED_ENTITIES.add((EntityType<? extends LivingEntity>)type);
            event.add(type, ModAttributes.COLD_DAMPENING, Double.NaN);
            event.add(type, ModAttributes.HEAT_DAMPENING, Double.NaN);
            event.add(type, ModAttributes.COLD_RESISTANCE, Double.NaN);
            event.add(type, ModAttributes.HEAT_RESISTANCE, Double.NaN);
            event.add(type, ModAttributes.BURNING_POINT, Double.NaN);
            event.add(type, ModAttributes.FREEZING_POINT, Double.NaN);
            event.add(type, ModAttributes.BASE_BODY_TEMPERATURE, Double.NaN);
            event.add(type, ModAttributes.WORLD_TEMPERATURE, Double.NaN);
        }
    }

    @SubscribeEvent
    public static void onEnableTemperatureEvent(EnableTemperatureEvent event) {
        if (event.getEntityType() == ModEntities.CHAMELEON) {
            event.setEnabled(true);
        }
    }
}

