/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.biome_modifier;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BiomeCodecInit;
import com.momosoftworks.coldsweat.data.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public record AddSpawnsBiomeModifier(boolean useConfigs) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.useConfigs) {
            Collection spawns = ConfigSettings.ENTITY_SPAWN_BIOMES.get().get((Object)((Biome)biome.m_203334_()));
            for (SpawnBiomeData spawn : spawns) {
                ConfigHelper.mapForgeRegistryTagList(ForgeRegistries.ENTITY_TYPES, spawn.entities()).forEach(entityType -> {
                    builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).removeIf(spawnerData -> spawnerData.f_48404_ == entityType);
                    builder.getMobSpawnSettings().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(entityType, spawn.weight(), 1, 1));
                });
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BiomeCodecInit.ADD_SPAWNS_CODEC.get();
    }
}

