/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;

public record EntityFlagsRequirement(Optional<Boolean> onFire, Optional<Boolean> sneaking, Optional<Boolean> sprinting, Optional<Boolean> swimming, Optional<Boolean> invisible, Optional<Boolean> glowing, Optional<Boolean> baby) {
    public static final Codec<EntityFlagsRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_on_fire").forGetter(predicate -> predicate.onFire), (App)Codec.BOOL.optionalFieldOf("is_sneaking").forGetter(predicate -> predicate.sneaking), (App)Codec.BOOL.optionalFieldOf("is_sprinting").forGetter(predicate -> predicate.sprinting), (App)Codec.BOOL.optionalFieldOf("is_swimming").forGetter(predicate -> predicate.swimming), (App)Codec.BOOL.optionalFieldOf("is_invisible").forGetter(predicate -> predicate.invisible), (App)Codec.BOOL.optionalFieldOf("is_glowing").forGetter(predicate -> predicate.glowing), (App)Codec.BOOL.optionalFieldOf("is_baby").forGetter(predicate -> predicate.baby)).apply((Applicative)instance, EntityFlagsRequirement::new));

    public boolean test(Entity entity) {
        AgeableMob mob;
        return !(!this.onFire.isEmpty() && entity.m_6060_() != this.onFire.get().booleanValue() || !this.sneaking.isEmpty() && entity.m_6047_() != this.sneaking.get().booleanValue() || !this.sprinting.isEmpty() && entity.m_20142_() != this.sprinting.get().booleanValue() || !this.swimming.isEmpty() && entity.m_20069_() != this.swimming.get().booleanValue() || !this.invisible.isEmpty() && entity.m_20145_() != this.invisible.get().booleanValue() || !this.glowing.isEmpty() && entity.m_142038_() != this.glowing.get().booleanValue() || !this.baby.isEmpty() && (entity instanceof AgeableMob && (mob = (AgeableMob)entity).m_6162_()) != this.baby.get());
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        this.onFire.ifPresent(value -> tag.m_128379_("is_on_fire", value.booleanValue()));
        this.sneaking.ifPresent(value -> tag.m_128379_("is_sneaking", value.booleanValue()));
        this.sprinting.ifPresent(value -> tag.m_128379_("is_sprinting", value.booleanValue()));
        this.swimming.ifPresent(value -> tag.m_128379_("is_swimming", value.booleanValue()));
        this.invisible.ifPresent(value -> tag.m_128379_("is_invisible", value.booleanValue()));
        this.glowing.ifPresent(value -> tag.m_128379_("is_glowing", value.booleanValue()));
        this.baby.ifPresent(value -> tag.m_128379_("is_baby", value.booleanValue()));
        return tag;
    }

    public static EntityFlagsRequirement deserialize(CompoundTag tag) {
        return new EntityFlagsRequirement(tag.m_128441_("is_on_fire") ? Optional.of(tag.m_128471_("is_on_fire")) : Optional.empty(), tag.m_128441_("is_sneaking") ? Optional.of(tag.m_128471_("is_sneaking")) : Optional.empty(), tag.m_128441_("is_sprinting") ? Optional.of(tag.m_128471_("is_sprinting")) : Optional.empty(), tag.m_128441_("is_swimming") ? Optional.of(tag.m_128471_("is_swimming")) : Optional.empty(), tag.m_128441_("is_invisible") ? Optional.of(tag.m_128471_("is_invisible")) : Optional.empty(), tag.m_128441_("is_glowing") ? Optional.of(tag.m_128471_("is_glowing")) : Optional.empty(), tag.m_128441_("is_baby") ? Optional.of(tag.m_128471_("is_baby")) : Optional.empty());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityFlagsRequirement that = (EntityFlagsRequirement)obj;
        return this.onFire.equals(that.onFire) && this.sneaking.equals(that.sneaking) && this.sprinting.equals(that.sprinting) && this.swimming.equals(that.swimming) && this.invisible.equals(that.invisible) && this.glowing.equals(that.glowing) && this.baby.equals(that.baby);
    }

    @Override
    public String toString() {
        return "EntityFlags{onFire=" + this.onFire + ", sneaking=" + this.sneaking + ", sprinting=" + this.sprinting + ", swimming=" + this.swimming + ", invisible=" + this.invisible + ", glowing=" + this.glowing + ", baby=" + this.baby + "}";
    }
}

