/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.FluidRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public record LocationRequirement(Optional<Integer> x, Optional<Integer> y, Optional<Integer> z, Optional<ResourceKey<Biome>> biome, Optional<ResourceKey<Structure>> structure, Optional<ResourceKey<Level>> dimension, Optional<IntegerBounds> light, Optional<BlockRequirement> block, Optional<FluidRequirement> fluid) {
    public static final Codec<LocationRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("x").forGetter(location -> location.x), (App)Codec.INT.optionalFieldOf("y").forGetter(location -> location.y), (App)Codec.INT.optionalFieldOf("z").forGetter(location -> location.z), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122885_).optionalFieldOf("biome").forGetter(location -> location.biome), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_235725_).optionalFieldOf("structure").forGetter(location -> location.structure), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).optionalFieldOf("dimension").forGetter(location -> location.dimension), (App)IntegerBounds.CODEC.optionalFieldOf("light").forGetter(location -> location.light), (App)BlockRequirement.CODEC.optionalFieldOf("block").forGetter(location -> location.block), (App)FluidRequirement.CODEC.optionalFieldOf("fluid").forGetter(location -> location.fluid)).apply((Applicative)instance, LocationRequirement::new));

    public boolean test(Level level, Vec3 pos) {
        return this.test(level, new BlockPos(pos));
    }

    public boolean test(Level level, BlockPos origin) {
        int light;
        BlockPos.MutableBlockPos pos = origin.m_122032_();
        this.x.ifPresent(x -> pos.m_122184_(x.intValue(), 0, 0));
        this.y.ifPresent(y -> pos.m_122184_(0, y.intValue(), 0));
        this.z.ifPresent(z -> pos.m_122184_(0, 0, z.intValue()));
        if (this.dimension.isPresent() && !level.m_46472_().equals(this.dimension.get())) {
            return false;
        }
        if (this.biome.isPresent() && !((ResourceKey)level.m_204166_((BlockPos)pos).m_203543_().get()).equals(this.biome.get())) {
            return false;
        }
        if (this.structure.isPresent() && WorldHelper.getServerLevel(level).m_215010_().m_220488_((BlockPos)pos, this.structure.get()) == StructureStart.f_73561_) {
            return false;
        }
        if (this.light.isPresent() && ((light = level.m_46803_((BlockPos)pos)) < this.light.get().min() || light > this.light.get().max())) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().test(level, (BlockPos)pos)) {
            return false;
        }
        return !this.fluid.isPresent() || this.fluid.get().test(level, (BlockPos)pos);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        this.x.ifPresent(value -> tag.m_128405_("x", value.intValue()));
        this.y.ifPresent(value -> tag.m_128405_("y", value.intValue()));
        this.z.ifPresent(value -> tag.m_128405_("z", value.intValue()));
        this.biome.ifPresent(value -> tag.m_128359_("biome", value.m_135782_().toString()));
        this.structure.ifPresent(value -> tag.m_128359_("structure", value.m_135782_().toString()));
        this.dimension.ifPresent(value -> tag.m_128359_("dimension", value.m_135782_().toString()));
        this.light.ifPresent(bounds -> tag.m_128365_("light", (Tag)bounds.serialize()));
        this.block.ifPresent(predicate -> tag.m_128365_("block", (Tag)predicate.serialize()));
        this.fluid.ifPresent(predicate -> tag.m_128365_("fluid", (Tag)predicate.serialize()));
        return tag;
    }

    public static LocationRequirement deserialize(CompoundTag tag) {
        Optional<Integer> x = tag.m_128441_("x") ? Optional.of(tag.m_128451_("x")) : Optional.empty();
        Optional<Integer> y = tag.m_128441_("y") ? Optional.of(tag.m_128451_("y")) : Optional.empty();
        Optional<Integer> z = tag.m_128441_("z") ? Optional.of(tag.m_128451_("z")) : Optional.empty();
        Optional<ResourceKey<Biome>> biome = tag.m_128441_("biome") ? Optional.of(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(tag.m_128461_("biome")))) : Optional.empty();
        Optional<ResourceKey<Structure>> structure = tag.m_128441_("structure") ? Optional.of(ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(tag.m_128461_("structure")))) : Optional.empty();
        Optional<ResourceKey<Level>> dimension = tag.m_128441_("dimension") ? Optional.of(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")))) : Optional.empty();
        Optional<IntegerBounds> light = tag.m_128441_("light") ? Optional.of(IntegerBounds.deserialize(tag.m_128469_("light"))) : Optional.empty();
        Optional<BlockRequirement> block = tag.m_128441_("block") ? Optional.of(BlockRequirement.deserialize(tag.m_128469_("block"))) : Optional.empty();
        Optional<FluidRequirement> fluid = tag.m_128441_("fluid") ? Optional.of(FluidRequirement.deserialize(tag.m_128469_("fluid"))) : Optional.empty();
        return new LocationRequirement(x, y, z, biome, structure, dimension, light, block, fluid);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationRequirement that = (LocationRequirement)obj;
        return this.x.equals(that.x) && this.y.equals(that.y) && this.z.equals(that.z) && this.biome.equals(that.biome) && this.structure.equals(that.structure) && this.dimension.equals(that.dimension) && this.light.equals(that.light) && this.block.equals(that.block) && this.fluid.equals(that.fluid);
    }

    @Override
    public String toString() {
        return "Location{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", biome=" + this.biome + ", structure=" + this.structure + ", dimension=" + this.dimension + ", light=" + this.light + ", block=" + this.block + ", fluid=" + this.fluid + "}";
    }
}

