/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.util.math.CSMath;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public record NbtRequirement(CompoundTag tag) {
    public static final Codec<NbtRequirement> CODEC = CompoundTag.f_128325_.xmap(NbtRequirement::deserialize, NbtRequirement::serialize);

    public boolean test(ItemStack pStack) {
        return this.tag().m_128456_() || this.test((Tag)pStack.m_41783_());
    }

    public boolean test(Entity pEntity) {
        return this.tag().m_128456_() || this.test((Tag)NbtPredicate.m_57485_((Entity)pEntity));
    }

    public boolean test(@Nullable Tag pTag) {
        if (pTag == null) {
            return this.tag().m_128456_();
        }
        return NbtRequirement.compareNbt((Tag)this.tag, pTag, true);
    }

    public CompoundTag serialize() {
        return this.tag;
    }

    public static NbtRequirement deserialize(CompoundTag nbt) {
        return new NbtRequirement(nbt);
    }

    public static boolean compareNbt(@Nullable Tag tag, @Nullable Tag other, boolean compareListTag) {
        if (tag == other) {
            return true;
        }
        if (tag == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundNbt1 = (CompoundTag)tag;
            CompoundTag compoundNbt2 = (CompoundTag)other;
            for (String s : compoundNbt1.m_128431_()) {
                Tag tag2;
                Tag tag1 = compoundNbt1.m_128423_(s);
                if (NbtRequirement.compareNbt(tag1, tag2 = compoundNbt2.m_128423_(s), compareListTag)) continue;
                return false;
            }
            return true;
        }
        if (tag instanceof ListTag && compareListTag) {
            ListTag listtag = (ListTag)tag;
            ListTag listtag1 = (ListTag)other;
            if (listtag.isEmpty()) {
                return listtag1.isEmpty();
            }
            for (int i = 0; i < listtag.size(); ++i) {
                Tag element = listtag.get(i);
                boolean flag = false;
                for (int j = 0; j < listtag1.size(); ++j) {
                    if (!NbtRequirement.compareNbt(element, listtag1.get(j), compareListTag)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                return false;
            }
            return true;
        }
        if (tag instanceof StringTag) {
            StringTag string = (StringTag)tag;
            if (other instanceof NumericTag) {
                NumericTag otherNumber = (NumericTag)other;
                try {
                    String[] ranges = string.m_7916_().split("-");
                    Double[] range = new Double[ranges.length];
                    for (int i = 0; i < ranges.length; ++i) {
                        range[i] = Double.parseDouble(ranges[i]);
                    }
                    if (range.length == 2) {
                        return CSMath.betweenInclusive(otherNumber.m_7061_(), range[0], range[1]);
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return tag.equals(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NbtRequirement that = (NbtRequirement)obj;
        return this.tag.equals((Object)that.tag);
    }

    @Override
    public String toString() {
        return "Nbt{tag=" + this.tag + "}";
    }
}

