/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public record BiomeTempData(List<Either<TagKey<Biome>, Biome>> biomes, double min, double max, Temperature.Units units, boolean isOffset, Optional<List<String>> requiredMods) {
    public static final Codec<BiomeTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.createForgeTagCodec(ForgeRegistries.BIOMES, Registry.f_122885_).listOf().fieldOf("biomes").forGetter(BiomeTempData::biomes), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("min_temp")).xmap(either -> {
        if (either.left().isPresent()) {
            return (Double)either.left().get();
        }
        if (either.right().isPresent()) {
            return (Double)either.right().get();
        }
        throw new IllegalArgumentException("Biome temperature min is not defined!");
    }, Either::right).forGetter(BiomeTempData::min), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("max_temp")).xmap(either -> {
        if (either.left().isPresent()) {
            return (Double)either.left().get();
        }
        if (either.right().isPresent()) {
            return (Double)either.right().get();
        }
        throw new IllegalArgumentException("Biome temperature min is not defined!");
    }, Either::right).forGetter(BiomeTempData::max), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(BiomeTempData::units), (App)Codec.BOOL.optionalFieldOf("is_offset", (Object)false).forGetter(BiomeTempData::isOffset), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(BiomeTempData::requiredMods)).apply((Applicative)instance, BiomeTempData::new));
}

