/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.LootEntry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddDropsModifier
extends LootModifier {
    public static Codec<AddDropsModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(modifier -> modifier.conditions), (App)LootEntry.CODEC.listOf().fieldOf("additions").forGetter(modifier -> modifier.additions)).apply((Applicative)inst, AddDropsModifier::new));
    private final List<LootEntry> additions;

    protected AddDropsModifier(LootItemCondition[] conditionsIn, List<LootEntry> additions) {
        super(conditionsIn);
        this.additions = additions;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootEntry entry : this.additions) {
            int countRange = entry.count().max() - entry.count().min();
            generatedLoot.add((Object)new ItemStack((ItemLike)entry.item(), context.m_230907_().m_216332_(entry.count().min().intValue(), entry.count().max().intValue()) + context.m_230907_().m_216332_(0, countRange * context.getLootingModifier())));
        }
        return generatedLoot;
    }

    public Codec<AddDropsModifier> codec() {
        return CODEC;
    }
}

