/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.exceptions.ArgumentCountException;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import oshi.util.tuples.Triplet;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static List<Block> getBlocks(String ... ids) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String id : ids) {
            if (id.startsWith("#")) {
                String tagID = id.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.BLOCKS.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(blockITag -> blocks.addAll(blockITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation blockId = new ResourceLocation(id);
            if (ForgeRegistries.BLOCKS.containsKey(blockId)) {
                blocks.add((Block)ForgeRegistries.BLOCKS.getValue(blockId));
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing block config: block \"{}\" does not exist", (Object)id);
        }
        return blocks;
    }

    public static Map<Block, Number> getBlocksWithValues(List<? extends List<?>> source) {
        HashMap<Block, Number> map = new HashMap<Block, Number>();
        for (List<?> entry : source) {
            String id = (String)entry.get(0);
            if (id.startsWith("#")) {
                String tagID = id.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.BLOCKS.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(itemITag -> {
                        for (Block block : ((ITag)optionalTag.get()).stream().toList()) {
                            map.put(block, (Number)entry.get(1));
                        }
                    });
                });
                continue;
            }
            Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            if (newBlock == null) continue;
            map.put(newBlock, (Number)entry.get(1));
        }
        return map;
    }

    public static List<Item> getItems(String ... ids) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String itemId : ids) {
            if (itemId.startsWith("#")) {
                String tagID = itemId.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.ITEMS.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(itemITag -> items.addAll(itemITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation itemID = new ResourceLocation(itemId);
            if (ForgeRegistries.ITEMS.containsKey(itemID)) {
                items.add((Item)ForgeRegistries.ITEMS.getValue(itemID));
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing item config: item \"{}\" does not exist", (Object)itemId);
        }
        return items;
    }

    public static Map<Biome, Triplet<Double, Double, Temperature.Units>> getBiomesWithValues(List<? extends List<?>> source, boolean absolute) {
        HashMap<Biome, Triplet<Double, Double, Temperature.Units>> map = new HashMap<Biome, Triplet<Double, Double, Temperature.Units>>();
        for (List<?> entry : source) {
            try {
                double max;
                double min;
                Temperature.Units units;
                ResourceLocation biomeId = new ResourceLocation((String)entry.get(0));
                Biome biome = WorldHelper.getBiome(biomeId);
                if (biome == null) {
                    ColdSweat.LOGGER.error("Error parsing biome config: biome \"{}\" does not exist or is not loaded yet", (Object)biomeId);
                    continue;
                }
                if (entry.size() > 2) {
                    units = entry.size() == 4 ? Temperature.Units.valueOf(((String)entry.get(3)).toUpperCase()) : Temperature.Units.MC;
                    min = Temperature.convert(((Number)entry.get(1)).doubleValue(), units, Temperature.Units.MC, absolute);
                    max = Temperature.convert(((Number)entry.get(2)).doubleValue(), units, Temperature.Units.MC, absolute);
                } else {
                    double mid = ((Number)entry.get(1)).doubleValue();
                    double variance = 1.0f / Math.max(1.0f, 2.0f + biome.m_47548_() * 2.0f);
                    min = mid - variance;
                    max = mid + variance;
                    units = Temperature.Units.MC;
                }
                map.put(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)min, (Object)max, (Object)units));
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Error parsing biome config: biome \"{}\" does not exist or is not loaded yet.", entry.get(0));
            }
        }
        return map;
    }

    public static Map<DimensionType, Pair<Double, Temperature.Units>> getDimensionsWithValues(List<? extends List<?>> source, boolean absolute) {
        HashMap<DimensionType, Pair<Double, Temperature.Units>> map = new HashMap<DimensionType, Pair<Double, Temperature.Units>>();
        for (List<?> entry : source) {
            try {
                ResourceLocation dimensionId = new ResourceLocation((String)entry.get(0));
                double temp = ((Number)entry.get(1)).doubleValue();
                Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
                DimensionType dimension = (DimensionType)WorldHelper.getRegistry(Registry.f_122818_).m_7745_(dimensionId);
                if (dimension != null) {
                    map.put(dimension, (Pair<Double, Temperature.Units>)Pair.of((Object)Temperature.convert(temp, units, Temperature.Units.MC, absolute), (Object)((Object)units)));
                    continue;
                }
                ColdSweat.LOGGER.error("Error parsing dimension config: dimension \"{}\" does not exist", (Object)dimensionId);
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Error parsing dimension config: dimension \"{}\" does not exist or is not loaded yet", entry.get(0));
            }
        }
        return map;
    }

    public static Map<Structure, Pair<Double, Temperature.Units>> getStructuresWithValues(List<? extends List<?>> source, boolean absolute) {
        HashMap<Structure, Pair<Double, Temperature.Units>> map = new HashMap<Structure, Pair<Double, Temperature.Units>>();
        for (List<?> entry : source) {
            try {
                ResourceLocation structureId = new ResourceLocation((String)entry.get(0));
                double temp = ((Number)entry.get(1)).doubleValue();
                Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
                map.put((Structure)WorldHelper.getRegistry(Registry.f_235725_).m_7745_(structureId), (Pair<Double, Temperature.Units>)Pair.of((Object)Temperature.convert(temp, units, Temperature.Units.MC, absolute), (Object)((Object)units)));
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Error parsing structure config: dimension \"{}\" does not exist or is not loaded yet", (Object)entry.toString());
            }
        }
        return map;
    }

    public static Map<String, Predicate<BlockState>> getBlockStatePredicates(Block block, String predicates) {
        String[] predicateList;
        HashMap<String, Predicate<BlockState>> blockPredicates = new HashMap<String, Predicate<BlockState>>();
        for (String predicate : predicateList = predicates.split(",")) {
            String[] pair = predicate.split("=");
            String key = pair[0];
            String value = pair[1];
            Property property = block.m_49965_().m_61081_(key);
            if (property == null) continue;
            property.m_6215_(value).ifPresent(propertyValue -> blockPredicates.put(predicate, state -> state.m_61143_(property).equals(propertyValue)));
        }
        return blockPredicates;
    }

    public static List<Biome> getBiomes(String ... biomes) {
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        for (String biome : biomes) {
            if (biome.startsWith("#")) {
                String tagID = biome.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.BIOMES.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(biomeITag -> biomeList.addAll(biomeITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation biomeId = new ResourceLocation(biome);
            Biome biomeObj = ConfigHelper.getBiome(biomeId);
            if (biomeObj == null) {
                ColdSweat.LOGGER.error("Error parsing biome config: biome \"{}\" does not exist", (Object)biome);
                continue;
            }
            biomeList.add(biomeObj);
        }
        return biomeList;
    }

    public static List<EntityType<?>> getEntityTypes(String ... entities) {
        ArrayList entityList = new ArrayList();
        for (String entity : entities) {
            if (entity.startsWith("#")) {
                String tagID = entity.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.ENTITY_TYPES.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(entityITag -> entityList.addAll(entityITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation entityId = new ResourceLocation(entity);
            if (ForgeRegistries.ENTITY_TYPES.containsKey(entityId)) {
                entityList.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId));
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing entity config: entity \"{}\" does not exist", (Object)entity);
        }
        return entityList;
    }

    public static CompoundTag serializeNbtBool(boolean value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtInt(int value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtDouble(double value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtString(String value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(key, value);
        return tag;
    }

    public static CompoundTag serializeBiomeTemps(Map<Biome, Triplet<Double, Double, Temperature.Units>> map, String key) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<Biome, Triplet<Double, Double, Temperature.Units>> entry : map.entrySet()) {
            CompoundTag biomeTag = new CompoundTag();
            ResourceLocation biomeId = ConfigHelper.getBiomeId(entry.getKey());
            if (biomeId == null) {
                ColdSweat.LOGGER.error("Error serializing biome temperatures: biome \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            biomeTag.m_128347_("Min", ((Double)entry.getValue().getA()).doubleValue());
            biomeTag.m_128347_("Max", ((Double)entry.getValue().getB()).doubleValue());
            biomeTag.m_128359_("Units", ((Temperature.Units)((Object)entry.getValue().getC())).toString());
            mapTag.m_128365_(biomeId.toString(), (Tag)biomeTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<Biome, Triplet<Double, Double, Temperature.Units>> deserializeBiomeTemps(CompoundTag tag, String key) {
        HashMap<Biome, Triplet<Double, Double, Temperature.Units>> map = new HashMap<Biome, Triplet<Double, Double, Temperature.Units>>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String biomeID : mapTag.m_128431_()) {
            CompoundTag biomeTag = mapTag.m_128469_(biomeID);
            Biome biome = ConfigHelper.getBiome(new ResourceLocation(biomeID));
            if (biome == null) {
                ColdSweat.LOGGER.error("Error deserializing biome temperatures: biome \"{}\" does not exist", (Object)biomeID);
                continue;
            }
            map.put(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)biomeTag.m_128459_("Min"), (Object)biomeTag.m_128459_("Max"), (Object)Temperature.Units.valueOf(biomeTag.m_128461_("Units"))));
        }
        return map;
    }

    public static CompoundTag serializeDimensionTemps(Map<DimensionType, Pair<Double, Temperature.Units>> map, String key) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<DimensionType, Pair<Double, Temperature.Units>> entry : map.entrySet()) {
            CompoundTag dimensionTag = new CompoundTag();
            ResourceLocation dimensionId = ConfigHelper.getDimensionId(entry.getKey());
            if (dimensionId == null) {
                ColdSweat.LOGGER.error("Error serializing dimension temperatures: dimension \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            mapTag.m_128365_(dimensionId.toString(), (Tag)dimensionTag);
            dimensionTag.m_128347_("Temp", ((Double)entry.getValue().getFirst()).doubleValue());
            dimensionTag.m_128359_("Units", ((Temperature.Units)((Object)entry.getValue().getSecond())).toString());
            mapTag.m_128365_(dimensionId.toString(), (Tag)dimensionTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<DimensionType, Pair<Double, Temperature.Units>> deserializeDimensionTemps(CompoundTag tag, String key) {
        HashMap<DimensionType, Pair<Double, Temperature.Units>> map = new HashMap<DimensionType, Pair<Double, Temperature.Units>>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String dimensionId : mapTag.m_128431_()) {
            CompoundTag biomeTag = mapTag.m_128469_(dimensionId);
            DimensionType dimension = ConfigHelper.getDimension(new ResourceLocation(dimensionId));
            if (dimension == null) {
                ColdSweat.LOGGER.error("Error deserializing dimension temperatures: dimension \"{}\" does not exist", (Object)dimensionId);
                continue;
            }
            map.put(dimension, (Pair<Double, Temperature.Units>)Pair.of((Object)biomeTag.m_128459_("Temp"), (Object)((Object)Temperature.Units.valueOf(biomeTag.m_128461_("Units")))));
        }
        return map;
    }

    public static CompoundTag serializeStructureTemps(Map<Structure, Pair<Double, Temperature.Units>> map, String key) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<Structure, Pair<Double, Temperature.Units>> entry : map.entrySet()) {
            CompoundTag structureTag = new CompoundTag();
            ResourceLocation structureId = ConfigHelper.getStructureId(entry.getKey());
            if (structureId == null) {
                ColdSweat.LOGGER.error("Error serializing structure temperatures: structure \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            mapTag.m_128365_(structureId.toString(), (Tag)structureTag);
            structureTag.m_128347_("Temp", ((Double)entry.getValue().getFirst()).doubleValue());
            structureTag.m_128359_("Units", ((Temperature.Units)((Object)entry.getValue().getSecond())).toString());
            mapTag.m_128365_(structureId.toString(), (Tag)structureTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<Structure, Pair<Double, Temperature.Units>> deserializeStructureTemps(CompoundTag tag, String key) {
        HashMap<Structure, Pair<Double, Temperature.Units>> map = new HashMap<Structure, Pair<Double, Temperature.Units>>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String structureId : mapTag.m_128431_()) {
            CompoundTag biomeTag = mapTag.m_128469_(structureId);
            Structure structure = ConfigHelper.getStructure(new ResourceLocation(structureId));
            if (structure == null) {
                ColdSweat.LOGGER.error("Error deserializing structure temperatures: structure \"{}\" does not exist", (Object)structureId);
                continue;
            }
            map.put(structure, (Pair<Double, Temperature.Units>)Pair.of((Object)biomeTag.m_128459_("Temp"), (Object)((Object)Temperature.Units.valueOf(biomeTag.m_128461_("Units")))));
        }
        return map;
    }

    public static <T> CompoundTag serializeItemMap(Map<Item, T> map, String key, Function<T, CompoundTag> serializer) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<Item, T> entry : map.entrySet()) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)entry.getKey());
            if (itemId == null) {
                ColdSweat.LOGGER.error("Error serializing item map: item \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            mapTag.m_128365_(itemId.toString(), (Tag)serializer.apply(entry.getValue()));
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static <T> Map<Item, T> deserializeItemMap(CompoundTag tag, String key, Function<CompoundTag, T> deserializer) {
        HashMap<Item, T> map = new HashMap<Item, T>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String itemID : mapTag.m_128431_()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID));
            map.put(item, deserializer.apply(mapTag.m_128469_(itemID)));
        }
        return map;
    }

    public static <T> Map<Item, T> readItemMap(List<? extends List<?>> source, BiFunction<Item, List<?>, T> valueParser) {
        HashMap<Item, T> map = new HashMap<Item, T>();
        for (List<?> entry : source) {
            String itemId = (String)entry.get(0);
            for (Item item : ConfigHelper.getItems(itemId)) {
                map.put(item, valueParser.apply(item, entry.subList(1, entry.size())));
            }
        }
        return map;
    }

    public static <T> void writeItemMap(Map<Item, T> map, Consumer<List<? extends List<?>>> saver, Function<T, List<?>> valueWriter) {
        ArrayList list = new ArrayList();
        for (Map.Entry<Item, T> entry : map.entrySet()) {
            Item item = entry.getKey();
            T value = entry.getValue();
            ArrayList<String> itemData = new ArrayList<String>();
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemID == null) {
                ColdSweat.LOGGER.error("Error writing item map: item \"{}\" does not exist", (Object)item);
                continue;
            }
            itemData.add(itemID.toString());
            itemData.addAll((Collection)valueWriter.apply(value));
            list.add(itemData);
        }
        saver.accept(list);
    }

    public static CompoundTag serializeItemInsulations(Map<Item, Insulator> map, String key) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<Item, Insulator> entry : map.entrySet()) {
            Item item = entry.getKey();
            Insulator insulator = entry.getValue();
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemID == null) {
                ColdSweat.LOGGER.error("Error serializing item insulations: item \"{}\" does not exist", (Object)item);
                continue;
            }
            mapTag.m_128365_(itemID.toString(), (Tag)insulator.serialize());
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<Item, Insulator> deserializeItemInsulations(CompoundTag tag, String key) {
        HashMap<Item, Insulator> map = new HashMap<Item, Insulator>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String itemID : mapTag.m_128431_()) {
            CompoundTag insulatorTag = mapTag.m_128469_(itemID);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID));
            if (item == null) {
                ColdSweat.LOGGER.error("Error deserializing item insulations: item \"{}\" does not exist", (Object)itemID);
                continue;
            }
            Insulator insulator = Insulator.deserialize(insulatorTag);
            map.put(item, insulator);
        }
        return map;
    }

    public static Map<Item, Insulator> readItemInsulations(List<? extends List<?>> items, Insulation.Slot slot) {
        return ConfigHelper.readItemMap(items, (item, args) -> {
            if (args.size() < 2) {
                throw (ArgumentCountException)ColdSweat.LOGGER.throwing((Throwable)new ArgumentCountException(args.size(), 2, String.format("Error parsing insulation config for item %s", item)));
            }
            double value1 = ((Number)args.get(0)).doubleValue();
            double value2 = ((Number)args.get(1)).doubleValue();
            String type = args.size() > 2 ? (String)args.get(2) : "static";
            CompoundTag nbt = args.size() > 3 ? NBTHelper.parseCompoundNbt((String)args.get(3)) : new CompoundTag();
            Insulation insulation = type.equals("static") ? new StaticInsulation(value1, value2) : new AdaptiveInsulation(value1, value2);
            ItemRequirement requirement = new ItemRequirement(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new NbtRequirement(nbt));
            return new Insulator(insulation, slot, requirement, EntityRequirement.NONE, new AttributeModifierMap());
        });
    }

    public static void writeItemInsulations(Map<Item, Insulator> items, Consumer<List<? extends List<?>>> saver) {
        ConfigHelper.writeItemMap(items, saver, insulator -> {
            if (insulator.predicate().equals(EntityRequirement.NONE)) {
                return List.of();
            }
            ArrayList<Object> itemData = new ArrayList<Object>();
            itemData.add(insulator.insulation() instanceof StaticInsulation ? insulator.insulation().getCold() : ((AdaptiveInsulation)insulator.insulation()).getInsulation());
            itemData.add(insulator.insulation() instanceof StaticInsulation ? insulator.insulation().getHeat() : ((AdaptiveInsulation)insulator.insulation()).getSpeed());
            itemData.add(insulator.insulation() instanceof StaticInsulation ? "static" : "adaptive");
            itemData.add(insulator.data().nbt().serialize().toString());
            return itemData;
        });
    }

    public static <T> List<T> mapForgeRegistryTagList(IForgeRegistry<T> registry, List<Either<TagKey<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        for (Either<TagKey<T>, T> either : eitherList) {
            either.ifLeft(tagKey -> list.addAll(registry.tags().getTag(tagKey).stream().toList()));
            either.ifRight(object -> list.add(object));
        }
        return list;
    }

    public static <T> List<T> mapVanillaRegistryTagList(ResourceKey<Registry<T>> registry, List<Either<TagKey<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        for (Either<TagKey<T>, T> either : eitherList) {
            either.ifLeft(tagKey -> list.addAll(((HolderSet.Named)WorldHelper.getRegistry(registry).m_203431_(tagKey).orElseThrow()).m_203614_().map(holder -> holder.get()).toList()));
            either.ifRight(list::add);
        }
        return list;
    }

    public static <T> Codec<Either<TagKey<T>, T>> createForgeTagCodec(IForgeRegistry<T> forgeRegistry, ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.STRING.xmap(objectPath -> {
            if (objectPath.startsWith("#")) {
                return Either.left((Object)new TagKey(vanillaRegistry, new ResourceLocation(objectPath.substring(1))));
            }
            return Either.right((Object)forgeRegistry.getValue(new ResourceLocation(objectPath)));
        }, objectEither -> (String)objectEither.map(tagKey -> "#" + tagKey.f_203868_(), object -> forgeRegistry.getKey(object).toString()));
    }

    public static <T> Codec<Either<TagKey<T>, T>> createVanillaTagCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.STRING.xmap(objectPath -> {
            if (objectPath.startsWith("#")) {
                return Either.left((Object)new TagKey(vanillaRegistry, new ResourceLocation(objectPath.substring(1))));
            }
            return Either.right(ConfigHelper.getVanillaRegistryValue(vanillaRegistry, new ResourceLocation(objectPath)).orElseThrow());
        }, objectEither -> (String)objectEither.map(tagKey -> "#" + tagKey.f_203868_(), object -> ConfigHelper.getVanillaRegistryKey(vanillaRegistry, object).orElseThrow().toString()));
    }

    public static <T> Optional<T> getVanillaRegistryValue(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        try {
            return Optional.ofNullable(WorldHelper.getRegistry(registry).m_7745_(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<ResourceLocation> getVanillaRegistryKey(ResourceKey<Registry<T>> registry, T value) {
        try {
            return Optional.ofNullable(WorldHelper.getRegistry(registry).m_7981_(value));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static Biome getBiome(ResourceLocation biomeId) {
        return CSMath.orElse((Biome)ForgeRegistries.BIOMES.getValue(biomeId), ConfigHelper.getVanillaRegistryValue(Registry.f_122885_, biomeId).orElse(null));
    }

    @Nullable
    public static ResourceLocation getBiomeId(Biome biome) {
        return CSMath.orElse(ForgeRegistries.BIOMES.getKey((Object)biome), ConfigHelper.getVanillaRegistryKey(Registry.f_122885_, biome).orElse(null));
    }

    @Nullable
    public static DimensionType getDimension(ResourceLocation dimensionId) {
        return ConfigHelper.getVanillaRegistryValue(Registry.f_122818_, dimensionId).orElse(null);
    }

    @Nullable
    public static ResourceLocation getDimensionId(DimensionType dimension) {
        return ConfigHelper.getVanillaRegistryKey(Registry.f_122818_, dimension).orElse(null);
    }

    @Nullable
    public static Structure getStructure(ResourceLocation structureId) {
        return ConfigHelper.getVanillaRegistryValue(Registry.f_235725_, structureId).orElse(null);
    }

    @Nullable
    public static ResourceLocation getStructureId(Structure structure) {
        return ConfigHelper.getVanillaRegistryKey(Registry.f_235725_, structure).orElse(null);
    }
}

