/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class NBTHelper {
    private NBTHelper() {
    }

    public static CompoundTag modifierToTag(TempModifier modifier) {
        CompoundTag modifierTag = new CompoundTag();
        modifierTag.m_128359_("Id", TempModifierRegistry.getKey(modifier).toString());
        modifierTag.m_128365_("ModifierData", (Tag)modifier.getNBT());
        if (modifier.getExpireTime() != -1) {
            modifierTag.m_128405_("ExpireTicks", modifier.getExpireTime());
        }
        if (modifier.getTickRate() > 1) {
            modifierTag.m_128405_("TickRate", modifier.getTickRate());
        }
        modifierTag.m_128405_("TicksExisted", modifier.getTicksExisted());
        return modifierTag;
    }

    public static Optional<TempModifier> tagToModifier(CompoundTag modifierTag) {
        Optional<TempModifier> optional = TempModifierRegistry.getValue(new ResourceLocation(modifierTag.m_128461_("Id")));
        optional.ifPresent(modifier -> {
            modifier.setNBT(modifierTag.m_128469_("ModifierData"));
            if (modifierTag.m_128441_("ExpireTicks")) {
                modifier.expires(modifierTag.m_128451_("ExpireTicks"));
            }
            if (modifierTag.m_128441_("TickRate")) {
                modifier.tickRate(modifierTag.m_128451_("TickRate"));
            }
            modifier.setTicksExisted(modifierTag.m_128451_("TicksExisted"));
        });
        return optional;
    }

    public static void incrementTag(Object owner, String key, int amount) {
        NBTHelper.incrementTag(owner, key, amount, tag -> true);
    }

    public static int incrementTag(Object owner, String key, int amount, Predicate<Integer> predicate) {
        CompoundTag tag;
        if (owner instanceof Entity) {
            Entity entity = (Entity)owner;
            tag = entity.getPersistentData();
        } else if (owner instanceof ItemStack) {
            ItemStack stack = (ItemStack)owner;
            tag = stack.m_41784_();
        } else if (owner instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)owner;
            tag = blockEntity.getPersistentData();
        } else {
            return 0;
        }
        int value = tag.m_128451_(key);
        if (predicate.test(value)) {
            tag.m_128405_(key, value + amount);
        }
        return value + amount;
    }

    public static CompoundTag getTagOrEmpty(ItemStack stack) {
        return CSMath.orElse(stack.m_41783_(), new CompoundTag());
    }

    public static String getTraitTagKey(Temperature.Trait trait) {
        return trait.m_7912_();
    }

    @SubscribeEvent
    public static void convertTagsInContainer(PlayerContainerEvent.Open event) {
        NBTHelper.updateItemTags(event.getContainer().f_38839_.stream().map(Slot::m_7993_).toList());
    }

    private static void updateItemTags(Collection<ItemStack> items) {
        for (ItemStack stack : items) {
            Item item = stack.m_41720_();
            CompoundTag tag = NBTHelper.getTagOrEmpty(stack);
            if (item == ModItems.SOULSPRING_LAMP) {
                if (!tag.m_128441_("fuel")) continue;
                tag.m_128347_("Fuel", tag.m_128459_("fuel"));
                tag.m_128473_("fuel");
                continue;
            }
            if (item != ModItems.FILLED_WATERSKIN || !tag.m_128441_("temperature")) continue;
            tag.m_128347_("Temperature", tag.m_128459_("temperature"));
            tag.m_128473_("temperature");
        }
    }

    public static CompoundTag parseCompoundNbt(String tag) {
        try {
            return TagParser.m_129359_((String)tag);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Error parsing compound tag \"{}\": {}", (Object)tag, (Object)e.getMessage());
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    public static EntityRequirement readEntityPredicate(CompoundTag tag) {
        return EntityRequirement.deserialize(tag);
    }

    public static CompoundTag writeEntityRequirement(EntityRequirement predicate) {
        return predicate.serialize();
    }

    public static ListTag listTagOf(List<?> list) {
        ListTag tag = new ListTag();
        for (Object obj : list) {
            if (obj instanceof Tag) {
                Tag tg = (Tag)obj;
                tag.add((Object)tg);
                continue;
            }
            tag.add((Object)NBTHelper.writeValue(obj));
        }
        return tag;
    }

    @Nullable
    public static Object getValue(Tag tag) {
        if (tag instanceof IntTag) {
            IntTag integer = (IntTag)tag;
            return integer.m_7047_();
        }
        if (tag instanceof FloatTag) {
            FloatTag floating = (FloatTag)tag;
            return Float.valueOf(floating.m_7057_());
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return doubleTag.m_7061_();
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return longTag.m_7046_();
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return shortTag.m_7053_();
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.m_7063_();
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArray = (ByteArrayTag)tag;
            return byteArray.m_7916_();
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArray = (IntArrayTag)tag;
            return intArray.m_128648_();
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArray = (LongArrayTag)tag;
            return longArray.m_128851_();
        }
        if (tag instanceof StringTag) {
            StringTag string = (StringTag)tag;
            return string.m_7916_();
        }
        return null;
    }

    @Nullable
    public static Tag writeValue(Object obj) {
        if (obj instanceof Integer) {
            Integer integer = (Integer)obj;
            return IntTag.m_128679_((int)integer);
        }
        if (obj instanceof Float) {
            Float floating = (Float)obj;
            return FloatTag.m_128566_((float)floating.floatValue());
        }
        if (obj instanceof Double) {
            Double doubleTag = (Double)obj;
            return DoubleTag.m_128500_((double)doubleTag);
        }
        if (obj instanceof Long) {
            Long longTag = (Long)obj;
            return LongTag.m_128882_((long)longTag);
        }
        if (obj instanceof Short) {
            Short shortTag = (Short)obj;
            return ShortTag.m_129258_((short)shortTag);
        }
        if (obj instanceof Byte) {
            Byte byteTag = (Byte)obj;
            return ByteTag.m_128266_((byte)byteTag);
        }
        if (obj instanceof String) {
            String string = (String)obj;
            return StringTag.m_129297_((String)string);
        }
        return null;
    }
}

