/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat;

import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.common.capability.temperature.EntityTempCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.config.ConfigUpdater;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.AttributeInit;
import com.momosoftworks.coldsweat.core.init.BiomeCodecInit;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.BlockInit;
import com.momosoftworks.coldsweat.core.init.CommandInit;
import com.momosoftworks.coldsweat.core.init.EffectInit;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.core.init.FeatureInit;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.init.MenuInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.init.PotionInit;
import com.momosoftworks.coldsweat.core.init.SoundInit;
import com.momosoftworks.coldsweat.core.itemgroup.InsulationItemsGroup;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="cold_sweat")
public class ColdSweat {
    public static final Logger LOGGER = LogManager.getLogger((String)"Cold Sweat");
    public static final String MOD_ID = "cold_sweat";

    public ColdSweat() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::spawnPlacements);
        bus.addListener(this::registerCaps);
        bus.addListener(this::updateConfigs);
        if (CompatManager.isCuriosLoaded()) {
            bus.addListener(this::registerCurioSlots);
        }
        BlockInit.BLOCKS.register(bus);
        ItemInit.ITEMS.register(bus);
        EntityInit.ENTITY_TYPES.register(bus);
        BlockEntityInit.BLOCK_ENTITY_TYPES.register(bus);
        MenuInit.MENU_TYPES.register(bus);
        EffectInit.EFFECTS.register(bus);
        ParticleTypesInit.PARTICLES.register(bus);
        PotionInit.POTIONS.register(bus);
        SoundInit.SOUNDS.register(bus);
        FeatureInit.FEATURES.register(bus);
        BiomeCodecInit.BIOME_MODIFIER_SERIALIZERS.register(bus);
        AttributeInit.ATTRIBUTES.register(bus);
        CommandInit.ARGUMENTS.register(bus);
        WorldSettingsConfig.setup();
        ItemSettingsConfig.setup();
        MainSettingsConfig.setup();
        ClientSettingsConfig.setup();
        EntitySettingsConfig.setup();
        bus.addListener(event -> {
            event.create(new RegistryBuilder().setName(ModRegistries.INSULATOR_DATA.m_135782_()).dataPackRegistry(InsulatorData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.FUEL_DATA.m_135782_()).dataPackRegistry(FuelData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.FOOD_DATA.m_135782_()).dataPackRegistry(FoodData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.BLOCK_TEMP_DATA.m_135782_()).dataPackRegistry(BlockTempData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.BIOME_TEMP_DATA.m_135782_()).dataPackRegistry(BiomeTempData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.DIMENSION_TEMP_DATA.m_135782_()).dataPackRegistry(DimensionTempData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.STRUCTURE_TEMP_DATA.m_135782_()).dataPackRegistry(StructureTempData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.MOUNT_DATA.m_135782_()).dataPackRegistry(MountData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.ENTITY_SPAWN_BIOME_DATA.m_135782_()).dataPackRegistry(SpawnBiomeData.CODEC));
            event.create(new RegistryBuilder().setName(ModRegistries.DEPTH_TEMP_DATA.m_135782_()).dataPackRegistry(DepthTempData.CODEC));
        });
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ColdSweatPacketHandler.init();
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.TEMPERATURE_CHANGED);
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.SOUL_LAMP_FUELLED);
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.BLOCK_AFFECTS_TEMP);
            CriteriaTriggers.m_10595_((CriterionTrigger)ModAdvancementTriggers.ARMOR_INSULATED);
            InsulationItemsGroup.INSULATION_ITEMS.register();
        });
    }

    public void spawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register(ModEntities.CHAMELEON, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Chameleon::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(PlayerTempCap.class);
        event.register(EntityTempCap.class);
        event.register(ItemInsulationCap.class);
        event.register(ShearableFurCap.class);
    }

    public void updateConfigs(FMLCommonSetupEvent event) {
        ConfigUpdater.updateConfigs();
    }

    public void registerCurioSlots(InterModEnqueueEvent event) {
        event.enqueueWork(() -> InterModComms.sendTo((String)MOD_ID, (String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build()));
    }
}

