/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.util.serialization.NbtSerializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;

public abstract class Insulation
implements NbtSerializable {
    public static Codec<Insulation> getCodec() {
        return Codec.either(StaticInsulation.CODEC, AdaptiveInsulation.CODEC).xmap(either -> {
            if (either.left().isPresent()) {
                return (Insulation)either.left().get();
            }
            return (Insulation)either.right().get();
        }, insul -> {
            if (insul instanceof StaticInsulation) {
                return Either.left((Object)((StaticInsulation)insul));
            }
            return Either.right((Object)((AdaptiveInsulation)insul));
        });
    }

    public abstract boolean isEmpty();

    public abstract List<Insulation> split();

    public abstract double getCold();

    public abstract double getHeat();

    public static List<Insulation> sort(List<Insulation> pairs) {
        ArrayList<Insulation> newPairs = new ArrayList<Insulation>(pairs);
        newPairs.sort(Comparator.comparingDouble(pair -> {
            if (pair instanceof AdaptiveInsulation) {
                AdaptiveInsulation insul = (AdaptiveInsulation)pair;
                return Math.abs(insul.getInsulation()) >= 2.0 ? 7.0 : 6.0;
            }
            if (pair instanceof StaticInsulation) {
                StaticInsulation insul = (StaticInsulation)pair;
                double absCold = Math.abs(insul.getCold());
                double absHot = Math.abs(insul.getHeat());
                if (absCold >= 2.0 && absHot >= 2.0) {
                    return 2.0;
                }
                if (absCold >= 2.0) {
                    return 0.0;
                }
                if (absHot >= 2.0) {
                    return 4.0;
                }
                if (absCold >= 1.0 && absHot >= 1.0) {
                    return 3.0;
                }
                if (absCold >= 1.0) {
                    return 1.0;
                }
                if (absHot >= 1.0) {
                    return 5.0;
                }
                return 1.0;
            }
            return 0.0;
        }));
        return newPairs;
    }

    public static Insulation deserialize(CompoundTag tag) {
        if (tag.m_128441_("cold") && tag.m_128441_("heat")) {
            return StaticInsulation.deserialize(tag);
        }
        if (tag.m_128441_("insulation")) {
            return AdaptiveInsulation.deserialize(tag);
        }
        return null;
    }

    public static enum Type implements StringRepresentable
    {
        COLD("cold"),
        HEAT("heat"),
        NEUTRAL("neutral"),
        ADAPTIVE("adaptive");

        final String name;
        public static final Codec<Type> CODEC;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown insulation type: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(Type::byName, Type::m_7912_);
        }
    }

    public static enum Slot implements StringRepresentable
    {
        ITEM("item"),
        CURIO("curio"),
        ARMOR("armor");

        final String name;
        public static final Codec<Slot> CODEC;

        private Slot(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Slot byName(String name) {
            for (Slot type : Slot.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown insulation slot: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(Slot::byName, Slot::m_7912_);
        }
    }
}

