/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.registry;

import com.google.common.collect.ImmutableMap;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.exceptions.RegistryFailureException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class TempModifierRegistry {
    static Map<ResourceLocation, Supplier<TempModifier>> TEMP_MODIFIERS = new HashMap<ResourceLocation, Supplier<TempModifier>>();

    public static ImmutableMap<ResourceLocation, Supplier<TempModifier>> getEntries() {
        return ImmutableMap.copyOf(TEMP_MODIFIERS);
    }

    public static void register(ResourceLocation id, Supplier<TempModifier> supplier) {
        if (TEMP_MODIFIERS.containsKey(id)) {
            throw new RegistryFailureException(id, "TempModifier", String.format("Found duplicate TempModifier entries: %s (%s) %s (%s)", supplier.get().getClass().getName(), id, TEMP_MODIFIERS.get(id).getClass().getName(), id), null);
        }
        TEMP_MODIFIERS.put(id, supplier);
    }

    public static void flush() {
        TEMP_MODIFIERS.clear();
    }

    public static Optional<TempModifier> getValue(ResourceLocation id) {
        Supplier<TempModifier> mod = TEMP_MODIFIERS.get(id);
        if (mod != null) {
            return Optional.of(mod.get());
        }
        return Optional.empty();
    }

    public static ResourceLocation getKey(TempModifier modifier) {
        return TEMP_MODIFIERS.entrySet().stream().filter(entry -> ((TempModifier)((Supplier)entry.getValue()).get()).getClass().equals(modifier.getClass())).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new RuntimeException("Tried to get the key of an unregistered TempModifier! " + modifier.getClass().getSimpleName()));
    }
}

