/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HearthDebugRenderer {
    public static Map<BlockPos, Map<BlockPos, Collection<Direction>>> HEARTH_LOCATIONS = new HashMap<BlockPos, Map<BlockPos, Collection<Direction>>>();

    @SubscribeEvent
    public static void onLevelRendered(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && Minecraft.m_91087_().f_91066_.f_92063_ && ConfigSettings.HEARTH_DEBUG.get().booleanValue()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Frustum frustum = event.getFrustum();
            PoseStack ps = event.getPoseStack();
            Vec3 camPos = event.getCamera().m_90583_();
            Level level = player.f_19853_;
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexes = buffer.m_6299_((RenderType)RenderType.f_110371_);
            ps.m_85836_();
            ps.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
            Matrix4f matrix4f = ps.m_85850_().m_85861_();
            Matrix3f matrix3f = ps.m_85850_().m_85864_();
            BiConsumer<Vector3f, Vector4f> nw = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> ne = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> sw = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> se = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> nu = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> nd = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> su = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> sd = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> eu = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> ed = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_() + 1.0f, pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> wu = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_() + 1.0f, pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            };
            BiConsumer<Vector3f, Vector4f> wd = (pos, color) -> {
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexes.m_85982_(matrix4f, pos.m_122239_(), pos.m_122260_(), pos.m_122269_() + 1.0f).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            };
            ChunkAccess workingChunk = null;
            float viewDistance = (float)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue() * 2.0f;
            ArrayList<BlockPos> invalidHearths = new ArrayList<BlockPos>();
            for (Map.Entry<BlockPos, Map<BlockPos, Collection<Direction>>> entry : HEARTH_LOCATIONS.entrySet()) {
                if (!(level.m_7702_(entry.getKey()) instanceof HearthBlockEntity)) {
                    invalidHearths.add(entry.getKey());
                    continue;
                }
                if (HearthSaveDataHandler.DISABLED_HEARTHS.contains(Pair.of((Object)entry.getKey(), (Object)level.m_46472_().m_135782_().toString()))) continue;
                Map<BlockPos, Collection<Direction>> points = entry.getValue();
                for (Map.Entry<BlockPos, Collection<Direction>> pair : points.entrySet()) {
                    BlockPos pos2 = pair.getKey();
                    Collection<Direction> directions = pair.getValue();
                    float x = pos2.m_123341_();
                    float y = pos2.m_123342_();
                    float z = pos2.m_123343_();
                    float r = 1.0f;
                    float g = 0.7f;
                    float b = 0.6f;
                    float renderAlpha = CSMath.blend(1.0f, 0.0f, (float)CSMath.getDistance((Entity)player, x + 0.5f, y + 0.5f, z + 0.5f), 5.0f, viewDistance);
                    if (!(renderAlpha > 0.01f) || !frustum.m_113029_(new AABB(pos2))) continue;
                    ChunkPos chunkPos = new ChunkPos(pos2);
                    if (workingChunk == null || !workingChunk.m_7697_().equals((Object)chunkPos)) {
                        workingChunk = WorldHelper.getChunk((LevelAccessor)level, pos2);
                    }
                    if (workingChunk == null) continue;
                    if (workingChunk.m_8055_(pos2).m_60808_((BlockGetter)level, pos2).equals(Shapes.m_83144_())) {
                        LevelRenderer.m_109608_((PoseStack)ps, (VertexConsumer)vertexes, (double)x, (double)y, (double)z, (double)(x + 1.0f), (double)(y + 1.0f), (double)(z + 1.0f), (float)r, (float)g, (float)b, (float)renderAlpha);
                        continue;
                    }
                    if (directions.size() == 6) continue;
                    HashSet lines = Sets.newHashSet((Object[])new BiConsumer[]{nw, ne, sw, se, nu, nd, su, sd, eu, ed, wu, wd});
                    if (directions.contains(Direction.DOWN)) {
                        Stream.of(nd, sd, ed, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.UP)) {
                        Stream.of(nu, su, eu, wu).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.NORTH)) {
                        Stream.of(nw, ne, nu, nd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.SOUTH)) {
                        Stream.of(sw, se, su, sd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.WEST)) {
                        Stream.of(nw, sw, wu, wd).forEach(lines::remove);
                    }
                    if (directions.contains(Direction.EAST)) {
                        Stream.of(ne, se, eu, ed).forEach(lines::remove);
                    }
                    lines.forEach(line -> line.accept(new Vector3f(x, y, z), new Vector4f(r, g, b, renderAlpha)));
                }
            }
            invalidHearths.forEach(HEARTH_LOCATIONS::remove);
            RenderSystem.m_69461_();
            ps.m_85849_();
            buffer.m_109912_((RenderType)RenderType.f_110371_);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (event.phase == TickEvent.Phase.END && level != null && level.m_46467_() % 20L == 0L && Minecraft.m_91087_().f_91066_.f_92063_ && ConfigSettings.HEARTH_DEBUG.get().booleanValue()) {
            for (Pair<BlockPos, ResourceLocation> entry : HearthSaveDataHandler.HEARTH_POSITIONS) {
                BlockPos pos;
                BlockEntity blockEntity;
                if (!level.m_46472_().m_135782_().equals(entry.getSecond()) || !((blockEntity = level.m_7702_(pos = (BlockPos)entry.getFirst())) instanceof HearthBlockEntity)) continue;
                HearthBlockEntity hearth = (HearthBlockEntity)blockEntity;
                Set<BlockPos> lookup = hearth.getPathLookup();
                Map pathMap = HEARTH_LOCATIONS.computeIfAbsent(pos, k -> Maps.newHashMap());
                if (pathMap.size() == lookup.size()) continue;
                HEARTH_LOCATIONS.put(pos, lookup.stream().map(bp -> {
                    ArrayList<Direction> dirs = new ArrayList<Direction>();
                    for (Direction dir : Direction.values()) {
                        if (!lookup.contains(bp.m_121945_(dir))) continue;
                        dirs.add(dir);
                    }
                    return Map.entry(bp, dirs);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, Maps::newHashMap)));
            }
        }
    }
}

