/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class Overlays {
    public static final ResourceLocation BODY_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge.png");
    public static final ResourceLocation BODY_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge_hc.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_hc.png");
    public static final Supplier<ResourceLocation> BODY_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? BODY_TEMP_GAUGE_HC : BODY_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> WORLD_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? WORLD_TEMP_GAUGE_HC : WORLD_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> VAGUE_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? VAGUE_TEMP_GAUGE_HC : VAGUE_TEMP_GAUGE;
    public static double WORLD_TEMP = 0.0;
    static boolean ADVANCED_WORLD_TEMP = false;
    static double PREV_WORLD_TEMP = 0.0;
    static double MAX_TEMP = 0.0;
    static double MIN_TEMP = 0.0;
    public static double BODY_TEMP = 0.0;
    static double PREV_BODY_TEMP = 0.0;
    static int BLEND_BODY_TEMP = 0;
    static int ICON_BOB = 0;
    static double BODY_TEMP_SEVERITY = 0.0;
    public static IGuiOverlay WORLD_TEMP_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ADVANCED_WORLD_TEMP && Minecraft.m_91087_().f_91072_.m_105295_() != GameType.SPECTATOR && !Minecraft.m_91087_().f_91066_.f_92062_ && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue()) {
            gui.setupOverlayRenderState(true, false);
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getWorldSeverity(temp, MIN_TEMP, MAX_TEMP);
            int color = switch (severity) {
                case 2, 3 -> 16297781;
                case 4 -> 16728089;
                case -3, -2 -> 8443135;
                case -4 -> 4236031;
                default -> 14737376;
            };
            poseStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WORLD_TEMP_GAUGE_LOCATION.get());
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 + 92 + ConfigSettings.WORLD_GAUGE_POS.get().x()), (int)(height - 19 + ConfigSettings.WORLD_GAUGE_POS.get().y()), (float)0.0f, (float)(64 - severity * 16), (int)25, (int)16, (int)25, (int)144);
            RenderSystem.m_69461_();
            int bob = ConfigSettings.ICON_BOBBING.get() != false && !CSMath.betweenInclusive(temp, MIN_TEMP, MAX_TEMP) && player.f_19797_ % 2 == 0 ? 1 : 0;
            int blendedTemp = (int)CSMath.blend(PREV_WORLD_TEMP, WORLD_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
            Minecraft.m_91087_().f_91062_.m_92883_(poseStack, "" + (blendedTemp + ConfigSettings.TEMP_OFFSET.get()), (float)(width / 2 + 105 + Integer.toString(blendedTemp + ConfigSettings.TEMP_OFFSET.get()).length() * -3 + ConfigSettings.WORLD_GAUGE_POS.get().x()), (float)(height - 15 - bob + ConfigSettings.WORLD_GAUGE_POS.get().y()), color);
            poseStack.m_85849_();
        }
    };
    public static IGuiOverlay BODY_TEMP_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        gui.setupOverlayRenderState(true, false);
        Minecraft mc = Minecraft.m_91087_();
        if (gui.shouldDrawSurvivalElements() && !Minecraft.m_91087_().f_91066_.f_92062_) {
            int color;
            BLEND_BODY_TEMP = (int)CSMath.blend(PREV_BODY_TEMP, BODY_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
            switch ((int)BODY_TEMP_SEVERITY) {
                case -7: 
                case 7: {
                    int n = 0xFFFFFF;
                    break;
                }
                case 6: {
                    int n = 0xFFFFAC;
                    break;
                }
                case 5: {
                    int n = 16767856;
                    break;
                }
                case 4: {
                    int n = 16759634;
                    break;
                }
                case 3: {
                    int n = 16751174;
                    break;
                }
                case -3: {
                    int n = 6078975;
                    break;
                }
                case -4: {
                    int n = 7528447;
                    break;
                }
                case -5: {
                    int n = 0x84F4FF;
                    break;
                }
                case -6: {
                    int n = 0xB0FFFF;
                    break;
                }
                default: {
                    int n = BLEND_BODY_TEMP > 0 ? 16744509 : (color = BLEND_BODY_TEMP < 0 ? 4233468 : 0xAFAFAF);
                }
            }
            int colorBG = BLEND_BODY_TEMP < 0 ? 1122643 : (BLEND_BODY_TEMP > 0 ? 5376516 : 0);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.m_91087_().f_91075_.f_19797_ % 2 : 0));
            RenderSystem.m_69453_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)BODY_TEMP_GAUGE_LOCATION.get());
            if (ConfigSettings.BODY_ICON_ENABLED.get().booleanValue()) {
                int icon = Math.abs(BLEND_BODY_TEMP) < 100 ? CSMath.floor(BODY_TEMP_SEVERITY) : 4 * CSMath.sign(BODY_TEMP_SEVERITY);
                int iconX = width / 2 - 5 + ConfigSettings.BODY_ICON_POS.get().x();
                int iconYOffset = ADVANCED_WORLD_TEMP && ConfigSettings.MOVE_BODY_ICON_WHEN_ADVANCED.get() != false ? 54 : 47;
                int iconY = height - iconYOffset - threatOffset + ConfigSettings.BODY_ICON_POS.get().y();
                GuiComponent.m_93133_((PoseStack)poseStack, (int)iconX, (int)iconY, (float)0.0f, (float)(40 - icon * 10), (int)10, (int)10, (int)10, (int)90);
                if (CSMath.betweenExclusive(Math.abs(BLEND_BODY_TEMP), 0.0, 100.0)) {
                    double blend = CSMath.blend(1.0, 9.0, Math.abs(BODY_TEMP_SEVERITY), (double)Math.abs(CSMath.floor(BODY_TEMP_SEVERITY)), (double)Math.abs(CSMath.ceil(BODY_TEMP_SEVERITY)));
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)iconX, (int)(iconY + 10 - CSMath.ceil(blend)), (float)0.0f, (float)(40 - CSMath.grow(icon, BLEND_BODY_TEMP > 0 ? 0 : 2) * 10 - CSMath.ceil(blend)), (int)10, (int)CSMath.ceil(blend), (int)10, (int)90);
                }
            }
            if (ConfigSettings.BODY_READOUT_ENABLED.get().booleanValue() && ADVANCED_WORLD_TEMP) {
                Font font = mc.f_91062_;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                String s = "" + Math.min(Math.abs(BLEND_BODY_TEMP), 100);
                int x = (scaledWidth - font.m_92895_(s)) / 2 + ConfigSettings.BODY_READOUT_POS.get().x();
                int y = scaledHeight - 31 - 10 + ConfigSettings.BODY_READOUT_POS.get().y();
                font.m_92883_(poseStack, s, (float)(x + 1), (float)y, colorBG);
                font.m_92883_(poseStack, s, (float)(x - 1), (float)y, colorBG);
                font.m_92883_(poseStack, s, (float)x, (float)(y + 1), colorBG);
                font.m_92883_(poseStack, s, (float)x, (float)(y - 1), colorBG);
                font.m_92883_(poseStack, s, (float)x, (float)y, color);
            }
        }
    };
    public static IGuiOverlay VAGUE_TEMP_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && !ADVANCED_WORLD_TEMP && mc.f_91072_.m_105295_() != GameType.SPECTATOR && !mc.f_91066_.f_92062_ && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue() && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getWorldSeverity(temp, MIN_TEMP, MAX_TEMP);
            int renderOffset = CSMath.clamp(severity, -1, 1) * 2;
            poseStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.m_91087_().f_91075_.f_19797_ % 2 : 0));
            RenderSystem.m_157456_((int)0, (ResourceLocation)VAGUE_TEMP_GAUGE_LOCATION.get());
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 - 8 + ConfigSettings.BODY_ICON_POS.get().x()), (int)(height - 50 + ConfigSettings.BODY_ICON_POS.get().y() - renderOffset - threatOffset), (float)0.0f, (float)(64 - severity * 16), (int)16, (int)16, (int)16, (int)144);
            RenderSystem.m_69461_();
            poseStack.m_85849_();
        }
    };

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelow(VanillaGuiOverlay.CHAT_PANEL.id(), "world_temp", WORLD_TEMP_OVERLAY);
        event.registerBelow(VanillaGuiOverlay.CHAT_PANEL.id(), "body_temp", BODY_TEMP_OVERLAY);
        event.registerBelow(VanillaGuiOverlay.CHAT_PANEL.id(), "vague_temp", VAGUE_TEMP_OVERLAY);
    }

    public static int getWorldSeverity(double temp, double min, double max) {
        return (int)CSMath.blend(-4.0, 4.0, temp, min, max);
    }

    static double getBodySeverity(int temp) {
        int sign = CSMath.sign(temp);
        int absTemp = Math.abs(temp);
        return (absTemp < 100 ? CSMath.blend(0.0, 3.0, (double)absTemp, 0.0, 100.0) : CSMath.blend(3.0, 7.0, (double)absTemp, 100.0, 150.0)) * (double)sign;
    }

    public static void setBodyTempInstant(double temp) {
        BODY_TEMP = temp;
        PREV_BODY_TEMP = temp;
        BLEND_BODY_TEMP = (int)temp;
    }

    public static void setWorldTempInstant(double temp) {
        WORLD_TEMP = temp;
        PREV_WORLD_TEMP = temp;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static final class TickOverlays {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (event.phase == TickEvent.Phase.START && player != null) {
                EntityTempManager.getTemperatureCap((Entity)player).ifPresent(arg_0 -> TickOverlays.lambda$onClientTick$0((Player)player, arg_0));
            }
        }

        private static /* synthetic */ void lambda$onClientTick$0(Player player, ITemperatureCap icap) {
            if (!(icap instanceof PlayerTempCap)) {
                return;
            }
            PlayerTempCap cap = (PlayerTempCap)icap;
            cap.calculateHudVisibility(player);
            ADVANCED_WORLD_TEMP = cap.showAdvancedWorldTemp();
            boolean celsius = ConfigSettings.CELSIUS.get();
            double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
            double realTemp = Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true);
            double diff = realTemp - WORLD_TEMP;
            PREV_WORLD_TEMP = WORLD_TEMP;
            WORLD_TEMP += Math.abs(diff) <= 1.0 ? diff : CSMath.maxAbs(diff / ConfigSettings.TEMP_SMOOTHING.get(), 0.25 * (double)CSMath.sign(diff));
            MAX_TEMP = cap.getTrait(Temperature.Trait.BURNING_POINT);
            MIN_TEMP = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            PREV_BODY_TEMP = BODY_TEMP;
            double currentTemp = cap.getTrait(Temperature.Trait.BODY);
            BODY_TEMP = Math.abs(currentTemp - BODY_TEMP) < 0.1 ? currentTemp : BODY_TEMP + (cap.getTrait(Temperature.Trait.BODY) - BODY_TEMP) / 5.0;
            ICON_BOB = player.f_19797_ % 3 == 0 && Math.random() < 0.3 ? 1 : 0;
            BODY_TEMP_SEVERITY = Overlays.getBodySeverity(BLEND_BODY_TEMP);
        }
    }
}

