/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.client.renderer.layer.ChameleonColorLayer;
import com.momosoftworks.coldsweat.client.renderer.model.entity.ChameleonModel;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class ChameleonEntityRenderer<T extends Chameleon>
extends MobRenderer<Chameleon, ChameleonModel<Chameleon>> {
    public static final ResourceLocation CHAMELEON_SHED = new ResourceLocation("cold_sweat", "textures/entities/chameleon_shed.png");
    public static final ResourceLocation CHAMELEON_GREEN = new ResourceLocation("cold_sweat", "textures/entities/chameleon_green.png");
    public static final ResourceLocation CHAMELEON_RED = new ResourceLocation("cold_sweat", "textures/entities/chameleon_red.png");
    public static final ResourceLocation CHAMELEON_BLUE = new ResourceLocation("cold_sweat", "textures/entities/chameleon_blue.png");

    public ChameleonEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new ChameleonModel(context.m_174023_(ChameleonModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_(new ChameleonColorLayer(this));
    }

    public void render(Chameleon entity, float p_115456_, float partialTick, PoseStack ps, MultiBufferSource buffer, int light) {
        ps.m_85836_();
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            float playerHeadYaw = CSMath.blend(player.f_20886_, player.f_20885_, partialTick, 0.0f, 1.0f);
            float playerHeadPitch = player.m_5686_(partialTick);
            float ridingOffset = (float)entity.m_6049_();
            ps.m_85837_(0.0, -((double)ridingOffset - 0.05), 0.0);
            ps.m_85845_(CSMath.toQuaternion(CSMath.toRadians(playerHeadPitch), -CSMath.toRadians(playerHeadYaw), 0.0));
            ps.m_85837_(0.0, (double)ridingOffset, 0.0);
            ps.m_85845_(CSMath.toQuaternion(0.0, CSMath.toRadians(playerHeadYaw), 0.0));
            ps.m_85837_(0.0, -1.45, 0.0);
        }
        super.m_7392_((Mob)entity, p_115456_, partialTick, ps, buffer, light);
        ps.m_85849_();
    }

    public ResourceLocation getTextureLocation(Chameleon entity) {
        return CHAMELEON_GREEN;
    }
}

