/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.command.BaseCommand;
import com.momosoftworks.coldsweat.common.command.argument.AbilityOrTempTypeArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTypeArgument;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TempCommand
extends BaseCommand {
    public TempCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-150, (int)150)).executes(source -> this.executeSetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(source -> this.executeGetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(source -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)source, (String)"pos");
            return this.executeGetWorldTemp((CommandSourceStack)source.getSource(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ((CommandSourceStack)source.getSource()).m_81372_());
        })).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(source -> this.executeGetWorldTemp((CommandSourceStack)source.getSource(), IntegerArgumentType.getInteger((CommandContext)source, (String)"x"), IntegerArgumentType.getInteger((CommandContext)source, (String)"y"), IntegerArgumentType.getInteger((CommandContext)source, (String)"z"), DimensionArgument.m_88808_((CommandContext)source, (String)"dimension"))))))).then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"type", (ArgumentType)TempModifierTypeArgument.modifier()).executes(source -> this.executeDebugModifiers((CommandSourceStack)source.getSource(), EntityArgument.m_91452_((CommandContext)source, (String)"entity"), TempModifierTypeArgument.getModifier((CommandContext<CommandSourceStack>)source, "type"))))))).then(Commands.m_82127_((String)"modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"type", (ArgumentType)AbilityOrTempTypeArgument.attribute()).executes(source -> this.executeClearModifier((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"))))).executes(source -> this.executeClearAllModifiers((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"type", (ArgumentType)AbilityOrTempTypeArgument.attribute()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), AttributeModifier.Operation.ADDITION, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), AttributeModifier.Operation.ADDITION, false)))))).then(Commands.m_82127_((String)"multiply_base").then(Commands.m_82129_((String)"type", (ArgumentType)AbilityOrTempTypeArgument.attribute()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), AttributeModifier.Operation.MULTIPLY_BASE, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), AttributeModifier.Operation.MULTIPLY_BASE, false)))))).then(Commands.m_82127_((String)"multiply_total").then(Commands.m_82129_((String)"type", (ArgumentType)AbilityOrTempTypeArgument.attribute()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), AttributeModifier.Operation.MULTIPLY_TOTAL, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), AttributeModifier.Operation.MULTIPLY_TOTAL, false)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"type", (ArgumentType)AbilityOrTempTypeArgument.attribute()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.m_82129_((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.m_91461_((CommandContext)source, (String)"entities"), AbilityOrTempTypeArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, false)))))));
    }

    private int executeSetEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, int temp) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.getEntitiesWithTemperature().contains(entity.m_6095_()))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            EntityTempManager.getTemperatureCap(entity2).ifPresent(cap -> {
                cap.setTrait(Temperature.Trait.CORE, temp);
                Temperature.updateTemperature((LivingEntity)entity2, cap, true);
            });
        }
        if (entities.size() == 1) {
            Entity target = entities.iterator().next();
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.set.single.result", (Object[])new Object[]{target.m_7755_().getString(), temp}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.set.many.result", (Object[])new Object[]{entities.size(), temp}), true);
        }
        return entities.size();
    }

    private int executeGetEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.getEntitiesWithTemperature().contains(entity.m_6095_()))) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity target : entities.stream().sorted(Comparator.comparing(player -> player.m_7755_().getString())).toList()) {
            int bodyTemp = (int)Temperature.get((LivingEntity)target, Temperature.Trait.BODY);
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.get.result", (Object[])new Object[]{target.m_7755_().getString(), bodyTemp}), false);
        }
        return entities.size();
    }

    private int executeGetWorldTemp(CommandSourceStack source, int x, int y, int z, ServerLevel level) {
        EntityTempManager.getTemperatureCap((Entity)source.m_230896_()).ifPresent(cap -> {
            int worldTemp = (int)Temperature.convert(Temperature.getTemperatureAt(new BlockPos(x, y, z), (Level)(level != null ? level : source.m_81372_())), Temperature.Units.MC, cap.getPreferredUnits(), true);
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.get.world.result", (Object[])new Object[]{x, y, z, worldTemp, cap.getPreferredUnits().getFormattedName()}), true);
        });
        return 1;
    }

    private int executeDebugModifiers(CommandSourceStack source, Entity entity, Temperature.Trait trait) {
        if (!(entity instanceof Player) && !EntityTempManager.getEntitiesWithTemperature().contains(entity.m_6095_())) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        LivingEntity living = (LivingEntity)entity;
        AttributeInstance attribute = Arrays.asList(EntityTempManager.VALID_ATTRIBUTE_TYPES).contains((Object)trait) ? EntityTempManager.getAttribute(trait, living) : null;
        Temperature.Units preferredUnits = EntityTempManager.getTemperatureCap(entity).map(ITemperatureCap::getPreferredUnits).orElse(Temperature.Units.F);
        double lastValue = trait == Temperature.Trait.BURNING_POINT ? ConfigSettings.MAX_TEMP.get() : (trait == Temperature.Trait.FREEZING_POINT ? ConfigSettings.MIN_TEMP.get() : 0.0);
        source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.debug", (Object[])new Object[]{living.m_5446_(), trait.m_7912_()}).m_130940_(ChatFormatting.WHITE), false);
        if (attribute != null && CSMath.safeDouble(attribute.m_22115_()).isPresent()) {
            source.m_81354_((Component)Component.m_237113_((String)ForgeRegistries.ATTRIBUTES.getKey((Object)attribute.m_22099_()).toString()).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("" + attribute.m_22135_())).m_130940_(ChatFormatting.AQUA)), false);
            lastValue = attribute.m_22115_();
        } else {
            for (TempModifier modifier : Temperature.getModifiers(living, trait)) {
                double lastInput = modifier.getLastInput();
                double lastOutput = modifier.getLastOutput();
                source.m_81354_((Component)Component.m_237113_((String)("" + CSMath.truncate(modifier.getLastInput(), 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131144_(TempCommand.getConvertedUnitHover(trait, lastInput, preferredUnits))).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)modifier.toString()).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("" + CSMath.truncate(modifier.getLastOutput(), 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(TempCommand.getConvertedUnitHover(trait, lastOutput, preferredUnits)))), false);
                lastValue = modifier.getLastOutput();
            }
        }
        if (attribute != null) {
            double newBase = lastValue;
            for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.ADDITION)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newBase += modifier.m_22218_(), trait, preferredUnits);
            }
            double newValue = newBase;
            for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue += newBase * modifier.m_22218_(), trait, preferredUnits);
            }
            for (AttributeModifier modifier : attribute.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue *= 1.0 + modifier.m_22218_(), trait, preferredUnits);
            }
        }
        return 1;
    }

    static void printAttributeModifierLine(CommandSourceStack source, AttributeModifier modifier, double lastValueStore, double newValueStore, Temperature.Trait trait, Temperature.Units preferredUnits) {
        source.m_81354_((Component)Component.m_237113_((String)("" + CSMath.truncate(lastValueStore, 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131144_(TempCommand.getConvertedUnitHover(trait, lastValueStore, preferredUnits))).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)modifier.m_22214_()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)modifier.m_22209_().toString()).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"chat.copy.click").m_130940_(ChatFormatting.GRAY)))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, modifier.m_22209_().toString())))).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("" + CSMath.truncate(newValueStore, 2))).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(TempCommand.getConvertedUnitHover(trait, newValueStore, preferredUnits)))), false);
    }

    static double getFormattedTraitValue(Temperature.Trait trait, double rawValue, Temperature.Units units) {
        double converted;
        block3: {
            converted = rawValue;
            switch (trait) {
                case WORLD: 
                case FREEZING_POINT: 
                case BURNING_POINT: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            converted = Temperature.convert(converted, Temperature.Units.MC, units, true);
        }
        return converted;
    }

    static HoverEvent getConvertedUnitHover(Temperature.Trait trait, double value, Temperature.Units units) {
        return new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(CSMath.truncate(TempCommand.getFormattedTraitValue(trait, value, units), 1) + " " + units.getFormattedName())));
    }

    private int executeModifyEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait attribute, double amount, AttributeModifier.Operation operation, boolean permanent) {
        for (Entity entity : entities) {
            if (EntityTempManager.getEntitiesWithTemperature().contains(entity.m_6095_()) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                if (instance == null) continue;
                if (operation != null) {
                    AttributeModifier modifier = EntityTempManager.makeAttributeModifier(attribute, amount, operation);
                    instance.m_22125_(modifier);
                } else {
                    EntityTempManager.getAttribute(attribute, living).m_22100_(amount);
                }
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    if (permanent) {
                        cap.markPersistentAttribute(instance.m_22099_());
                    } else {
                        cap.clearPersistentAttribute(instance.m_22099_());
                    }
                });
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            if (operation == null) {
                source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.set.single.result", (Object[])new Object[]{attribute.m_7912_(), entities.iterator().next().m_7755_().getString(), amount}), true);
            } else {
                source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.add_modifier.single.result", (Object[])new Object[]{attribute.m_7912_(), entities.iterator().next().m_7755_().getString()}), true);
            }
        } else if (operation == null) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.set.many.result", (Object[])new Object[]{attribute.m_7912_(), entities.size(), amount}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.modify.add_modifier.many.result", (Object[])new Object[]{attribute.m_7912_(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearModifier(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait attribute) {
        for (Entity entity : entities) {
            if (EntityTempManager.getEntitiesWithTemperature().contains(entity.m_6095_()) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                    if (instance == null) {
                        return;
                    }
                    instance.m_22132_();
                    EntityTempManager.getAttribute(attribute, living).m_22100_(Double.NaN);
                    cap.clearPersistentAttribute(instance.m_22099_());
                });
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.single.result", (Object[])new Object[]{attribute.m_7912_(), entities.iterator().next().m_7755_().getString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.many.result", (Object[])new Object[]{attribute.m_7912_(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearAllModifiers(CommandSourceStack source, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            if (EntityTempManager.getEntitiesWithTemperature().contains(entity.m_6095_()) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    for (Temperature.Trait attribute : EntityTempManager.VALID_ATTRIBUTE_TYPES) {
                        AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                        if (instance == null) continue;
                        instance.m_22132_();
                        EntityTempManager.getAttribute(attribute, living).m_22100_(Double.NaN);
                        cap.clearPersistentAttribute(instance.m_22099_());
                    }
                });
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.all.single.result", (Object[])new Object[]{entities.iterator().next().m_7755_().getString()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.cold_sweat.temperature.clear.all.many.result", (Object[])new Object[]{entities.size()}), true);
        }
        return entities.size();
    }
}

