/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class SoulspringLampItem
extends Item {
    public SoulspringLampItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT).m_41487_(1).m_41486_().m_41497_(Rarity.UNCOMMON));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!level.f_46443_ && living.f_19797_ % 5 == 0) {
                CompoundTag itemTag;
                boolean shouldBeOn;
                block19: {
                    block18: {
                        shouldBeOn = false;
                        if (isSelected || living.m_21206_() == stack) break block18;
                        CompoundTag itemTag2 = stack.m_41784_();
                        if (itemTag2.m_128451_("stateChangeTimer") <= 0 && itemTag2.m_128471_("Lit") != shouldBeOn) {
                            itemTag2.m_128405_("stateChangeTimer", 2);
                            itemTag2.m_128379_("Lit", shouldBeOn);
                            if (SoulspringLampItem.getFuel(stack) < 0.5) {
                                SoulspringLampItem.setFuel(stack, 0.0);
                            }
                            WorldHelper.playEntitySound(shouldBeOn ? ModSounds.NETHER_LAMP_ON : ModSounds.NETHER_LAMP_OFF, (Entity)living, living.m_5720_(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                        } else {
                            NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
                        }
                        return;
                    }
                    try {
                        Player player;
                        double max = ConfigSettings.MAX_TEMP.get();
                        double temp = Temperature.getModifier(living, Temperature.Trait.WORLD, SoulLampTempModifier.class).map(TempModifier::getLastInput).orElseGet(() -> Temperature.get(living, Temperature.Trait.WORLD));
                        if (!ConfigSettings.LAMP_DIMENSIONS.get(level.m_5962_()).contains(level.m_6042_()) || !(temp > max) || !(SoulspringLampItem.getFuel(stack) > 0.0)) break block19;
                        if (!(living instanceof Player && !(player = (Player)living).m_7500_() || living.m_5833_())) {
                            SoulspringLampItem.addFuel(stack, -0.005 * CSMath.clamp(temp - max, 1.0, 3.0));
                        }
                        double radius = 5.0;
                        AABB bb = new AABB(living.m_20185_() - radius, living.m_20186_() + (double)(living.m_20206_() / 2.0f) - radius, living.m_20189_() - radius, living.m_20185_() + radius, living.m_20186_() + (double)(living.m_20206_() / 2.0f) + radius, living.m_20189_() + radius);
                        if (Math.random() < 0.6) {
                            AABB bb2 = bb.m_82400_(-3.0);
                            double x = bb2.f_82288_ + (bb2.f_82291_ - bb2.f_82288_) * Math.random();
                            double y = bb2.f_82289_ + (bb2.f_82292_ - bb2.f_82289_) * Math.random();
                            double z = bb2.f_82290_ + (bb2.f_82293_ - bb2.f_82290_) * Math.random();
                            double xSpeed = (Math.random() - 0.5) * 0.02;
                            double zSpeed = (Math.random() - 0.5) * 0.02;
                            WorldHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123745_, x, y, z, xSpeed, 0.0, zSpeed);
                        }
                        for (LivingEntity ent : level.m_45976_(LivingEntity.class, bb)) {
                            if (!EntityTempManager.isTemperatureEnabled(ent.m_6095_())) continue;
                            Optional<SoulLampTempModifier> mod = Temperature.getModifier(ent, Temperature.Trait.WORLD, SoulLampTempModifier.class);
                            if (mod.isPresent()) {
                                mod.get().setTicksExisted(0);
                                continue;
                            }
                            Temperature.addOrReplaceModifier(ent, new SoulLampTempModifier().expires(5).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                        }
                        shouldBeOn = true;
                    }
                    catch (Throwable throwable) {
                        CompoundTag itemTag3 = stack.m_41784_();
                        if (itemTag3.m_128451_("stateChangeTimer") <= 0 && itemTag3.m_128471_("Lit") != shouldBeOn) {
                            itemTag3.m_128405_("stateChangeTimer", 2);
                            itemTag3.m_128379_("Lit", shouldBeOn);
                            if (SoulspringLampItem.getFuel(stack) < 0.5) {
                                SoulspringLampItem.setFuel(stack, 0.0);
                            }
                            WorldHelper.playEntitySound(shouldBeOn ? ModSounds.NETHER_LAMP_ON : ModSounds.NETHER_LAMP_OFF, (Entity)living, living.m_5720_(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                        } else {
                            NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
                        }
                        throw throwable;
                    }
                }
                if ((itemTag = stack.m_41784_()).m_128451_("stateChangeTimer") <= 0 && itemTag.m_128471_("Lit") != shouldBeOn) {
                    itemTag.m_128405_("stateChangeTimer", 2);
                    itemTag.m_128379_("Lit", shouldBeOn);
                    if (SoulspringLampItem.getFuel(stack) < 0.5) {
                        SoulspringLampItem.setFuel(stack, 0.0);
                    }
                    WorldHelper.playEntitySound(shouldBeOn ? ModSounds.NETHER_LAMP_ON : ModSounds.NETHER_LAMP_OFF, (Entity)living, living.m_5720_(), 1.5f, (float)Math.random() / 5.0f + 0.9f);
                } else {
                    NBTHelper.incrementTag(stack, "stateChangeTimer", -1, tag -> tag > 0);
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    private static void setFuel(ItemStack stack, double fuel) {
        stack.m_41784_().m_128347_("Fuel", fuel);
    }

    private static void addFuel(ItemStack stack, double amount) {
        SoulspringLampItem.setFuel(stack, Math.min(64.0, SoulspringLampItem.getFuel(stack) + amount));
    }

    private static void addFuel(ItemStack stack, ItemStack fuelStack) {
        SoulspringLampItem.addFuel(stack, SoulspringLampItem.getFuelForStack(fuelStack) * (double)fuelStack.m_41613_());
    }

    private static double getFuel(ItemStack stack) {
        return stack.m_41784_().m_128459_("Fuel");
    }

    public static double getFuelForStack(ItemStack item) {
        return ((Number)CSMath.getIfNotNull(ConfigSettings.SOULSPRING_LAMP_FUEL.get().get(item.m_41720_()), fuel -> fuel.test(item) ? fuel.value() : 0.0, 0)).intValue();
    }

    @SubscribeEvent
    public static void onEntityHit(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            if (!(event.getEntity() instanceof Player)) {
                ItemStack stack = attacker.m_21205_();
                if (!(stack.m_41720_() instanceof SoulspringLampItem)) {
                    return;
                }
                LivingEntity target = event.getEntity();
                if (SoulspringLampItem.getFuel(stack) < 64.0 && target.m_6336_() != MobType.f_21641_ && !target.getPersistentData().m_128471_("SoulSucked")) {
                    target.getPersistentData().m_128379_("SoulSucked", true);
                    SoulspringLampItem.addFuel(stack, (int)Math.min(8.0f, target.m_21233_() / 2.0f));
                    float extraDamage = Math.max(0.0f, 8.0f - event.getAmount());
                    if (extraDamage > 0.0f) {
                        target.m_6469_((DamageSource)new EntityDamageSource(DamageSource.f_19319_.f_19326_, (Entity)attacker), extraDamage);
                    }
                    if (!target.f_19853_.f_46443_) {
                        int particleCount = (int)CSMath.clamp(target.m_20205_() * target.m_20205_() * target.m_20206_() * 3.0f, 5.0f, 50.0f);
                        WorldHelper.spawnParticleBatch(attacker.f_19853_, (ParticleOptions)ParticleTypes.f_123746_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), target.m_20205_() / 2.0f, target.m_20206_() / 2.0f, target.m_20205_() / 2.0f, particleCount, 0.05);
                    }
                    if (attacker.f_19853_.f_46443_) {
                        WorldHelper.playEntitySound(ModSounds.NETHER_LAMP_ON, (Entity)attacker, attacker.m_5720_(), 1.0f, (float)Math.random() / 5.0f + 1.3f);
                    }
                }
            }
        }
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> itemList) {
        if (this.m_220152_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128379_("Lit", true);
            stack.m_41784_().m_128347_("Fuel", 64.0);
            itemList.add((Object)stack);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        if (advanced.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)("Fuel: " + (int)stack.m_41784_().m_128459_("Fuel") + " / 64")));
        }
        super.m_7373_(stack, level, tooltip, advanced);
    }

    public boolean m_142305_(ItemStack thisStack, ItemStack fuelStack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        PredicateItem fuel = ConfigSettings.SOULSPRING_LAMP_FUEL.get().get(fuelStack.m_41720_());
        if (fuel != null && fuel.test(fuelStack) && SoulspringLampItem.getFuel(thisStack) < 64.0) {
            double currentFuel = SoulspringLampItem.getFuel(thisStack);
            if (action == ClickAction.PRIMARY) {
                SoulspringLampItem.addFuel(thisStack, fuelStack);
                fuelStack.m_41774_((int)((64.0 - currentFuel) / SoulspringLampItem.getFuelForStack(fuelStack)));
            } else if (action == ClickAction.SECONDARY) {
                ItemStack singleFuelItem = fuelStack.m_41777_();
                singleFuelItem.m_41764_(1);
                SoulspringLampItem.addFuel(thisStack, singleFuelItem);
                fuelStack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancementTriggers.SOUL_LAMP_FUELLED.trigger(serverPlayer, fuelStack, thisStack);
            }
            return true;
        }
        return false;
    }
}

