/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.slot.ScalingFormula;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigRegistryHandler;
import com.momosoftworks.coldsweat.config.spec.ClientSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.config.type.InsulatingMount;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import oshi.util.tuples.Triplet;

public class ConfigSettings {
    public static final Map<String, DynamicHolder<?>> CONFIG_SETTINGS = new ConcurrentHashMap();
    public static Difficulty DEFAULT_DIFFICULTY = Difficulty.NORMAL;
    public static final DynamicHolder<Integer> DIFFICULTY = ConfigSettings.addSyncedSetting("difficulty", () -> MainSettingsConfig.getInstance().getDifficulty(), encoder -> ConfigHelper.serializeNbtInt(encoder, "Difficulty"), decoder -> decoder.m_128451_("Difficulty"), saver -> MainSettingsConfig.getInstance().setDifficulty((int)saver));
    public static final DynamicHolder<Double> MAX_TEMP = ConfigSettings.addSyncedSetting("max_temp", () -> MainSettingsConfig.getInstance().getMaxTempHabitable(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "MaxTemp"), decoder -> decoder.m_128459_("MaxTemp"), saver -> MainSettingsConfig.getInstance().setMaxHabitable((double)saver));
    public static final DynamicHolder<Double> MIN_TEMP = ConfigSettings.addSyncedSetting("min_temp", () -> MainSettingsConfig.getInstance().getMinTempHabitable(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "MinTemp"), decoder -> decoder.m_128459_("MinTemp"), saver -> MainSettingsConfig.getInstance().setMinHabitable((double)saver));
    public static final DynamicHolder<Double> TEMP_RATE = ConfigSettings.addSyncedSetting("temp_rate", () -> MainSettingsConfig.getInstance().getRateMultiplier(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "TempRate"), decoder -> decoder.m_128459_("TempRate"), saver -> MainSettingsConfig.getInstance().setRateMultiplier((double)saver));
    public static final DynamicHolder<Double> TEMP_DAMAGE = ConfigSettings.addSyncedSetting("temp_damage", () -> MainSettingsConfig.getInstance().getTempDamage(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "TempDamage"), decoder -> decoder.m_128459_("TempDamage"), saver -> MainSettingsConfig.getInstance().setTempDamage((double)saver));
    public static final DynamicHolder<Boolean> FIRE_RESISTANCE_ENABLED = ConfigSettings.addSyncedSetting("fire_resistance_enabled", () -> MainSettingsConfig.getInstance().isFireResistanceEnabled(), encoder -> ConfigHelper.serializeNbtBool(encoder, "FireResistanceEnabled"), decoder -> decoder.m_128471_("FireResistanceEnabled"), saver -> MainSettingsConfig.getInstance().setFireResistanceEnabled((boolean)saver));
    public static final DynamicHolder<Boolean> ICE_RESISTANCE_ENABLED = ConfigSettings.addSyncedSetting("ice_resistance_enabled", () -> MainSettingsConfig.getInstance().isIceResistanceEnabled(), encoder -> ConfigHelper.serializeNbtBool(encoder, "IceResistanceEnabled"), decoder -> decoder.m_128471_("IceResistanceEnabled"), saver -> MainSettingsConfig.getInstance().setIceResistanceEnabled((boolean)saver));
    public static final DynamicHolder<Boolean> DAMAGE_SCALING = ConfigSettings.addSyncedSetting("damage_scaling", () -> MainSettingsConfig.getInstance().doDamageScaling(), encoder -> ConfigHelper.serializeNbtBool(encoder, "DamageScaling"), decoder -> decoder.m_128471_("DamageScaling"), saver -> MainSettingsConfig.getInstance().setDamageScaling((boolean)saver));
    public static final DynamicHolder<Boolean> REQUIRE_THERMOMETER = ConfigSettings.addSyncedSetting("require_thermometer", () -> MainSettingsConfig.getInstance().thermometerRequired(), encoder -> ConfigHelper.serializeNbtBool(encoder, "RequireThermometer"), decoder -> decoder.m_128471_("RequireThermometer"), saver -> MainSettingsConfig.getInstance().setRequireThermometer((boolean)saver));
    public static final DynamicHolder<Integer> GRACE_LENGTH = ConfigSettings.addSyncedSetting("grace_length", () -> MainSettingsConfig.getInstance().getGracePeriodLength(), encoder -> ConfigHelper.serializeNbtInt(encoder, "GraceLength"), decoder -> decoder.m_128451_("GraceLength"), saver -> MainSettingsConfig.getInstance().setGracePeriodLength((int)saver));
    public static final DynamicHolder<Boolean> GRACE_ENABLED = ConfigSettings.addSyncedSetting("grace_enabled", () -> MainSettingsConfig.getInstance().isGracePeriodEnabled(), encoder -> ConfigHelper.serializeNbtBool(encoder, "GraceEnabled"), decoder -> decoder.m_128471_("GraceEnabled"), saver -> MainSettingsConfig.getInstance().setGracePeriodEnabled((boolean)saver));
    public static final DynamicHolder<Double> HEARTS_FREEZING_PERCENTAGE = ConfigSettings.addSyncedSetting("hearts_freezing_percentage", () -> MainSettingsConfig.getInstance().getHeartsFreezingPercentage(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "HeartsFreezingPercentage"), decoder -> decoder.m_128459_("HeartsFreezingPercentage"), saver -> MainSettingsConfig.getInstance().setHeartsFreezingPercentage((double)saver));
    public static final DynamicHolder<Double> COLD_MINING_IMPAIRMENT = ConfigSettings.addSyncedSetting("cold_mining_slowdown", () -> MainSettingsConfig.getInstance().getColdMiningImpairment(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdMiningImpairment"), decoder -> decoder.m_128459_("ColdMiningImpairment"), saver -> MainSettingsConfig.getInstance().setColdMiningImpairment((double)saver));
    public static final DynamicHolder<Double> COLD_MOVEMENT_SLOWDOWN = ConfigSettings.addSyncedSetting("cold_movement_slowdown", () -> MainSettingsConfig.getInstance().getColdMovementSlowdown(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdMovementSlowdown"), decoder -> decoder.m_128459_("ColdMovementSlowdown"), saver -> MainSettingsConfig.getInstance().setColdMovementSlowdown((double)saver));
    public static final DynamicHolder<Double> COLD_KNOCKBACK_REDUCTION = ConfigSettings.addSyncedSetting("cold_knockback_reduction", () -> MainSettingsConfig.getInstance().getColdKnockbackReduction(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "ColdKnockbackReduction"), decoder -> decoder.m_128459_("ColdKnockbackReduction"), saver -> MainSettingsConfig.getInstance().setColdKnockbackReduction((double)saver));
    public static final DynamicHolder<Double> HEATSTROKE_FOG_DISTANCE = ConfigSettings.addSyncedSetting("heatstroke_fog_distance", () -> MainSettingsConfig.getInstance().getHeatstrokeFogDistance(), encoder -> ConfigHelper.serializeNbtDouble(encoder, "HeatstrokeFogDistance"), decoder -> decoder.m_128459_("HeatstrokeFogDistance"), saver -> MainSettingsConfig.getInstance().setHeatstrokeFogDistance((double)saver));
    public static final DynamicHolder<Map<Biome, Triplet<Double, Double, Temperature.Units>>> BIOME_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("biome_temps", registryAccess -> ConfigHelper.getBiomesWithValues(WorldSettingsConfig.getInstance().getBiomeTemperatures(), true, registryAccess), (encoder, registryAccess) -> ConfigHelper.serializeBiomeTemps(encoder, "BiomeTemps", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeBiomeTemps(decoder, "BiomeTemps", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setBiomeTemperatures(saver.entrySet().stream().map(entry -> {
        ResourceLocation biome = RegistryHelper.getBiomeId((Biome)entry.getKey(), registryAccess);
        if (biome == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Triplet)entry.getValue()).getC())));
        double min = Temperature.convert((Double)((Triplet)entry.getValue()).getA(), Temperature.Units.MC, units, true);
        double max = Temperature.convert((Double)((Triplet)entry.getValue()).getB(), Temperature.Units.MC, units, true);
        return Arrays.asList(biome.toString(), min, max, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<Biome, Triplet<Double, Double, Temperature.Units>>> BIOME_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("biome_offsets", registryAccess -> ConfigHelper.getBiomesWithValues(WorldSettingsConfig.getInstance().getBiomeTempOffsets(), false, registryAccess), (encoder, registryAccess) -> ConfigHelper.serializeBiomeTemps(encoder, "BiomeOffsets", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeBiomeTemps(decoder, "BiomeOffsets", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setBiomeTempOffsets(saver.entrySet().stream().map(entry -> {
        ResourceLocation biome = RegistryHelper.getBiomeId((Biome)entry.getKey(), registryAccess);
        if (biome == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Triplet)entry.getValue()).getC())));
        double min = Temperature.convert((Double)((Triplet)entry.getValue()).getA(), Temperature.Units.MC, units, false);
        double max = Temperature.convert((Double)((Triplet)entry.getValue()).getB(), Temperature.Units.MC, units, false);
        return Arrays.asList(biome.toString(), min, max, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<DimensionType, Pair<Double, Temperature.Units>>> DIMENSION_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("dimension_temps", registryAccess -> ConfigHelper.getDimensionsWithValues(WorldSettingsConfig.getInstance().getDimensionTemperatures(), true, registryAccess), (encoder, registryAccess) -> ConfigHelper.serializeDimensionTemps(encoder, "DimensionTemps", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeDimensionTemps(decoder, "DimensionTemps", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setDimensionTemperatures(saver.entrySet().stream().map(entry -> {
        ResourceLocation dim = RegistryHelper.getDimensionId((DimensionType)entry.getKey(), registryAccess);
        if (dim == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, true);
        return Arrays.asList(dim.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<DimensionType, Pair<Double, Temperature.Units>>> DIMENSION_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("dimension_offsets", registryAccess -> ConfigHelper.getDimensionsWithValues(WorldSettingsConfig.getInstance().getDimensionTempOffsets(), false, registryAccess), (encoder, registryAccess) -> ConfigHelper.serializeDimensionTemps(encoder, "DimensionOffsets", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeDimensionTemps(decoder, "DimensionOffsets", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setDimensionTempOffsets(saver.entrySet().stream().map(entry -> {
        ResourceLocation dim = RegistryHelper.getDimensionId((DimensionType)entry.getKey(), registryAccess);
        if (dim == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, false);
        return Arrays.asList(dim.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<StructureType<?>, Pair<Double, Temperature.Units>>> STRUCTURE_TEMPS = ConfigSettings.addSyncedSettingWithRegistries("structure_temperatures", registryAccess -> ConfigHelper.getStructuresWithValues(WorldSettingsConfig.getInstance().getStructureTemperatures(), true, registryAccess), (encoder, registryAccess) -> ConfigHelper.serializeStructureTemps(encoder, "StructureTemperatures", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeStructureTemps(decoder, "StructureTemperatures", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setStructureTemperatures(saver.entrySet().stream().map(entry -> {
        ResourceLocation struct = RegistryHelper.getStructureId((StructureType)entry.getKey(), registryAccess);
        if (struct == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, true);
        return Arrays.asList(struct.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Map<StructureType<?>, Pair<Double, Temperature.Units>>> STRUCTURE_OFFSETS = ConfigSettings.addSyncedSettingWithRegistries("structure_offsets", registryAccess -> ConfigHelper.getStructuresWithValues(WorldSettingsConfig.getInstance().getStructureTempOffsets(), false, registryAccess), (encoder, registryAccess) -> ConfigHelper.serializeStructureTemps(encoder, "StructureOffsets", registryAccess), (decoder, registryAccess) -> ConfigHelper.deserializeStructureTemps(decoder, "StructureOffsets", registryAccess), (saver, registryAccess) -> WorldSettingsConfig.getInstance().setStructureTempOffsets(saver.entrySet().stream().map(entry -> {
        ResourceLocation struct = RegistryHelper.getStructureId((StructureType)entry.getKey(), registryAccess);
        if (struct == null) {
            return null;
        }
        Temperature.Units units = (Temperature.Units)((Object)((Object)((Object)((Pair)entry.getValue()).getSecond())));
        double temp = Temperature.convert((Double)((Pair)entry.getValue()).getFirst(), Temperature.Units.MC, units, false);
        return Arrays.asList(struct.toString(), temp, units.toString());
    }).filter(Objects::nonNull).collect(Collectors.toList())));
    public static final DynamicHolder<Double> CAVE_INSULATION = ConfigSettings.addSetting("cave_insulation", () -> WorldSettingsConfig.getInstance().getCaveInsulation());
    public static final DynamicHolder<List<DepthTempData>> DEPTH_REGIONS = ConfigSettings.addSetting("depth_regions", () -> new ArrayList());
    public static final DynamicHolder<Double[]> SUMMER_TEMPS;
    public static final DynamicHolder<Double[]> AUTUMN_TEMPS;
    public static final DynamicHolder<Double[]> WINTER_TEMPS;
    public static final DynamicHolder<Double[]> SPRING_TEMPS;
    public static final DynamicHolder<Integer> BLOCK_RANGE;
    public static final DynamicHolder<Boolean> COLD_SOUL_FIRE;
    public static final DynamicHolder<List<Block>> HEARTH_SPREAD_WHITELIST;
    public static final DynamicHolder<List<Block>> HEARTH_SPREAD_BLACKLIST;
    public static final DynamicHolder<Double> HEARTH_STRENGTH;
    public static final DynamicHolder<Boolean> SMART_HEARTH;
    public static final DynamicHolder<List<Block>> SLEEP_CHECK_IGNORE_BLOCKS;
    public static final DynamicHolder<Map<Item, Insulator>> INSULATION_ITEMS;
    public static final DynamicHolder<Map<Item, Insulator>> INSULATING_ARMORS;
    public static final DynamicHolder<Map<Item, Insulator>> INSULATING_CURIOS;
    public static final DynamicHolder<ScalingFormula> INSULATION_SLOTS;
    public static final DynamicHolder<List<Item>> INSULATION_BLACKLIST;
    public static final DynamicHolder<Boolean> CHECK_SLEEP_CONDITIONS;
    public static final DynamicHolder<Map<Item, PredicateItem>> FOOD_TEMPERATURES;
    public static final DynamicHolder<Integer> WATERSKIN_STRENGTH;
    public static final DynamicHolder<List<DimensionType>> LAMP_DIMENSIONS;
    public static final DynamicHolder<Map<Item, PredicateItem>> BOILER_FUEL;
    public static final DynamicHolder<Map<Item, PredicateItem>> ICEBOX_FUEL;
    public static final DynamicHolder<Map<Item, PredicateItem>> HEARTH_FUEL;
    public static final DynamicHolder<Map<Item, PredicateItem>> SOULSPRING_LAMP_FUEL;
    public static final DynamicHolder<Boolean> HEARTH_POTIONS_ENABLED;
    public static final DynamicHolder<List<MobEffect>> HEARTH_POTION_BLACKLIST;
    public static final DynamicHolder<Triplet<Integer, Integer, Double>> FUR_TIMINGS;
    public static final DynamicHolder<Triplet<Integer, Integer, Double>> SHED_TIMINGS;
    public static final DynamicHolder<Multimap<Biome, SpawnBiomeData>> ENTITY_SPAWN_BIOMES;
    public static final DynamicHolder<Map<EntityType<?>, InsulatingMount>> INSULATED_ENTITIES;
    public static final DynamicHolder<Boolean> CELSIUS;
    public static final DynamicHolder<Integer> TEMP_OFFSET;
    public static final DynamicHolder<Double> TEMP_SMOOTHING;
    public static final DynamicHolder<Vec2i> BODY_ICON_POS;
    public static final DynamicHolder<Boolean> BODY_ICON_ENABLED;
    public static final DynamicHolder<Boolean> MOVE_BODY_ICON_WHEN_ADVANCED;
    public static final DynamicHolder<Vec2i> BODY_READOUT_POS;
    public static final DynamicHolder<Boolean> BODY_READOUT_ENABLED;
    public static final DynamicHolder<Vec2i> WORLD_GAUGE_POS;
    public static final DynamicHolder<Boolean> WORLD_GAUGE_ENABLED;
    public static final DynamicHolder<Boolean> CUSTOM_HOTBAR_LAYOUT;
    public static final DynamicHolder<Boolean> ICON_BOBBING;
    public static final DynamicHolder<Boolean> HEARTH_DEBUG;
    public static final DynamicHolder<Boolean> SHOW_CONFIG_BUTTON;
    public static final DynamicHolder<Vec2i> CONFIG_BUTTON_POS;
    public static final DynamicHolder<Boolean> DISTORTION_EFFECTS;
    public static final DynamicHolder<Boolean> HIGH_CONTRAST;
    public static final DynamicHolder<Boolean> SHOW_CREATIVE_WARNING;

    public static <T> DynamicHolder<T> addSetting(String id, Supplier<T> supplier) {
        DynamicHolder<T> loader = DynamicHolder.create(supplier);
        CONFIG_SETTINGS.put(id, loader);
        return loader;
    }

    public static <T> DynamicHolder<T> addSettingWithRegistries(String id, DynamicHolder.Getter<T> supplier) {
        DynamicHolder<T> loader = DynamicHolder.createWithRegistries(supplier);
        CONFIG_SETTINGS.put(id, loader);
        return loader;
    }

    public static <T> DynamicHolder<T> addSyncedSetting(String id, Supplier<T> supplier, Function<T, CompoundTag> writer, Function<CompoundTag, T> reader, Consumer<T> saver) {
        DynamicHolder<T> loader = DynamicHolder.createSynced(supplier, writer, reader, saver);
        CONFIG_SETTINGS.put(id, loader);
        return loader;
    }

    public static <T> DynamicHolder<T> addSyncedSettingWithRegistries(String id, DynamicHolder.Getter<T> supplier, DynamicHolder.Writer<T> writer, DynamicHolder.Reader<T> reader, DynamicHolder.Saver<T> saver) {
        DynamicHolder<T> loader = DynamicHolder.createSyncedWithRegistries(supplier, writer, reader, saver);
        CONFIG_SETTINGS.put(id, loader);
        return loader;
    }

    public static <T> DynamicHolder<T> addClientSetting(String id, Supplier<T> supplier) {
        return FMLEnvironment.dist == Dist.CLIENT ? ConfigSettings.addSetting(id, supplier) : DynamicHolder.create(() -> null);
    }

    public static Map<String, CompoundTag> encode(RegistryAccess registryAccess) {
        HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
        CONFIG_SETTINGS.forEach((key, value) -> {
            if (value.isSynced()) {
                map.put((String)key, value.encode(registryAccess));
            }
        });
        return map;
    }

    public static void decode(String key, CompoundTag tag, RegistryAccess registryAccess) {
        CONFIG_SETTINGS.computeIfPresent(key, (k, value) -> {
            value.decode(tag, registryAccess);
            return value;
        });
    }

    public static void saveValues(RegistryAccess registryAccess) {
        CONFIG_SETTINGS.values().forEach(value -> {
            if (value.isSynced()) {
                value.save(registryAccess);
            }
        });
    }

    public static void load(RegistryAccess registryAccess) {
        if (registryAccess != null) {
            CONFIG_SETTINGS.values().forEach(dynamicHolder -> dynamicHolder.load(registryAccess));
            ConfigRegistryHandler.collectConfigRegistries(registryAccess);
        } else {
            ColdSweat.LOGGER.warn("Loading Cold Sweat config settings without registry access. This is normal during startup.");
            CONFIG_SETTINGS.values().forEach(dynamicHolder -> {
                if (!dynamicHolder.requiresRegistries()) {
                    dynamicHolder.load();
                }
            });
        }
    }

    private static /* synthetic */ void lambda$static$158(RegistryAccess registryAccess, Multimap map, List configBiomes, EntityType entityType) {
        for (List entry : configBiomes) {
            Either biomeEither;
            String biomeId = (String)entry.get(0);
            List<Biome> biomes = ConfigHelper.parseRegistryItems(Registry.f_122885_, registryAccess, biomeId);
            if (biomeId.charAt(0) == '#') {
                biomeEither = Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(biomeId.substring(1))));
            } else {
                Biome biome = RegistryHelper.getBiome(new ResourceLocation(biomeId), registryAccess);
                if (biome == null) continue;
                biomeEither = Either.right((Object)biome);
            }
            for (Biome biome : biomes) {
                SpawnBiomeData spawnData = new SpawnBiomeData(List.of(biomeEither), MobCategory.CREATURE, ((Number)entry.get(1)).intValue(), List.of(Either.right((Object)entityType)), Optional.empty());
                map.put((Object)biome, (Object)spawnData);
            }
        }
    }

    static {
        BiFunction<Item, List, PredicateItem> fuelMapper = (item, args) -> {
            double fuel = ((Number)args.get(0)).doubleValue();
            NbtRequirement nbtRequirement = args.size() > 2 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)args.get(2))) : new NbtRequirement(new CompoundTag());
            return new PredicateItem(fuel, new ItemRequirement(Optional.of(List.of(Either.right((Object)item))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbtRequirement), EntityRequirement.NONE);
        };
        BOILER_FUEL = ConfigSettings.addSetting("boiler_fuel_items", () -> ConfigHelper.readItemMap(ItemSettingsConfig.getInstance().getBoilerFuelItems(), fuelMapper));
        ICEBOX_FUEL = ConfigSettings.addSetting("icebox_fuel_items", () -> ConfigHelper.readItemMap(ItemSettingsConfig.getInstance().getIceboxFuelItems(), fuelMapper));
        HEARTH_FUEL = ConfigSettings.addSetting("hearth_fuel_items", () -> ConfigHelper.readItemMap(ItemSettingsConfig.getInstance().getHearthFuelItems(), fuelMapper));
        SOULSPRING_LAMP_FUEL = ConfigSettings.addSyncedSetting("lamp_fuel_items", () -> ConfigHelper.readItemMap(ItemSettingsConfig.getInstance().getSoulLampFuelItems(), fuelMapper), encoder -> ConfigHelper.serializeItemMap(encoder, "LampFuelItems", fuel -> fuel.serialize()), decoder -> ConfigHelper.deserializeItemMap(decoder, "LampFuelItems", nbt -> PredicateItem.deserialize(nbt)), saver -> ConfigHelper.writeItemMap(saver, list -> ItemSettingsConfig.getInstance().setSoulLampFuelItems((List<? extends List<?>>)list), fuel -> List.of(fuel.value(), fuel.data().nbt().tag().toString())));
        HEARTH_POTIONS_ENABLED = ConfigSettings.addSetting("hearth_potions_enabled", () -> ItemSettingsConfig.getInstance().arePotionsEnabled());
        HEARTH_POTION_BLACKLIST = ConfigSettings.addSetting("hearth_potion_blacklist", () -> ItemSettingsConfig.getInstance().getPotionBlacklist().stream().map(entry -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll));
        INSULATION_ITEMS = ConfigSettings.addSyncedSetting("insulation_items", () -> ConfigHelper.readItemInsulations(ItemSettingsConfig.getInstance().getInsulationItems(), Insulation.Slot.ITEM), encoder -> ConfigHelper.serializeItemInsulations(encoder, "InsulationItems"), decoder -> ConfigHelper.deserializeItemInsulations(decoder, "InsulationItems"), saver -> ConfigHelper.writeItemInsulations(saver, list -> ItemSettingsConfig.getInstance().setInsulationItems((List<? extends List<?>>)list)));
        INSULATING_ARMORS = ConfigSettings.addSyncedSetting("insulating_armors", () -> ConfigHelper.readItemInsulations(ItemSettingsConfig.getInstance().getInsulatingArmorItems(), Insulation.Slot.ARMOR), encoder -> ConfigHelper.serializeItemInsulations(encoder, "InsulatingArmors"), decoder -> ConfigHelper.deserializeItemInsulations(decoder, "InsulatingArmors"), saver -> ConfigHelper.writeItemInsulations(saver, list -> ItemSettingsConfig.getInstance().setInsulatingArmorItems((List<? extends List<?>>)list)));
        INSULATING_CURIOS = ConfigSettings.addSyncedSetting("insulating_curios", () -> {
            if (!CompatManager.isCuriosLoaded()) {
                return new HashMap();
            }
            return ConfigHelper.readItemInsulations(ItemSettingsConfig.getInstance().getInsulatingCurios(), Insulation.Slot.CURIO);
        }, encoder -> ConfigHelper.serializeItemInsulations(encoder, "InsulatingCurios"), decoder -> ConfigHelper.deserializeItemInsulations(decoder, "InsulatingCurios"), saver -> {
            if (CompatManager.isCuriosLoaded()) {
                ConfigHelper.writeItemInsulations(saver, list -> ItemSettingsConfig.getInstance().setInsulatingCurios((List<? extends List<?>>)list));
            }
        });
        INSULATION_SLOTS = ConfigSettings.addSyncedSetting("insulation_slots", () -> {
            List<Object> list = ItemSettingsConfig.getInstance().getArmorInsulationSlots();
            if (list.size() == 4 && list.stream().allMatch(el -> el instanceof Integer)) {
                list = List.of("static", list.get(0), list.get(1), list.get(2), list.get(3));
            }
            String mode = (String)list.get(0);
            ScalingFormula.Type scalingType = ScalingFormula.Type.byName(mode);
            List<Number> values = list.subList(1, list.size()).stream().map(o -> (Number)o).toList();
            return scalingType == ScalingFormula.Type.STATIC ? new ScalingFormula.Static(values.get(0).intValue(), values.get(1).intValue(), values.get(2).intValue(), values.get(3).intValue()) : new ScalingFormula.Dynamic(scalingType, values.get(0).doubleValue(), values.size() > 2 ? values.get(2).doubleValue() : Double.MAX_VALUE);
        }, encoder -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Mode", encoder.getType().m_7912_());
            ListTag values = new ListTag();
            encoder.getValues().forEach(value -> values.add((Object)DoubleTag.m_128500_((double)value.doubleValue())));
            tag.m_128365_("Values", (Tag)values);
            return tag;
        }, decoder -> {
            ScalingFormula.Type scalingType = ScalingFormula.Type.byName(decoder.m_128461_("Mode"));
            List<Number> values = decoder.m_128437_("Values", 6).stream().map(tag -> ((DoubleTag)tag).m_8103_()).toList();
            return scalingType == ScalingFormula.Type.STATIC ? new ScalingFormula.Static(values.get(0).intValue(), values.get(1).intValue(), values.get(2).intValue(), values.get(3).intValue()) : new ScalingFormula.Dynamic(scalingType, values.get(0).doubleValue(), values.size() > 2 ? values.get(2).doubleValue() : Double.MAX_VALUE);
        }, saver -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(saver.getType().m_7912_());
            list.addAll(saver.getValues());
            ItemSettingsConfig.getInstance().setArmorInsulationSlots(list);
        });
        INSULATION_BLACKLIST = ConfigSettings.addSetting("insulation_blacklist", () -> ItemSettingsConfig.getInstance().getInsulationBlacklist().stream().map(entry -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll));
        CHECK_SLEEP_CONDITIONS = ConfigSettings.addSetting("check_sleep_conditions", () -> WorldSettingsConfig.getInstance().isSleepChecked());
        SLEEP_CHECK_IGNORE_BLOCKS = ConfigSettings.addSetting("sleep_check_override_blocks", () -> ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getSleepOverrideBlocks().toArray(new String[0])));
        FOOD_TEMPERATURES = ConfigSettings.addSyncedSetting("food_temperatures", () -> ConfigHelper.readItemMap(ItemSettingsConfig.getInstance().getFoodTemperatures(), (item, args) -> {
            double value = ((Number)args.get(0)).doubleValue();
            NbtRequirement nbtRequirement = args.size() > 1 ? new NbtRequirement(NBTHelper.parseCompoundNbt((String)args.get(1))) : new NbtRequirement(new CompoundTag());
            Integer duration = args.size() > 2 ? Integer.valueOf(((Number)args.get(2)).intValue()) : null;
            ItemRequirement itemRequirement = new ItemRequirement(Optional.of(List.of(Either.right((Object)item))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), nbtRequirement);
            CompoundTag tag = new CompoundTag();
            if (duration != null) {
                tag.m_128405_("duration", duration.intValue());
            }
            return new PredicateItem(value, itemRequirement, EntityRequirement.NONE, tag);
        }), encoder -> ConfigHelper.serializeItemMap(encoder, "FoodTemperatures", food -> food.serialize()), decoder -> ConfigHelper.deserializeItemMap(decoder, "FoodTemperatures", nbt -> PredicateItem.deserialize(nbt)), saver -> ConfigHelper.writeItemMap(saver, list -> ItemSettingsConfig.getInstance().setFoodTemperatures((List<? extends List<?>>)list), food -> List.of(food.value(), food.data().nbt().tag().toString())));
        WATERSKIN_STRENGTH = ConfigSettings.addSetting("waterskin_strength", () -> ItemSettingsConfig.getInstance().getWaterskinStrength());
        LAMP_DIMENSIONS = ConfigSettings.addSettingWithRegistries("valid_lamp_dimensions", registryAccess -> new ArrayList(ItemSettingsConfig.getInstance().getValidSoulLampDimensions().stream().map(entry -> (DimensionType)registryAccess.m_175515_(Registry.f_122818_).m_7745_(new ResourceLocation(entry))).collect(ArrayList::new, List::add, List::addAll)));
        FUR_TIMINGS = ConfigSettings.addSyncedSetting("fur_timings", () -> {
            List<?> entry = EntitySettingsConfig.getInstance().getGoatFurStats();
            return new Triplet((Object)((Number)entry.get(0)).intValue(), (Object)((Number)entry.get(1)).intValue(), (Object)((Number)entry.get(2)).doubleValue());
        }, encoder -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Interval", (Tag)IntTag.m_128679_((int)((Integer)encoder.getA())));
            tag.m_128365_("Cooldown", (Tag)IntTag.m_128679_((int)((Integer)encoder.getB())));
            tag.m_128365_("Chance", (Tag)DoubleTag.m_128500_((double)((Double)encoder.getC())));
            return tag;
        }, decoder -> {
            int interval = decoder.m_128451_("Interval");
            int cooldown = decoder.m_128451_("Cooldown");
            double chance = decoder.m_128459_("Chance");
            return new Triplet((Object)interval, (Object)cooldown, (Object)chance);
        }, saver -> {
            ArrayList<Number> list = new ArrayList<Number>();
            list.add((Number)saver.getA());
            list.add((Number)saver.getB());
            list.add((Number)saver.getC());
            EntitySettingsConfig.getInstance().setGoatFurStats(list);
        });
        SHED_TIMINGS = ConfigSettings.addSyncedSetting("shed_timings", () -> {
            List<?> entry = EntitySettingsConfig.getInstance().getChameleonShedStats();
            return new Triplet((Object)((Number)entry.get(0)).intValue(), (Object)((Number)entry.get(1)).intValue(), (Object)((Number)entry.get(2)).doubleValue());
        }, encoder -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Interval", (Tag)IntTag.m_128679_((int)((Integer)encoder.getA())));
            tag.m_128365_("Cooldown", (Tag)IntTag.m_128679_((int)((Integer)encoder.getB())));
            tag.m_128365_("Chance", (Tag)DoubleTag.m_128500_((double)((Double)encoder.getC())));
            return tag;
        }, decoder -> {
            int interval = decoder.m_128451_("Interval");
            int cooldown = decoder.m_128451_("Cooldown");
            double chance = decoder.m_128459_("Chance");
            return new Triplet((Object)interval, (Object)cooldown, (Object)chance);
        }, saver -> {
            ArrayList<Number> list = new ArrayList<Number>();
            list.add((Number)saver.getA());
            list.add((Number)saver.getB());
            list.add((Number)saver.getC());
            EntitySettingsConfig.getInstance().setChameleonShedStats(list);
        });
        ENTITY_SPAWN_BIOMES = ConfigSettings.addSettingWithRegistries("entity_spawn_biomes", registryAccess -> {
            HashMultimap map = HashMultimap.create();
            BiConsumer<List, EntityType> configReader = (arg_0, arg_1) -> ConfigSettings.lambda$static$158(registryAccess, (Multimap)map, arg_0, arg_1);
            configReader.accept(EntitySettingsConfig.getInstance().getChameleonSpawnBiomes(), ModEntities.CHAMELEON);
            configReader.accept(EntitySettingsConfig.getInstance().getGoatSpawnBiomes(), EntityType.f_147035_);
            return map;
        });
        INSULATED_ENTITIES = ConfigSettings.addSetting("insulated_entities", () -> EntitySettingsConfig.getInstance().getInsulatedEntities().stream().map(entry -> {
            ArrayList entries = new ArrayList();
            String entityID = (String)entry.get(0);
            double coldInsul = ((Number)entry.get(1)).doubleValue();
            double hotInsul = entry.size() < 3 ? coldInsul : ((Number)entry.get(2)).doubleValue();
            for (EntityType<?> entityType : ConfigHelper.getEntityTypes(entityID)) {
                entries.add(Map.entry(entityType, new InsulatingMount(entityType, coldInsul, hotInsul, EntityRequirement.NONE)));
            }
            return entries;
        }).flatMap(Collection::stream).distinct().filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
            ColdSweat.LOGGER.warn("Duplicate entity entry for \"{}\" found in config. Using the first entry.", (Object)ForgeRegistries.ENTITY_TYPES.getKey(a.entityType()).toString());
            return a;
        })));
        BLOCK_RANGE = ConfigSettings.addSyncedSetting("block_range", () -> WorldSettingsConfig.getInstance().getBlockRange(), encoder -> ConfigHelper.serializeNbtInt(encoder, "BlockRange"), decoder -> decoder.m_128451_("BlockRange"), saver -> WorldSettingsConfig.getInstance().setBlockRange((int)saver));
        COLD_SOUL_FIRE = ConfigSettings.addSetting("cold_soul_fire", () -> WorldSettingsConfig.getInstance().isSoulFireCold());
        HEARTH_SPREAD_WHITELIST = ConfigSettings.addSyncedSetting("hearth_spread_whitelist", () -> ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getHearthSpreadWhitelist().toArray(new String[0])), encoder -> {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (Block entry : encoder) {
                list.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)entry).toString()));
            }
            tag.m_128365_("HearthWhitelist", (Tag)list);
            return tag;
        }, decoder -> {
            ArrayList<Block> list = new ArrayList<Block>();
            for (Tag entry : decoder.m_128437_("HearthWhitelist", 8)) {
                list.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_7916_())));
            }
            return list;
        }, saver -> WorldSettingsConfig.getInstance().setHearthSpreadWhitelist(saver.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).toList()));
        HEARTH_SPREAD_BLACKLIST = ConfigSettings.addSyncedSetting("hearth_spread_blacklist", () -> ConfigHelper.getBlocks(WorldSettingsConfig.getInstance().getHearthSpreadBlacklist().toArray(new String[0])), encoder -> {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (Block entry : encoder) {
                list.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)entry).toString()));
            }
            tag.m_128365_("HearthBlacklist", (Tag)list);
            return tag;
        }, decoder -> {
            ArrayList<Block> list = new ArrayList<Block>();
            for (Tag entry : decoder.m_128437_("HearthBlacklist", 8)) {
                list.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_7916_())));
            }
            return list;
        }, saver -> WorldSettingsConfig.getInstance().setHearthSpreadBlacklist(saver.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).toList()));
        HEARTH_STRENGTH = ConfigSettings.addSetting("hearth_effect", () -> WorldSettingsConfig.getInstance().getHearthStrength());
        SMART_HEARTH = ConfigSettings.addSetting("smart_hearth", () -> WorldSettingsConfig.getInstance().isSmartHearth());
        CELSIUS = ConfigSettings.addClientSetting("celsius", () -> ClientSettingsConfig.getInstance().isCelsius());
        TEMP_OFFSET = ConfigSettings.addClientSetting("temp_offset", () -> ClientSettingsConfig.getInstance().getTempOffset());
        TEMP_SMOOTHING = ConfigSettings.addClientSetting("temp_smoothing", () -> ClientSettingsConfig.getInstance().getTempSmoothing());
        BODY_ICON_POS = ConfigSettings.addClientSetting("body_icon_pos", () -> new Vec2i(ClientSettingsConfig.getInstance().getBodyIconX(), ClientSettingsConfig.getInstance().getBodyIconY()));
        BODY_ICON_ENABLED = ConfigSettings.addClientSetting("body_icon_enabled", () -> ClientSettingsConfig.getInstance().isBodyIconEnabled());
        MOVE_BODY_ICON_WHEN_ADVANCED = ConfigSettings.addClientSetting("move_body_icon_for_advanced", () -> ClientSettingsConfig.getInstance().moveBodyIconWhenAdvanced());
        BODY_READOUT_POS = ConfigSettings.addClientSetting("body_readout_pos", () -> new Vec2i(ClientSettingsConfig.getInstance().getBodyReadoutX(), ClientSettingsConfig.getInstance().getBodyReadoutY()));
        BODY_READOUT_ENABLED = ConfigSettings.addClientSetting("body_readout_enabled", () -> ClientSettingsConfig.getInstance().isBodyReadoutEnabled());
        WORLD_GAUGE_POS = ConfigSettings.addClientSetting("world_gauge_pos", () -> new Vec2i(ClientSettingsConfig.getInstance().getWorldGaugeX(), ClientSettingsConfig.getInstance().getWorldGaugeY()));
        WORLD_GAUGE_ENABLED = ConfigSettings.addClientSetting("world_gauge_enabled", () -> ClientSettingsConfig.getInstance().isWorldGaugeEnabled());
        CUSTOM_HOTBAR_LAYOUT = ConfigSettings.addClientSetting("custom_hotbar_layout", () -> ClientSettingsConfig.getInstance().isCustomHotbarLayout());
        ICON_BOBBING = ConfigSettings.addClientSetting("icon_bobbing", () -> ClientSettingsConfig.getInstance().isIconBobbing());
        HEARTH_DEBUG = ConfigSettings.addClientSetting("hearth_debug", () -> ClientSettingsConfig.getInstance().isHearthDebug());
        SHOW_CONFIG_BUTTON = ConfigSettings.addClientSetting("show_config_button", () -> ClientSettingsConfig.getInstance().showConfigButton());
        CONFIG_BUTTON_POS = ConfigSettings.addClientSetting("config_button_pos", () -> new Vec2i(ClientSettingsConfig.getInstance().getConfigButtonPos().get(0), ClientSettingsConfig.getInstance().getConfigButtonPos().get(1)));
        DISTORTION_EFFECTS = ConfigSettings.addClientSetting("distortion_effects", () -> ClientSettingsConfig.getInstance().areDistortionsEnabled());
        HIGH_CONTRAST = ConfigSettings.addClientSetting("high_contrast", () -> ClientSettingsConfig.getInstance().isHighContrast());
        SHOW_CREATIVE_WARNING = ConfigSettings.addClientSetting("show_creative_warning", () -> ClientSettingsConfig.getInstance().showCreativeWarning());
        boolean ssLoaded = CompatManager.isSereneSeasonsLoaded();
        SUMMER_TEMPS = ConfigSettings.addSetting("summer_temps", ssLoaded ? () -> WorldSettingsConfig.getInstance().getSummerTemps() : () -> new Double[3]);
        AUTUMN_TEMPS = ConfigSettings.addSetting("autumn_temps", ssLoaded ? () -> WorldSettingsConfig.getInstance().getAutumnTemps() : () -> new Double[3]);
        WINTER_TEMPS = ConfigSettings.addSetting("winter_temps", ssLoaded ? () -> WorldSettingsConfig.getInstance().getWinterTemps() : () -> new Double[3]);
        SPRING_TEMPS = ConfigSettings.addSetting("spring_temps", ssLoaded ? () -> WorldSettingsConfig.getInstance().getSpringTemps() : () -> new Double[3]);
    }

    public static enum Difficulty {
        SUPER_EASY(Map.of("min_temp", () -> Temperature.convert(40.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(120.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 0.5, "require_thermometer", () -> false, "fire_resistance_enabled", () -> true, "ice_resistance_enabled", () -> true, "damage_scaling", () -> false)),
        EASY(Map.of("min_temp", () -> Temperature.convert(45.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(110.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 0.75, "require_thermometer", () -> false, "fire_resistance_enabled", () -> true, "ice_resistance_enabled", () -> true, "damage_scaling", () -> false)),
        NORMAL(Map.of("min_temp", () -> Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 1.0, "require_thermometer", () -> true, "fire_resistance_enabled", () -> true, "ice_resistance_enabled", () -> true, "damage_scaling", () -> true)),
        HARD(Map.of("min_temp", () -> Temperature.convert(60.0, Temperature.Units.F, Temperature.Units.MC, true), "max_temp", () -> Temperature.convert(90.0, Temperature.Units.F, Temperature.Units.MC, true), "temp_rate", () -> 1.5, "require_thermometer", () -> true, "fire_resistance_enabled", () -> false, "ice_resistance_enabled", () -> false, "damage_scaling", () -> true)),
        CUSTOM(Map.of());

        private final Map<String, Supplier<?>> settings;

        private Difficulty(Map<String, Supplier<?>> settings) {
            this.settings = settings;
        }

        public <T> T getSetting(String id) {
            return (T)this.settings.get(id).get();
        }

        public <T> T getOrDefault(String id, T defaultValue) {
            return (T)this.settings.getOrDefault(id, () -> defaultValue).get();
        }

        public void load() {
            this.settings.forEach((id, loader) -> CONFIG_SETTINGS.get(id).set(loader.get()));
        }
    }
}

