/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;

public class ConfigUpdater {
    public static void updateConfigs() {
        String configVersion = MainSettingsConfig.getInstance().getVersion();
        ItemSettingsConfig itemSettings = ItemSettingsConfig.getInstance();
        WorldSettingsConfig worldSettings = WorldSettingsConfig.getInstance();
        if (ConfigUpdater.compareVersions(configVersion, "2.3-b06a") < 0) {
            ConfigUpdater.replaceConfigSetting(worldSettings::getBlockTemps, "minecraft:magma_block", blockTemp -> {
                blockTemp.set(1, 0.25);
                blockTemp.set(4, 1.0);
            }, worldSettings::setBlockTemps);
            ConfigUpdater.replaceConfigSetting(itemSettings::getIceboxFuelItems, "minecraft:ice", iceFuel -> iceFuel.set(1, 250), itemSettings::setIceboxFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getHearthFuelItems, "minecraft:ice", iceFuel -> iceFuel.set(1, -250), itemSettings::setHearthFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getIceboxFuelItems, "minecraft:snow_block", snowFuel -> snowFuel.set(1, 100), itemSettings::setIceboxFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getHearthFuelItems, "minecraft:snow_block", snowFuel -> snowFuel.set(1, -100), itemSettings::setHearthFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getIceboxFuelItems, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, 100), itemSettings::setIceboxFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getHearthFuelItems, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, -100), itemSettings::setHearthFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getIceboxFuelItems, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, 10), itemSettings::setIceboxFuelItems);
            ConfigUpdater.replaceConfigSetting(itemSettings::getHearthFuelItems, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, -10), itemSettings::setHearthFuelItems);
        }
        if (ConfigUpdater.compareVersions(configVersion, "2.3-b05b") < 0) {
            ConfigUpdater.removeConfigSetting(itemSettings::getHearthFuelItems, "minecraft:water_bucket", itemSettings::setHearthFuelItems);
            ConfigUpdater.removeConfigSetting(itemSettings::getIceboxFuelItems, "minecraft:water_bucket", itemSettings::setIceboxFuelItems);
        }
        if (ConfigUpdater.compareVersions(configVersion, "2.3-b04a") < 0) {
            ConfigUpdater.addConfigSetting(itemSettings::getFoodTemperatures, itemSettings::setFoodTemperatures, List.of("cold_sweat:soul_sprout", Double.valueOf(0.0), "{}", Integer.valueOf(1200)));
        }
        itemSettings.save();
        worldSettings.save();
        MainSettingsConfig.getInstance().setVersion(ModList.get().getModFileById("cold_sweat").versionString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compareVersions(String version, String comparedTo) {
        String[] v1Parts = version.split("\\.|\\-");
        String[] v2Parts = comparedTo.split("\\.|\\-");
        int finalValue = 0;
        try {
            if (version.isEmpty()) {
                finalValue = -1;
                int n = -1;
                return n;
            }
            for (int i = 0; i < v1Parts.length && i < v2Parts.length; ++i) {
                if (v1Parts[i].matches("\\d+") && v2Parts[i].matches("\\d+")) {
                    int num2;
                    int num1 = Integer.parseInt(v1Parts[i]);
                    if (num1 == (num2 = Integer.parseInt(v2Parts[i]))) continue;
                    int n = finalValue = Integer.compare(num1, num2);
                    return n;
                }
                int result = ConfigUpdater.comparePreReleaseVersions(v1Parts[i], v2Parts[i]);
                if (result == 0) continue;
                int n = finalValue = result;
                return n;
            }
            int n = finalValue = Integer.compare(v1Parts.length, v2Parts.length);
            return n;
        }
        finally {
            if (finalValue < 0) {
                ColdSweat.LOGGER.warn("Last launched version is less than {}. Updating config settings...", (Object)comparedTo);
            }
        }
    }

    private static int comparePreReleaseVersions(String v1, String v2) {
        if (v1.startsWith("b") && v2.startsWith("b")) {
            return ConfigUpdater.compareWithSubVersions(v1.substring(1), v2.substring(1));
        }
        return v1.compareTo(v2);
    }

    private static int compareWithSubVersions(String v1, String v2) {
        String[] parts1 = v1.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        String[] parts2 = v2.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        for (int i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(parts1[i]);
                if (num1 == (num2 = Integer.parseInt(parts2[i]))) continue;
                return Integer.compare(num1, num2);
            }
            int result = parts1[i].compareTo(parts2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static void replaceConfigSetting(Supplier<List<? extends List<?>>> getter, String key, Consumer<List<Object>> modifier, Consumer<List<? extends List<Object>>> setter) {
        ArrayList setting = new ArrayList((Collection)getter.get());
        for (int i = 0; i < setting.size(); ++i) {
            ArrayList element = new ArrayList((Collection)setting.get(i));
            if (element.isEmpty() || !element.get(0).equals(key)) continue;
            modifier.accept(element);
            setting.set(i, element);
            setter.accept(setting);
            break;
        }
    }

    public static void addConfigSetting(Supplier<List<? extends List<?>>> getter, Consumer<List<? extends List<? extends Object>>> setter, List<? extends Object> newSetting) {
        ArrayList<List<? extends Object>> setting = new ArrayList<List<? extends Object>>((Collection)getter.get());
        if (setting.stream().noneMatch(entry -> !entry.isEmpty() && entry.get(0).equals(newSetting.get(0)))) {
            setting.add(newSetting);
            setter.accept(setting);
        }
    }

    public static void removeConfigSetting(Supplier<List<? extends List<? extends Object>>> getter, String key, Consumer<List<? extends List<? extends Object>>> setter) {
        ArrayList<List> setting = new ArrayList<List>((Collection)getter.get());
        setting.removeIf(entry -> !entry.isEmpty() && entry.get(0).equals(key));
        setter.accept(setting);
    }
}

