/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ItemSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> boilerItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> iceboxItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> hearthItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedPotions;
    private static final ForgeConfigSpec.BooleanValue allowPotionsInHearth;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> soulLampItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> soulLampDimensions;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> temperatureFoods;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> insulatingItems;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> insulationBlacklist;
    private static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> insulatingArmor;
    private static final ForgeConfigSpec.ConfigValue<List<?>> insulationSlots;
    private static final ForgeConfigSpec.IntValue waterskinStrength;
    private static ForgeConfigSpec.ConfigValue<List<? extends List<?>>> insulatingCurios;
    static final ItemSettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/item_settings.toml");
    }

    public void save() {
        SPEC.save();
    }

    public static ItemSettingsConfig getInstance() {
        return INSTANCE;
    }

    public List<? extends List<?>> getBoilerFuelItems() {
        return (List)boilerItems.get();
    }

    public List<? extends List<?>> getIceboxFuelItems() {
        return (List)iceboxItems.get();
    }

    public List<? extends List<?>> getHearthFuelItems() {
        return (List)hearthItems.get();
    }

    public List<? extends List<?>> getInsulationItems() {
        return (List)insulatingItems.get();
    }

    public List<? extends List<?>> getInsulatingArmorItems() {
        return (List)insulatingArmor.get();
    }

    public List<?> getArmorInsulationSlots() {
        return (List)insulationSlots.get();
    }

    public List<? extends String> getInsulationBlacklist() {
        return (List)insulationBlacklist.get();
    }

    public List<? extends List<?>> getSoulLampFuelItems() {
        return (List)soulLampItems.get();
    }

    public List<? extends List<?>> getFoodTemperatures() {
        return (List)temperatureFoods.get();
    }

    public List<? extends String> getValidSoulLampDimensions() {
        return (List)soulLampDimensions.get();
    }

    public int getWaterskinStrength() {
        return (Integer)waterskinStrength.get();
    }

    public boolean arePotionsEnabled() {
        return (Boolean)allowPotionsInHearth.get();
    }

    public List<String> getPotionBlacklist() {
        return (List)blacklistedPotions.get();
    }

    public List<? extends List<?>> getInsulatingCurios() {
        return CompatManager.isCuriosLoaded() ? (List)insulatingCurios.get() : List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBoilerFuelItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = boilerItems;
        synchronized (configValue) {
            boilerItems.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIceboxFuelItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = iceboxItems;
        synchronized (configValue) {
            iceboxItems.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHearthFuelItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = hearthItems;
        synchronized (configValue) {
            hearthItems.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulationItems(List<? extends List<?>> items) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = insulatingItems;
        synchronized (configValue) {
            insulatingItems.set(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulatingArmorItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = insulatingArmor;
        synchronized (configValue) {
            insulatingArmor.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setArmorInsulationSlots(List<?> slots) {
        ForgeConfigSpec.ConfigValue<List<?>> configValue = insulationSlots;
        synchronized (configValue) {
            insulationSlots.set(slots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSoulLampFuelItems(List<? extends List<?>> items) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = soulLampItems;
        synchronized (configValue) {
            soulLampItems.set(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFoodTemperatures(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = temperatureFoods;
        synchronized (configValue) {
            temperatureFoods.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValidSoulLampDimensions(List<? extends String> items) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = soulLampDimensions;
        synchronized (configValue) {
            soulLampDimensions.set(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setWaterskinStrength(int strength) {
        ForgeConfigSpec.IntValue intValue = waterskinStrength;
        synchronized (intValue) {
            waterskinStrength.set((Object)strength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPotionsEnabled(Boolean saver) {
        ForgeConfigSpec.BooleanValue booleanValue = allowPotionsInHearth;
        synchronized (booleanValue) {
            allowPotionsInHearth.set((Object)saver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPotionBlacklist(List<String> saver) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = blacklistedPotions;
        synchronized (configValue) {
            blacklistedPotions.set(saver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulationBlacklist(List<String> blacklist) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = insulationBlacklist;
        synchronized (configValue) {
            insulationBlacklist.set(blacklist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulatingCurios(List<? extends List<?>> items) {
        if (CompatManager.isCuriosLoaded()) {
            ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = insulatingCurios;
            synchronized (configValue) {
                insulatingCurios.set(items);
            }
        }
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new ItemSettingsConfig();
        BUILDER.push("Fuel Items").comment(new String[]{"Defines items that can be used as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"});
        boilerItems = BUILDER.defineListAllowEmpty(List.of("Boiler"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("minecraft:coal", Integer.valueOf(37)), List.of("minecraft:charcoal", Integer.valueOf(37)), List.of("#minecraft:logs_that_burn", Integer.valueOf(37)), List.of("minecraft:coal_block", Integer.valueOf(333)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        iceboxItems = BUILDER.defineListAllowEmpty(List.of("Icebox"), () -> ListBuilder.begin(new List[]{List.of("minecraft:snowball", Integer.valueOf(10)), List.of("minecraft:clay_ball", Integer.valueOf(37)), List.of("minecraft:snow_block", Integer.valueOf(100)), List.of("minecraft:ice", Integer.valueOf(250)), List.of("minecraft:clay", Integer.valueOf(333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(100)), List.of("minecraft:packed_ice", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        hearthItems = BUILDER.comment("Negative values indicate cold fuel").defineListAllowEmpty(List.of("Hearth"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("minecraft:coal", Integer.valueOf(37)), List.of("minecraft:charcoal", Integer.valueOf(37)), List.of("#minecraft:logs_that_burn", Integer.valueOf(37)), List.of("minecraft:coal_block", Integer.valueOf(333)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000)), List.of("minecraft:snowball", Integer.valueOf(-37)), List.of("minecraft:clay_ball", Integer.valueOf(-37)), List.of("minecraft:snow_block", Integer.valueOf(-333)), List.of("minecraft:ice", Integer.valueOf(-333)), List.of("minecraft:clay", Integer.valueOf(-333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(-333)), List.of("minecraft:water_bucket", Integer.valueOf(-1000)), List.of("minecraft:packed_ice", Integer.valueOf(-1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        blacklistedPotions = BUILDER.comment(new String[]{"Potions containing any of these effects will not be allowed in the hearth", "Format: [\"effect_id\", \"effect_id\", ...etc]"}).defineListAllowEmpty(List.of("Blacklisted Hearth Potions"), () -> ListBuilder.begin(new String[]{"minecraft:instant_damage", "minecraft:poison", "minecraft:wither", "minecraft:weakness", "minecraft:mining_fatigue", "minecraft:slowness"}).build(), it -> it instanceof String);
        allowPotionsInHearth = BUILDER.comment(new String[]{"If true, potions can be used as fuel in the hearth", "This gives all players in range the potion effect"}).define("Allow Potions in Hearth", true);
        BUILDER.pop();
        BUILDER.push("Soulspring Lamp");
        soulLampItems = BUILDER.comment(new String[]{"Defines items that the Soulspring Lamp can use as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"}).defineListAllowEmpty(List.of("Fuel Items"), () -> ListBuilder.begin(List.of("cold_sweat:soul_sprout", Integer.valueOf(4))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        soulLampDimensions = BUILDER.comment(new String[]{"Defines the dimensions that the Soulspring Lamp can be used in", "Format: [\"dimension-id-1\", \"dimension-id-2\", ...etc]"}).defineListAllowEmpty(List.of("Valid Dimensions"), () -> ListBuilder.begin("minecraft:the_nether").build(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Insulation");
        insulatingItems = BUILDER.comment(new String[]{"Defines the items that can be used for insulating armor in the Sewing Table", "Format: [[\"item_id\", cold, hot, \"static\", *nbt], [\"item_id\", amount, adapt-speed, \"adaptive\", *nbt], ...etc]", "\"item_id\": The item's ID (i.e. \"minecraft:iron_ingot\"). Accepts tags with \"#\" (i.e. \"#minecraft:wool\").", "", "Adaptive Insulation: ", "\"amount\": The amount of insulation the item provides.", "\"adapt-speed\": The speed at which the insulation adapts to the environment.", "*\"type\": Optional. Either \"static\" or \"adaptive\". Defines the insulation type. Defaults to static.", "*\"nbt\": Optional. If set, the item will only provide insulation if it has the specified NBT tag.", "", "Static Insulation: ", "\"cold\": The amount of cold insulation the item provides.", "\"hot\": The amount of heat insulation the item provides.", "*\"type\": Optional. Either \"static\" or \"adaptive\". Defines the insulation type. Defaults to static.", "*\"nbt\": Optional. If set, the item will only provide insulation if it has the specified NBT tag."}).defineListAllowEmpty(List.of("Insulation Ingredients"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather_helmet", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather_chestplate", Integer.valueOf(6), Integer.valueOf(6)), List.of("minecraft:leather_leggings", Integer.valueOf(5), Integer.valueOf(5)), List.of("minecraft:leather_boots", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather", Integer.valueOf(1), Integer.valueOf(1)), List.of("cold_sweat:chameleon_molt", Integer.valueOf(2), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:hoglin_hide", Integer.valueOf(0), Integer.valueOf(2)), List.of("cold_sweat:fur", Integer.valueOf(2), Integer.valueOf(0)), List.of("#minecraft:wool", Double.valueOf(1.5), Integer.valueOf(0)), List.of("minecraft:rabbit_hide", Integer.valueOf(0), Double.valueOf(1.5)), List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(12)), List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:fur_cap", Integer.valueOf(8), Integer.valueOf(0)), List.of("cold_sweat:fur_parka", Integer.valueOf(12), Integer.valueOf(0)), List.of("cold_sweat:fur_pants", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:fur_boots", Integer.valueOf(8), Integer.valueOf(0))}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_hair", Double.valueOf(1.5), Integer.valueOf(-1)))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        });
        insulatingArmor = BUILDER.comment(new String[]{"Defines the items that provide insulation when worn", "See Insulation Ingredients for formatting"}).defineListAllowEmpty(List.of("Insulating Armor"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather_helmet", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather_chestplate", Integer.valueOf(6), Integer.valueOf(6)), List.of("minecraft:leather_leggings", Integer.valueOf(5), Integer.valueOf(5)), List.of("minecraft:leather_boots", Integer.valueOf(4), Integer.valueOf(4)), List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(12)), List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:fur_cap", Integer.valueOf(8), Integer.valueOf(0)), List.of("cold_sweat:fur_parka", Integer.valueOf(12), Integer.valueOf(0)), List.of("cold_sweat:fur_pants", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:fur_boots", Integer.valueOf(8), Integer.valueOf(0))}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_pants", Double.valueOf(7.5), Integer.valueOf(-5)))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        });
        if (CompatManager.isCuriosLoaded()) {
            insulatingCurios = BUILDER.comment(new String[]{"Defines the items that provide insulation when worn in a curio slot", "See Insulation Ingredients for formatting"}).defineListAllowEmpty(List.of("Insulating Curios"), () -> List.of(), it -> {
                List list;
                return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
            });
        }
        insulationSlots = BUILDER.comment(new String[]{"Defines how many insulation slots armor pieces have", "There are 4 modes for this setting:", "Static: Each armor slot (head, body, legs, feet) has a fixed number of insulation slots", "- Format: [head, body, legs, feet] (a list of integers; insulation slot count for each armor slot)", " ", "Linear: Number of slots increases steadily with protection", "Exponential: Number of slots increases rapidly with protection", "Logarithmic: Number of slots increases with protection, with diminishing returns", "- Format: [number, max-slots] (a positive integer or decimal; the rate of increase)"}).defineList("Insulation Slots", List.of("static", Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(5), Integer.valueOf(4)), it -> it instanceof Number || it instanceof String);
        insulationBlacklist = BUILDER.comment(new String[]{"Defines wearable items that cannot be insulated", "Format: [\"item_id\", \"item_id\", ...etc]"}).defineListAllowEmpty(List.of("Insulation Blacklist"), () -> List.of(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Consumables");
        temperatureFoods = BUILDER.comment(new String[]{"Defines items that affect the player's temperature when consumed", "Format: [[\"item_id\", amount, *nbt, *duration], [\"item_id\", amount, *nbt, *duration], ...etc]", "Negative values are cold foods, positive values are hot foods", "nbt: Optional. If set, the item will only affect the player's temperature if it has the specified NBT tag.", "duration: Optional. If set, the player's temperature will remain increased/decreased for this amount of time."}).defineListAllowEmpty(List.of("Temperature-Affecting Foods"), () -> Arrays.asList(List.of("cold_sweat:soul_sprout", Integer.valueOf(-20), "{}", Integer.valueOf(1200))), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 2 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof String) || list.size() >= 4 && !(list.get(3) instanceof Number));
        });
        waterskinStrength = BUILDER.comment("Defines how much a waterskin will change the player's body temperature by when used").defineInRange("Waterskin Strength", 50, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

