/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class MainSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final MainSettingsConfig INSTANCE;
    public static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<Integer> difficulty;
    public static final ForgeConfigSpec.ConfigValue<String> version;
    public static final ForgeConfigSpec.ConfigValue<Double> maxHabitable;
    public static final ForgeConfigSpec.ConfigValue<Double> minHabitable;
    public static final ForgeConfigSpec.ConfigValue<Double> rateMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> tempDamage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fireResistanceEffect;
    public static final ForgeConfigSpec.ConfigValue<Boolean> iceResistanceEffect;
    public static final ForgeConfigSpec.ConfigValue<Boolean> damageScaling;
    public static final ForgeConfigSpec.ConfigValue<Boolean> requireThermometer;
    public static final ForgeConfigSpec.ConfigValue<Integer> gracePeriodLength;
    public static final ForgeConfigSpec.ConfigValue<Boolean> gracePeriodEnabled;
    public static final ForgeConfigSpec.ConfigValue<Double> heatstrokeFog;
    public static final ForgeConfigSpec.ConfigValue<Double> freezingHearts;
    public static final ForgeConfigSpec.ConfigValue<Double> coldKnockback;
    public static final ForgeConfigSpec.ConfigValue<Double> coldMining;
    public static final ForgeConfigSpec.ConfigValue<Double> coldMovement;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/main.toml");
    }

    public static MainSettingsConfig getInstance() {
        return INSTANCE;
    }

    public String getVersion() {
        return (String)version.get();
    }

    public int getDifficulty() {
        return (Integer)difficulty.get();
    }

    public boolean isFireResistanceEnabled() {
        return (Boolean)fireResistanceEffect.get();
    }

    public boolean isIceResistanceEnabled() {
        return (Boolean)iceResistanceEffect.get();
    }

    public boolean thermometerRequired() {
        return (Boolean)requireThermometer.get();
    }

    public boolean doDamageScaling() {
        return (Boolean)damageScaling.get();
    }

    public double getTempDamage() {
        return (Double)tempDamage.get();
    }

    public double getMinTempHabitable() {
        return (Double)minHabitable.get();
    }

    public double getMaxTempHabitable() {
        return (Double)maxHabitable.get();
    }

    public double getRateMultiplier() {
        return (Double)rateMultiplier.get();
    }

    public int getGracePeriodLength() {
        return (Integer)gracePeriodLength.get();
    }

    public boolean isGracePeriodEnabled() {
        return (Boolean)gracePeriodEnabled.get();
    }

    public double getHeatstrokeFogDistance() {
        return (Double)heatstrokeFog.get();
    }

    public double getHeartsFreezingPercentage() {
        return (Double)freezingHearts.get();
    }

    public double getColdKnockbackReduction() {
        return (Double)coldKnockback.get();
    }

    public double getColdMiningImpairment() {
        return (Double)coldMining.get();
    }

    public double getColdMovementSlowdown() {
        return (Double)coldMovement.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setVersion(String version) {
        ForgeConfigSpec.ConfigValue<String> configValue = MainSettingsConfig.version;
        synchronized (configValue) {
            MainSettingsConfig.version.set((Object)version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDifficulty(int value) {
        ForgeConfigSpec.ConfigValue<Integer> configValue = difficulty;
        synchronized (configValue) {
            difficulty.set((Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaxHabitable(double temp) {
        ForgeConfigSpec.ConfigValue<Double> configValue = maxHabitable;
        synchronized (configValue) {
            maxHabitable.set((Object)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMinHabitable(double temp) {
        ForgeConfigSpec.ConfigValue<Double> configValue = minHabitable;
        synchronized (configValue) {
            minHabitable.set((Object)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRateMultiplier(double rate) {
        ForgeConfigSpec.ConfigValue<Double> configValue = rateMultiplier;
        synchronized (configValue) {
            rateMultiplier.set((Object)rate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFireResistanceEnabled(boolean isEffective) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = fireResistanceEffect;
        synchronized (configValue) {
            fireResistanceEffect.set((Object)isEffective);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIceResistanceEnabled(boolean isEffective) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = iceResistanceEffect;
        synchronized (configValue) {
            iceResistanceEffect.set((Object)isEffective);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRequireThermometer(boolean required) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = requireThermometer;
        synchronized (configValue) {
            requireThermometer.set((Object)required);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDamageScaling(boolean enabled) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = damageScaling;
        synchronized (configValue) {
            damageScaling.set((Object)enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTempDamage(double damage) {
        ForgeConfigSpec.ConfigValue<Double> configValue = tempDamage;
        synchronized (configValue) {
            tempDamage.set((Object)damage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setGracePeriodLength(int ticks) {
        ForgeConfigSpec.ConfigValue<Integer> configValue = gracePeriodLength;
        synchronized (configValue) {
            gracePeriodLength.set((Object)ticks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setGracePeriodEnabled(boolean enabled) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = gracePeriodEnabled;
        synchronized (configValue) {
            gracePeriodEnabled.set((Object)enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHeatstrokeFogDistance(double distance) {
        ForgeConfigSpec.ConfigValue<Double> configValue = heatstrokeFog;
        synchronized (configValue) {
            heatstrokeFog.set((Object)distance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHeartsFreezingPercentage(double percent) {
        ForgeConfigSpec.ConfigValue<Double> configValue = freezingHearts;
        synchronized (configValue) {
            freezingHearts.set((Object)percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdKnockbackReduction(double amount) {
        ForgeConfigSpec.ConfigValue<Double> configValue = coldKnockback;
        synchronized (configValue) {
            coldKnockback.set((Object)amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdMiningImpairment(double amount) {
        ForgeConfigSpec.ConfigValue<Double> configValue = coldMining;
        synchronized (configValue) {
            coldMining.set((Object)amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdMovementSlowdown(double amount) {
        ForgeConfigSpec.ConfigValue<Double> configValue = coldMovement;
        synchronized (configValue) {
            coldMovement.set((Object)amount);
        }
    }

    public void save() {
        SPEC.save();
    }

    static {
        INSTANCE = new MainSettingsConfig();
        BUILDER = new ForgeConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.comment("DO NOT EDIT THE SETTINGS IN THIS SECTION").push("Builtin");
        difficulty = BUILDER.defineInRange("Difficulty", defaultDiff.ordinal(), 0, ConfigSettings.Difficulty.values().length - 1);
        version = BUILDER.define("Version", (Object)"");
        BUILDER.pop();
        BUILDER.push("Difficulty");
        minHabitable = BUILDER.comment("Defines the minimum habitable temperature").defineInRange("Minimum Habitable Temperature", defaultDiff.getOrDefault("min_temp", Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true)).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        maxHabitable = BUILDER.comment("Defines the maximum habitable temperature").defineInRange("Maximum Habitable Temperature", defaultDiff.getOrDefault("max_temp", Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true)).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        rateMultiplier = BUILDER.comment("Rate at which the player's body temperature changes (default: 1.0 (100%))").defineInRange("Rate Multiplier", defaultDiff.getOrDefault("temp_rate", 1.0).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        tempDamage = BUILDER.comment("Damage dealt to the player when they are too hot or too cold").defineInRange("Temperature Damage", defaultDiff.getOrDefault("temp_damage", 2.0).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        damageScaling = BUILDER.comment("Sets whether damage scales with difficulty").define("Damage Scaling", (Object)defaultDiff.getOrDefault("damage_scaling", true));
        BUILDER.pop();
        BUILDER.push("Items");
        fireResistanceEffect = BUILDER.comment("Allow fire resistance to block overheating damage").define("Fire Resistance Immunity", (Object)defaultDiff.getOrDefault("fire_resistance_enabled", true));
        iceResistanceEffect = BUILDER.comment("Allow ice resistance to block freezing damage").define("Ice Resistance Immunity", (Object)defaultDiff.getOrDefault("ice_resistance_enabled", true));
        requireThermometer = BUILDER.comment("Thermometer item is required to see detailed world temperature").define("Require Thermometer", (Object)defaultDiff.getOrDefault("require_thermometer", true));
        BUILDER.pop();
        BUILDER.push("Temperature Effects");
        BUILDER.push("Hot");
        heatstrokeFog = BUILDER.comment("When set to true, the player's view distance will decrease when they are too hot").defineInRange("Heatstroke Fog", defaultDiff.getOrDefault("heatstroke_fog", 6.0).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Cold");
        freezingHearts = BUILDER.comment(new String[]{"When set to true, this percentage of the player's hearts will freeze over when they are too cold, preventing regeneration", "Represented as a percentage"}).defineInRange("Freezing Hearts Percentage", defaultDiff.getOrDefault("freezing_hearts", 0.5).doubleValue(), 0.0, 1.0);
        coldKnockback = BUILDER.comment(new String[]{"When set to true, the player's attack knockback will be reduced by this amount when they are too cold", "Represented as a percentage"}).defineInRange("Chilled Knockback Reduction", defaultDiff.getOrDefault("knockback_impairment", 0.5).doubleValue(), 0.0, 1.0);
        coldMovement = BUILDER.comment(new String[]{"When set to true, the player's movement speed will be reduced by this amount when they are too cold", "Represented as a percentage"}).defineInRange("Chilled Movement Slowdown", defaultDiff.getOrDefault("cold_slowness", 0.5).doubleValue(), 0.0, 1.0);
        coldMining = BUILDER.comment(new String[]{"When set to true, the player's mining speed will be reduced by this amount when they are too cold", "Represented as a percentage"}).defineInRange("Chilled Mining Speed Reduction", defaultDiff.getOrDefault("cold_break_speed", 0.5).doubleValue(), 0.0, 1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Grace Period");
        gracePeriodLength = BUILDER.comment("The number of ticks after the player spawns during which they are immune to temperature effects").defineInRange("Grace Period Length", defaultDiff.getOrDefault("grace_length", 6000).intValue(), 0, Integer.MAX_VALUE);
        gracePeriodEnabled = BUILDER.comment("Enables the grace period").define("Grace Period Enabled", (Object)defaultDiff.getOrDefault("grace_enabled", true));
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

