/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.ColdSweat;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TaskScheduler {
    static final ConcurrentLinkedQueue<QueueEntry> SERVER_SCHEDULE = new ConcurrentLinkedQueue();
    static final ConcurrentLinkedQueue<QueueEntry> CLIENT_SCHEDULE = new ConcurrentLinkedQueue();

    @SubscribeEvent
    public static void runScheduledTasks(TickEvent event) {
        if ((event instanceof TickEvent.ServerTickEvent || event instanceof TickEvent.ClientTickEvent) && event.phase == TickEvent.Phase.START) {
            ConcurrentLinkedQueue<QueueEntry> schedule;
            ConcurrentLinkedQueue<QueueEntry> concurrentLinkedQueue = schedule = event.side.isClient() ? CLIENT_SCHEDULE : SERVER_SCHEDULE;
            if (!schedule.isEmpty()) {
                schedule.removeIf(entry -> {
                    int ticks = entry.time;
                    if (ticks <= 0) {
                        try {
                            entry.task.run();
                        }
                        catch (Exception e) {
                            ColdSweat.LOGGER.error("Error while running scheduled task", (Throwable)e);
                            throw e;
                        }
                        return true;
                    }
                    entry.time = ticks - 1;
                    return false;
                });
            }
        }
    }

    public static void scheduleServer(Runnable task, int delay) {
        SERVER_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void scheduleClient(Runnable task, int delay) {
        CLIENT_SCHEDULE.add(new QueueEntry(task, delay));
    }

    public static void schedule(Runnable task, int delay) {
        TaskScheduler.scheduleServer(task, delay);
        TaskScheduler.scheduleClient(task, delay);
    }

    static class QueueEntry {
        private final Runnable task;
        private int time;

        public QueueEntry(Runnable task, int time) {
            this.task = task;
            this.time = time;
        }

        public Runnable getTask() {
            return this.task;
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }
    }
}

