/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraftforge.registries.ForgeRegistries;

public record BlockTempData(List<Either<TagKey<Block>, Block>> blocks, double temperature, double range, double maxEffect, boolean fade, BlockPredicate condition, Optional<CompoundTag> nbt, Optional<List<String>> requiredMods) {
    public static final Codec<BlockTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)TagKey.m_203877_((ResourceKey)Registry.f_122901_), (Codec)ForgeRegistries.BLOCKS.getCodec()).listOf().fieldOf("blocks").forGetter(BlockTempData::blocks), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(BlockTempData::temperature), (App)Codec.DOUBLE.optionalFieldOf("max_effect", (Object)Double.MAX_VALUE).forGetter(BlockTempData::maxEffect), (App)Codec.DOUBLE.optionalFieldOf("range", (Object)Double.MAX_VALUE).forGetter(BlockTempData::range), (App)Codec.BOOL.optionalFieldOf("fade", (Object)true).forGetter(BlockTempData::fade), (App)BlockPredicate.f_190392_.optionalFieldOf("condition", (Object)BlockPredicate.m_190435_()).forGetter(BlockTempData::condition), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(BlockTempData::nbt), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(BlockTempData::requiredMods)).apply((Applicative)instance, BlockTempData::new));

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlockTempData{blocks=[");
        for (Either<TagKey<Block>, Block> block : this.blocks) {
            if (block.left().isPresent()) {
                builder.append("#").append(((TagKey)block.left().get()).toString());
            } else {
                builder.append(((Block)block.right().get()).toString());
            }
            builder.append(", ");
        }
        builder.append("], temperature=").append(this.temperature).append(", range=").append(this.range).append(", maxEffect=").append(this.maxEffect).append(", fade=").append(this.fade).append(", condition=").append(this.condition);
        this.nbt.ifPresent(tag -> builder.append(", nbt=").append(tag));
        this.requiredMods.ifPresent(mods -> builder.append(", requiredMods=").append(mods));
        builder.append("}");
        return builder.toString();
    }
}

