/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record DepthTempData(List<TempRegion> temperatures) {
    public static final Codec<DepthTempData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TempRegion.CODEC.listOf().fieldOf("regions").forGetter(DepthTempData::temperatures)).apply((Applicative)instance, DepthTempData::new));

    public boolean withinBounds(Level level, BlockPos pos) {
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Double getTemperature(double temperature, BlockPos pos, Level level) {
        for (TempRegion region : this.temperatures) {
            if (!region.withinBounds(level, pos)) continue;
            return region.getTemperature(temperature, pos, level);
        }
        return null;
    }

    public record TempRegion(RampType rampType, VerticalBound top, VerticalBound bottom) {
        public static final Codec<TempRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RampType.CODEC.optionalFieldOf("type", (Object)RampType.LINEAR).forGetter(TempRegion::rampType), (App)VerticalBound.CODEC.fieldOf("top").forGetter(TempRegion::top), (App)VerticalBound.CODEC.fieldOf("bottom").forGetter(TempRegion::bottom)).apply((Applicative)instance, (type, top, bottom) -> {
            if (type == RampType.CONSTANT && !top.temperature.equals(bottom.temperature)) {
                throw new IllegalArgumentException("Constant temperature ramp type must have a single temperature value; got " + top.temperature + " and " + bottom.temperature);
            }
            return new TempRegion((RampType)((Object)((Object)type)), (VerticalBound)top, (VerticalBound)bottom);
        }));

        public boolean withinBounds(Level level, BlockPos pos) {
            return pos.m_123342_() <= this.top.getHeight(pos, level) && pos.m_123342_() >= this.bottom.getHeight(pos, level);
        }

        public double getTemperature(double temperature, BlockPos pos, Level level) {
            double topTemp = Temperature.convert(this.top.getTemperature(temperature), this.top.units, Temperature.Units.MC, true);
            double bottomTemp = Temperature.convert(this.bottom.getTemperature(temperature), this.bottom.units, Temperature.Units.MC, true);
            return switch (this.rampType) {
                default -> throw new IncompatibleClassChangeError();
                case RampType.CONSTANT -> {
                    if (pos.m_123342_() <= this.bottom.getHeight(pos, level)) {
                        yield bottomTemp;
                    }
                    yield topTemp;
                }
                case RampType.LINEAR -> CSMath.blend(bottomTemp, topTemp, (double)pos.m_123342_(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                case RampType.EXPONENTIAL -> CSMath.blendExp(bottomTemp, topTemp, (double)pos.m_123342_(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
                case RampType.LOGARITHMIC -> CSMath.blendLog(bottomTemp, topTemp, (double)pos.m_123342_(), (double)this.bottom.getHeight(pos, level), (double)this.top.getHeight(pos, level));
            };
        }
    }

    public static enum VerticalAnchor implements StringRepresentable
    {
        CONSTANT("constant"),
        WORLD_TOP("world_top"),
        WORLD_BOTTOM("world_bottom"),
        GROUND_LEVEL("ground_level");

        private final String name;
        public static final Codec<VerticalAnchor> CODEC;

        private VerticalAnchor(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static VerticalAnchor byName(String name) {
            for (VerticalAnchor type : VerticalAnchor.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown vertical anchor: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(VerticalAnchor::byName, VerticalAnchor::m_7912_);
        }
    }

    public static enum RampType implements StringRepresentable
    {
        CONSTANT("constant"),
        LINEAR("linear"),
        EXPONENTIAL("exponential"),
        LOGARITHMIC("logarithmic");

        private final String name;
        public static final Codec<RampType> CODEC;

        private RampType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static RampType byName(String name) {
            for (RampType type : RampType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown ramp type: " + name);
        }

        static {
            CODEC = Codec.STRING.xmap(RampType::byName, RampType::m_7912_);
        }
    }

    public record VerticalBound(VerticalAnchor anchor, Integer depth, Temperature.Units units, TempContainer temperature) {
        public static final TempContainer DEFAULT_PASSTHROUGH = new TempContainer(0.0, ContainerType.PASSTHROUGH, 1.0);
        public static final TempContainer DEFAULT_MIDPOINT = new TempContainer(0.0, ContainerType.MIDPOINT, 1.0);
        public static final Codec<VerticalBound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.CODEC.optionalFieldOf("anchor", (Object)VerticalAnchor.CONSTANT).forGetter(VerticalBound::anchor), (App)Codec.INT.fieldOf("depth").forGetter(VerticalBound::depth), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(VerticalBound::units), (App)TempContainer.CODEC.fieldOf("temperature").forGetter(VerticalBound::temperature)).apply((Applicative)instance, VerticalBound::new));

        public int getHeight(BlockPos checkPos, Level level) {
            return switch (this.anchor) {
                default -> throw new IncompatibleClassChangeError();
                case VerticalAnchor.CONSTANT -> this.depth;
                case VerticalAnchor.WORLD_TOP -> level.m_151558_();
                case VerticalAnchor.WORLD_BOTTOM -> level.m_141937_();
                case VerticalAnchor.GROUND_LEVEL -> WorldHelper.getHeight(checkPos, level) + this.depth;
            };
        }

        public double getTemperature(double temperature) {
            return switch (this.temperature.type) {
                default -> throw new IncompatibleClassChangeError();
                case ContainerType.NONE -> this.temperature.temperature;
                case ContainerType.PASSTHROUGH -> temperature;
                case ContainerType.MIDPOINT -> (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0;
            };
        }

        public record TempContainer(double temperature, ContainerType type, double strength) {
            public static final Codec<TempContainer> CODEC = Codec.either((Codec)Codec.DOUBLE, (Codec)Codec.STRING).flatXmap(either -> {
                double strength;
                if (either.left().isPresent()) {
                    return DataResult.success((Object)new TempContainer((Double)either.left().get(), ContainerType.NONE, 1.0));
                }
                String[] value = ((String)either.right().get()).split(",");
                double d = strength = value.length == 2 ? Double.parseDouble(value[1]) : 1.0;
                if (value[0].equals("passthrough")) {
                    return DataResult.success((Object)new TempContainer(0.0, ContainerType.PASSTHROUGH, strength));
                }
                if (value[0].equals("midpoint")) {
                    return DataResult.success((Object)new TempContainer(0.0, ContainerType.MIDPOINT, strength));
                }
                return DataResult.error((String)("Unknown temperature value: " + value));
            }, value -> {
                String strength;
                String string = strength = value.type == ContainerType.NONE ? "" : "," + value.strength;
                if (value.type == ContainerType.PASSTHROUGH) {
                    return DataResult.success((Object)Either.right((Object)("passthrough" + strength)));
                }
                if (value.type == ContainerType.MIDPOINT) {
                    return DataResult.success((Object)Either.right((Object)("midpoint" + strength)));
                }
                return DataResult.success((Object)Either.left((Object)value.temperature));
            });

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof TempContainer)) return false;
                TempContainer container = (TempContainer)obj;
                if (container.temperature != this.temperature) return false;
                if (container.type != this.type) return false;
                if (container.strength != this.strength) return false;
                return true;
            }
        }

        public static enum ContainerType implements StringRepresentable
        {
            NONE("none"),
            PASSTHROUGH("passthrough"),
            MIDPOINT("midpoint");

            private final String name;
            public static final Codec<ContainerType> CODEC;

            private ContainerType(String name) {
                this.name = name;
            }

            public String m_7912_() {
                return this.name;
            }

            public static ContainerType byName(String name) {
                for (ContainerType type : ContainerType.values()) {
                    if (!type.name.equals(name)) continue;
                    return type;
                }
                throw new IllegalArgumentException("Unknown special temperature value: " + name);
            }

            static {
                CODEC = Codec.STRING.xmap(ContainerType::byName, ContainerType::m_7912_);
            }
        }
    }
}

