/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public record EnchantmentRequirement(Either<TagKey<Enchantment>, Enchantment> enchantment, Optional<IntegerBounds> level) {
    public static final Codec<EnchantmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrRegistryObjectCodec(Registry.f_122902_, ForgeRegistries.ENCHANTMENTS).fieldOf("enchantment").forGetter(requirement -> requirement.enchantment), (App)IntegerBounds.CODEC.optionalFieldOf("levels").forGetter(requirement -> requirement.level)).apply((Applicative)instance, EnchantmentRequirement::new));

    public boolean test(Enchantment enchantment, int level) {
        return (Boolean)this.enchantment.map(tag -> ForgeRegistries.ENCHANTMENTS.tags().getTag(tag).contains((Object)enchantment), ench -> ench == enchantment) != false && this.level.map(bounds -> bounds.test(level)).orElse(true) != false;
    }

    public boolean test(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if (!this.test(entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("enchantment", ConfigHelper.serializeTagOrRegistryObject(ForgeRegistries.ENCHANTMENTS, this.enchantment));
        this.level.ifPresent(bounds -> tag.m_128365_("level", (Tag)bounds.serialize()));
        return tag;
    }

    public static EnchantmentRequirement deserialize(CompoundTag tag) {
        Either enchantment = ConfigHelper.deserializeTagOrRegistryObject(tag.m_128461_("enchantment"), Registry.f_122902_, ForgeRegistries.ENCHANTMENTS);
        IntegerBounds level = tag.m_128441_("level") ? IntegerBounds.deserialize(tag.m_128469_("level")) : null;
        return new EnchantmentRequirement(enchantment, Optional.ofNullable(level));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnchantmentRequirement that = (EnchantmentRequirement)obj;
        if (!this.enchantment.equals(that.enchantment)) {
            return false;
        }
        return this.level.equals(that.level);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ConfigHelper.serializeTagOrRegistryObject(ForgeRegistries.ENCHANTMENTS, this.enchantment));
        this.level.ifPresent(bounds -> builder.append(bounds));
        return builder.toString();
    }
}

