/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public record EquipmentRequirement(Optional<ItemRequirement> head, Optional<ItemRequirement> chest, Optional<ItemRequirement> legs, Optional<ItemRequirement> feet, Optional<ItemRequirement> mainHand, Optional<ItemRequirement> offHand) {
    public static final Codec<EquipmentRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemRequirement.CODEC.optionalFieldOf("head").forGetter(requirement -> requirement.head), (App)ItemRequirement.CODEC.optionalFieldOf("chest").forGetter(requirement -> requirement.chest), (App)ItemRequirement.CODEC.optionalFieldOf("legs").forGetter(requirement -> requirement.legs), (App)ItemRequirement.CODEC.optionalFieldOf("feet").forGetter(requirement -> requirement.feet), (App)ItemRequirement.CODEC.optionalFieldOf("mainhand").forGetter(requirement -> requirement.mainHand), (App)ItemRequirement.CODEC.optionalFieldOf("offhand").forGetter(requirement -> requirement.offHand)).apply((Applicative)instance, EquipmentRequirement::new));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(Entity entity) {
        if (this.head.isEmpty() && this.chest.isEmpty() && this.legs.isEmpty() && this.feet.isEmpty() && this.mainHand.isEmpty()) {
            if (this.offHand.isEmpty()) return true;
        }
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living = (LivingEntity)entity;
        if (!this.head.isEmpty()) {
            if (!this.head.get().test(living.m_6844_(EquipmentSlot.HEAD), true)) return false;
        }
        if (!this.chest.isEmpty()) {
            if (!this.chest.get().test(living.m_6844_(EquipmentSlot.CHEST), true)) return false;
        }
        if (!this.legs.isEmpty()) {
            if (!this.legs.get().test(living.m_6844_(EquipmentSlot.LEGS), true)) return false;
        }
        if (!this.feet.isEmpty()) {
            if (!this.feet.get().test(living.m_6844_(EquipmentSlot.FEET), true)) return false;
        }
        if (!this.mainHand.isEmpty()) {
            if (!this.mainHand.get().test(living.m_21205_(), true)) return false;
        }
        if (this.offHand.isEmpty()) return true;
        if (!this.offHand.get().test(living.m_21206_(), true)) return false;
        return true;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        this.head.ifPresent(requirement -> tag.m_128365_("head", (Tag)requirement.serialize()));
        this.chest.ifPresent(requirement -> tag.m_128365_("chest", (Tag)requirement.serialize()));
        this.legs.ifPresent(requirement -> tag.m_128365_("legs", (Tag)requirement.serialize()));
        this.feet.ifPresent(requirement -> tag.m_128365_("feet", (Tag)requirement.serialize()));
        this.mainHand.ifPresent(requirement -> tag.m_128365_("main_hand", (Tag)requirement.serialize()));
        this.offHand.ifPresent(requirement -> tag.m_128365_("off_hand", (Tag)requirement.serialize()));
        return tag;
    }

    public static EquipmentRequirement deserialize(CompoundTag tag) {
        return new EquipmentRequirement(tag.m_128441_("head") ? Optional.of(ItemRequirement.deserialize(tag.m_128469_("head"))) : Optional.empty(), tag.m_128441_("chest") ? Optional.of(ItemRequirement.deserialize(tag.m_128469_("chest"))) : Optional.empty(), tag.m_128441_("legs") ? Optional.of(ItemRequirement.deserialize(tag.m_128469_("legs"))) : Optional.empty(), tag.m_128441_("feet") ? Optional.of(ItemRequirement.deserialize(tag.m_128469_("feet"))) : Optional.empty(), tag.m_128441_("main_hand") ? Optional.of(ItemRequirement.deserialize(tag.m_128469_("main_hand"))) : Optional.empty(), tag.m_128441_("off_hand") ? Optional.of(ItemRequirement.deserialize(tag.m_128469_("off_hand"))) : Optional.empty());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EquipmentRequirement that = (EquipmentRequirement)obj;
        return this.head.equals(that.head) && this.chest.equals(that.chest) && this.legs.equals(that.legs) && this.feet.equals(that.feet) && this.mainHand.equals(that.mainHand) && this.offHand.equals(that.offHand);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.head.ifPresent(requirement -> builder.append("Head: ").append(requirement.toString()));
        this.chest.ifPresent(requirement -> builder.append("Chest: ").append(requirement.toString()));
        this.legs.ifPresent(requirement -> builder.append("Legs: ").append(requirement.toString()));
        this.feet.ifPresent(requirement -> builder.append("Feet: ").append(requirement.toString()));
        this.mainHand.ifPresent(requirement -> builder.append("Main Hand: ").append(requirement.toString()));
        this.offHand.ifPresent(requirement -> builder.append("Off Hand: ").append(requirement.toString()));
        return builder.toString();
    }
}

