/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public record FluidRequirement(Optional<List<Fluid>> fluids, Optional<TagKey<Fluid>> tag, Optional<BlockRequirement.StateRequirement> state, Optional<NbtRequirement> nbt) {
    public static final Codec<FluidRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.FLUIDS.getCodec().listOf().optionalFieldOf("fluids").forGetter(predicate -> predicate.fluids), (App)TagKey.m_203877_((ResourceKey)Registry.f_122899_).optionalFieldOf("tag").forGetter(predicate -> predicate.tag), (App)BlockRequirement.StateRequirement.CODEC.optionalFieldOf("state").forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt").forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, FluidRequirement::new));

    public boolean test(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_46749_(pPos)) {
            return false;
        }
        FluidState lState = pLevel.m_6425_(pPos);
        return this.test(lState);
    }

    public boolean test(FluidState pState) {
        if (this.tag.isPresent() && !pState.m_205070_(this.tag.get())) {
            return false;
        }
        if (this.fluids.isPresent() && !this.fluids.get().contains(pState.m_76152_())) {
            return false;
        }
        return this.state.isEmpty() || this.state.get().matches(pState);
    }

    public CompoundTag serialize() {
        CompoundTag lTag = new CompoundTag();
        this.fluids.ifPresent(fluids -> lTag.m_128365_("fluids", (Tag)NBTHelper.listTagOf(fluids.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0)).map(Object::toString).collect(Collectors.toList()))));
        this.tag.ifPresent(tag -> lTag.m_128359_("tag", tag.f_203868_().toString()));
        this.state.ifPresent(state -> lTag.m_128365_("state", (Tag)state.serialize()));
        this.nbt.ifPresent(nbt -> lTag.m_128365_("nbt", (Tag)nbt.serialize()));
        return lTag;
    }

    public static FluidRequirement deserialize(CompoundTag pTag) {
        Optional<List<Fluid>> lFluids = pTag.m_128441_("fluids") ? Optional.of(pTag.m_128437_("fluids", 8).stream().map(tag -> (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_7916_()))).collect(Collectors.toList())) : Optional.empty();
        Optional<TagKey<Fluid>> lTag = pTag.m_128441_("tag") ? Optional.of(TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(pTag.m_128461_("tag")))) : Optional.empty();
        Optional<BlockRequirement.StateRequirement> lState = pTag.m_128441_("state") ? Optional.of(BlockRequirement.StateRequirement.deserialize(pTag.m_128469_("state"))) : Optional.empty();
        Optional<NbtRequirement> lNbt = pTag.m_128441_("nbt") ? Optional.of(NbtRequirement.deserialize(pTag.m_128469_("nbt"))) : Optional.empty();
        return new FluidRequirement(lFluids, lTag, lState, lNbt);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FluidRequirement that = (FluidRequirement)obj;
        if (!this.fluids.equals(that.fluids)) {
            return false;
        }
        if (!this.tag.equals(that.tag)) {
            return false;
        }
        if (!this.state.equals(that.state)) {
            return false;
        }
        return this.nbt.equals(that.nbt);
    }

    @Override
    public String toString() {
        StringBuilder lBuilder = new StringBuilder();
        this.fluids.ifPresent(fluids -> lBuilder.append("Fluids: ").append(fluids.toString()));
        this.tag.ifPresent(tag -> lBuilder.append("Tag: ").append(tag.toString()));
        this.state.ifPresent(state -> lBuilder.append("State: ").append(state.toString()));
        this.nbt.ifPresent(nbt -> lBuilder.append("NBT: ").append(nbt.toString()));
        return lBuilder.toString();
    }
}

