/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.LootEntry;
import com.momosoftworks.coldsweat.util.math.CSMath;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class AddPiglinBartersModifier
extends LootModifier {
    public static Codec<AddPiglinBartersModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(modifier -> modifier.conditions), (App)LootEntry.CODEC.listOf().fieldOf("additions").forGetter(modifier -> modifier.additions)).apply((Applicative)inst, AddPiglinBartersModifier::new));
    private final List<LootEntry> additions;
    static ResourceLocation PIGLIN_BARTER_LOCATION = new ResourceLocation("gameplay/piglin_bartering");
    static Field POOLS = ObfuscationReflectionHelper.findField(LootTable.class, (String)"f_79109_");
    static Field ENTRIES = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");

    protected AddPiglinBartersModifier(LootItemCondition[] conditions, List<LootEntry> additions) {
        super(conditions);
        this.additions = additions;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, final LootContext context) {
        try {
            ArrayList<1> entries = new ArrayList<1>();
            MutableInt totalWeight = new MutableInt();
            for (LootPool pool : (List)POOLS.get(context.m_78940_(PIGLIN_BARTER_LOCATION))) {
                for (LootPoolEntryContainer container : (LootPoolEntryContainer[])ENTRIES.get(pool)) {
                    container.m_6562_(context, entry -> {
                        entries.add(entry);
                        totalWeight.add(entry.m_7067_(context.m_78945_()));
                    });
                }
            }
            for (final LootEntry addition : this.additions) {
                entries.add(new LootPoolEntry(){

                    public int m_7067_(float luck) {
                        return CSMath.floor((float)addition.weight() * (1.0f + context.m_78945_()));
                    }

                    public void m_6941_(Consumer<ItemStack> consumer, LootContext context1) {
                        consumer.accept(new ItemStack((ItemLike)addition.item(), context.m_230907_().m_216332_(addition.count().min(), addition.count().max())));
                    }
                });
                totalWeight.add(addition.weight());
            }
            AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
            int j = context.m_230907_().m_188503_(totalWeight.intValue());
            for (LootPoolEntry lootPoolEntry : entries) {
                if ((j -= lootPoolEntry.m_7067_(context.m_78945_())) >= 0) continue;
                lootPoolEntry.m_6941_(stack::set, context);
                return ObjectArrayList.wrap((Object[])new ItemStack[]{stack.get()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generatedLoot;
    }

    public Codec<AddPiglinBartersModifier> codec() {
        return CODEC;
    }

    static {
        POOLS.setAccessible(true);
        ENTRIES.setAccessible(true);
    }
}

