/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.event.HandleSoulLampAnim;
import com.momosoftworks.coldsweat.client.event.RenderLampHand;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={HumanoidModel.class})
public class MixinSoulLampRendering {
    HumanoidModel model = (HumanoidModel)this;
    @Final
    @Shadow
    public ModelPart f_102811_;
    @Final
    @Shadow
    public ModelPart f_102812_;

    @Inject(method={"poseRightArm"}, at={@At(value="TAIL")})
    public void poseRightArm(LivingEntity entity, CallbackInfo ci) {
        boolean holdingLamp = EntityHelper.holdingLamp(entity, HumanoidArm.RIGHT);
        Pair<Float, Float> armRot = HandleSoulLampAnim.RIGHT_ARM_ROTATIONS.getOrDefault(entity, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        float rightArmRot = CSMath.toRadians(CSMath.blend(((Float)armRot.getSecond()).floatValue(), ((Float)armRot.getFirst()).floatValue(), Minecraft.m_91087_().m_91296_(), 0.0f, 1.0f));
        if (!CSMath.betweenInclusive(rightArmRot, -0.01, 0.01)) {
            switch (this.model.f_102816_) {
                case EMPTY: {
                    this.f_102811_.f_104203_ -= rightArmRot;
                    this.f_102811_.f_104205_ = this.f_102811_.f_104205_ - (holdingLamp ? 0.05f : 0.0f);
                    this.f_102811_.f_104204_ = 0.0f;
                    break;
                }
                case ITEM: {
                    this.f_102811_.f_104203_ = (holdingLamp ? this.f_102811_.f_104203_ * 0.15f - 0.35f : this.f_102811_.f_104203_) - rightArmRot;
                    this.f_102811_.f_104205_ = this.f_102811_.f_104205_ - (holdingLamp ? 0.05f : 0.0f);
                    this.f_102811_.f_104204_ = 0.0f;
                }
            }
        }
        RenderLampHand.transformArm(entity, this.f_102811_, HumanoidArm.RIGHT);
    }

    @Inject(method={"poseLeftArm"}, at={@At(value="TAIL")})
    public void poseLeftArm(LivingEntity entity, CallbackInfo ci) {
        boolean holdingLamp = EntityHelper.holdingLamp(entity, HumanoidArm.LEFT);
        Pair<Float, Float> armRot = HandleSoulLampAnim.LEFT_ARM_ROTATIONS.getOrDefault(entity, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        float leftArmRot = CSMath.blend(CSMath.toRadians(((Float)armRot.getSecond()).floatValue()), CSMath.toRadians(((Float)armRot.getFirst()).floatValue()), Minecraft.m_91087_().m_91296_(), 0.0f, 1.0f);
        if (!CSMath.betweenInclusive(leftArmRot, -0.01, 0.01)) {
            switch (this.model.f_102815_) {
                case EMPTY: {
                    this.f_102812_.f_104203_ -= leftArmRot;
                    this.f_102812_.f_104205_ = this.f_102812_.f_104205_ + (holdingLamp ? 0.05f : 0.0f);
                    this.f_102812_.f_104204_ = 0.0f;
                    break;
                }
                case ITEM: {
                    this.f_102812_.f_104203_ = (holdingLamp ? this.f_102812_.f_104203_ * 0.15f - 0.35f : this.f_102812_.f_104203_) - leftArmRot;
                    this.f_102812_.f_104205_ = this.f_102812_.f_104205_ + (holdingLamp ? 0.05f : 0.0f);
                    this.f_102812_.f_104204_ = 0.0f;
                }
            }
        }
        RenderLampHand.transformArm(entity, this.f_102812_, HumanoidArm.LEFT);
    }

    @Mixin(value={HumanoidModel.class})
    public static class ShiftWidePlayerArm {
        HumanoidModel self = (HumanoidModel)this;

        @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
        public void shiftWidePlayerArm(LivingEntity entity, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch, CallbackInfo ci) {
            HumanoidModel humanoidModel = this.self;
            if (humanoidModel instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)humanoidModel;
                if (!ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                    if (EntityHelper.holdingLamp(entity, HumanoidArm.RIGHT)) {
                        playerModel.f_102811_.f_104201_ += 1.0f;
                    }
                    if (EntityHelper.holdingLamp(entity, HumanoidArm.LEFT)) {
                        playerModel.f_102812_.f_104201_ += 1.0f;
                    }
                }
            }
        }
    }

    @Mixin(value={HumanoidArmorLayer.class})
    public static class ChestplateArms<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>> {
        HumanoidArmorLayer<T, M, A> self = (HumanoidArmorLayer)this;

        @Inject(method={"renderArmorPiece"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/HumanoidModel;copyPropertiesTo(Lnet/minecraft/client/model/HumanoidModel;)V", shift=At.Shift.AFTER)})
        public void renderChestplateArms(PoseStack poseStack, MultiBufferSource buffer, T entity, EquipmentSlot slot, int light, A model, CallbackInfo ci) {
            if (slot == EquipmentSlot.CHEST) {
                if (EntityHelper.holdingLamp(entity, HumanoidArm.RIGHT)) {
                    ((HumanoidModel)model).f_102811_.f_104205_ -= CSMath.toRadians(90.0f);
                    ((HumanoidModel)model).f_102811_.f_104203_ = -((HumanoidModel)model).f_102811_.f_104204_ - CSMath.toRadians(90.0f);
                    ((HumanoidModel)model).f_102811_.f_104204_ = 0.0f;
                    ((HumanoidModel)model).f_102811_.f_104200_ += 1.0f;
                    if (!ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                        ((HumanoidModel)model).f_102811_.f_104201_ -= 1.0f;
                    }
                }
                if (EntityHelper.holdingLamp(entity, HumanoidArm.LEFT)) {
                    ((HumanoidModel)model).f_102812_.f_104205_ += CSMath.toRadians(90.0f);
                    ((HumanoidModel)model).f_102812_.f_104203_ = ((HumanoidModel)model).f_102812_.f_104204_ - CSMath.toRadians(90.0f);
                    ((HumanoidModel)model).f_102812_.f_104204_ = 0.0f;
                    ((HumanoidModel)model).f_102812_.f_104200_ -= 1.0f;
                    if (!ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                        ((HumanoidModel)model).f_102812_.f_104201_ -= 1.0f;
                    }
                }
            }
        }
    }

    @Mixin(value={ItemInHandLayer.class})
    public static class HeldItem {
        ItemInHandLayer self = (ItemInHandLayer)this;
        private static boolean WAS_RIGHT_HAND_ADJUSTED = false;

        @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/ItemInHandLayer;renderArmWithItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
        public void shiftRightArmLamp(PoseStack ms, MultiBufferSource bufferSource, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci, boolean isMainArm, ItemStack leftHand, ItemStack rightHand) {
            if (rightHand.m_150930_(ModItems.SOULSPRING_LAMP) && ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                ms.m_85837_(-0.03125, 0.0, 0.0);
                WAS_RIGHT_HAND_ADJUSTED = true;
            }
        }

        @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/ItemInHandLayer;renderArmWithItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD)
        public void shiftLeftArmLamp(PoseStack ms, MultiBufferSource bufferSource, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci, boolean isMainArm, ItemStack leftHand, ItemStack rightHand) {
            if (WAS_RIGHT_HAND_ADJUSTED) {
                ms.m_85837_(0.03125, 0.0, 0.0);
                WAS_RIGHT_HAND_ADJUSTED = false;
            }
            if (leftHand.m_150930_(ModItems.SOULSPRING_LAMP) && ClientOnlyHelper.isPlayerModelSlim(this.self)) {
                ms.m_85837_(0.03125, 0.0, 0.0);
            }
        }
    }
}

