/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.compat.create;

import com.google.common.collect.ImmutableList;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.blockentity.ThermolithBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ColdSweatDisplayBehaviors {
    public static DisplayBehaviour THERMOLITH;

    public static class Thermolith
    extends SingleLineDisplaySource {
        protected MutableComponent provideLine(DisplayLinkContext displayLinkContext, DisplayTargetStats displayTargetStats) {
            BlockEntity blockEntity = displayLinkContext.getSourceBlockEntity();
            if (blockEntity instanceof ThermolithBlockEntity) {
                ThermolithBlockEntity thermolith = (ThermolithBlockEntity)blockEntity;
                double temperature = Temperature.getTemperatureAt(thermolith.m_58899_(), thermolith.m_58904_());
                String unitsString = displayLinkContext.sourceConfig().m_128461_("Units");
                Temperature.Units units = Optional.ofNullable(Temperature.Units.fromID(unitsString)).orElse(Temperature.Units.MC);
                double convertedTemp = Temperature.convert(temperature, Temperature.Units.MC, units, true);
                String text = String.format("%.0f%s", convertedTemp, units.getFormattedName());
                return Component.m_237113_((String)text);
            }
            return Component.m_237119_();
        }

        protected boolean allowsLabeling(DisplayLinkContext displayLinkContext) {
            return true;
        }

        public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
            super.initConfigurationWidgets(context, builder, isFirstLine);
            if (!isFirstLine) {
                builder.addTextInput(0, 137, (e, t) -> {
                    e.m_94144_("mc");
                    t.withTooltip((List)ImmutableList.of((Object)Component.m_237115_((String)"cold_sweat.config.units.name").m_130946_(" (f, c, mc)").m_130938_(s -> s.m_178520_(5476833)), (Object)Lang.translateDirect((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
                }, "Units");
            }
        }

        public Component getName() {
            return Component.m_237115_((String)"block.cold_sweat.thermolith");
        }
    }
}

