/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.math;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class FastMultiMap<K, V>
implements Multimap<K, V> {
    private final FastMap<K, Set<V>> internal = new FastMap();
    private int totalSize = 0;

    public int size() {
        return this.totalSize;
    }

    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    public boolean containsKey(@Nullable Object key) {
        return this.internal.containsKey(key);
    }

    public boolean containsValue(@Nullable Object value) {
        if (value == null || this.isEmpty()) {
            return false;
        }
        for (Set<V> values : this.internal.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Set<V> values = this.internal.get(key);
        return values != null && values.contains(value);
    }

    public boolean put(K key, V value) {
        Set values = this.internal.computeIfAbsent(key, k -> new HashSet());
        if (values.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        Set<V> values = this.internal.get(key);
        if (values != null && values.remove(value)) {
            --this.totalSize;
            if (values.isEmpty()) {
                this.internal.remove(key);
            }
            return true;
        }
        return false;
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean changed = false;
        for (V value : values) {
            changed |= this.put(key, value);
        }
        return changed;
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        Set<V> oldValues = this.internal.get(key);
        if (oldValues == null) {
            oldValues = new HashSet<V>();
        } else {
            this.totalSize -= oldValues.size();
            oldValues.clear();
        }
        for (V value : values) {
            oldValues.add(value);
            ++this.totalSize;
        }
        this.internal.put((Object)key, (Object)oldValues);
        return oldValues;
    }

    public Set<V> removeAll(@Nullable Object key) {
        HashSet removed = this.internal.remove(key);
        if (removed != null) {
            this.totalSize -= removed.size();
        }
        return removed != null ? removed : new HashSet();
    }

    public void clear() {
        this.internal.clear();
        this.totalSize = 0;
    }

    public Set<V> get(K key) {
        HashSet values = this.internal.get(key);
        return values != null ? values : new HashSet();
    }

    public Set<K> keySet() {
        return this.internal.keySet();
    }

    public Multiset<K> keys() {
        HashMultiset keys = HashMultiset.create();
        for (Map.Entry<K, Set<V>> entry : this.internal.entrySet()) {
            keys.add(entry.getKey(), entry.getValue().size());
        }
        return keys;
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<Set<V>> setIterator;
                    private Iterator<V> currentIterator;
                    {
                        this.setIterator = FastMultiMap.this.internal.values().iterator();
                        this.currentIterator = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.currentIterator.hasNext() && this.setIterator.hasNext()) {
                            this.currentIterator = this.setIterator.next().iterator();
                        }
                        return this.currentIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.currentIterator.next();
                    }
                };
            }

            @Override
            public int size() {
                return FastMultiMap.this.totalSize;
            }
        };
    }

    public Collection<Map.Entry<K, V>> entries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, Set<V>>> entryIterator;
                    private Map.Entry<K, Set<V>> currentEntry;
                    private Iterator<V> valueIterator;
                    {
                        this.entryIterator = FastMultiMap.this.internal.entrySet().iterator();
                        this.valueIterator = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.valueIterator.hasNext() && this.entryIterator.hasNext()) {
                            this.currentEntry = this.entryIterator.next();
                            this.valueIterator = this.currentEntry.getValue().iterator();
                        }
                        return this.valueIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new AbstractMap.SimpleEntry(this.currentEntry.getKey(), this.valueIterator.next());
                    }
                };
            }

            @Override
            public int size() {
                return FastMultiMap.this.totalSize;
            }
        };
    }

    public FastMap<K, Collection<V>> asMap() {
        FastMap map = new FastMap(this.internal.size());
        for (Map.Entry<K, Set<V>> entry : this.internal.entrySet()) {
            map.put((Object)entry.getKey(), entry.getValue());
        }
        return map;
    }
}

