/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.util.exceptions.SerializationException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;

public class DynamicHolder<T> {
    private T value;
    private final Getter<T> valueCreator;
    private Writer<T> encoder;
    private Reader<T> decoder;
    private Saver<T> saver;
    private boolean synced = false;
    private boolean requireRegistries = false;

    protected DynamicHolder(Supplier<T> valueCreator) {
        this.valueCreator = registryAccess -> valueCreator.get();
    }

    protected DynamicHolder(Getter<T> valueCreator) {
        this.valueCreator = valueCreator;
    }

    public static <T> DynamicHolder<T> createWithRegistries(Getter<T> valueCreator) {
        DynamicHolder<T> loader = new DynamicHolder<T>(valueCreator);
        loader.requireRegistries = true;
        return loader;
    }

    public static <T> DynamicHolder<T> create(Supplier<T> valueCreator) {
        return new DynamicHolder<T>(valueCreator);
    }

    public static <T> DynamicHolder<T> createSyncedWithRegistries(Getter<T> valueCreator, Writer<T> encoder, Reader<T> decoder, Saver<T> saver) {
        DynamicHolder<T> loader = new DynamicHolder<T>(valueCreator);
        loader.encoder = encoder;
        loader.decoder = decoder;
        loader.saver = saver;
        loader.synced = true;
        loader.requireRegistries = true;
        return loader;
    }

    public static <T> DynamicHolder<T> createSynced(Supplier<T> valueCreator, Function<T, CompoundTag> encoder, Function<CompoundTag, T> decoder, Consumer<T> saver) {
        DynamicHolder<T> loader = new DynamicHolder<T>(valueCreator);
        loader.encoder = (val, registryAccess) -> (CompoundTag)encoder.apply(val);
        loader.decoder = (tag, registryAccess) -> decoder.apply(tag);
        loader.saver = (val, registryAccess) -> saver.accept(val);
        loader.synced = true;
        return loader;
    }

    public T get() {
        if (this.requireRegistries) {
            throw new RuntimeException("RegistryAccess is required for this DynamicHolder, yet none was provided.");
        }
        if (this.value == null) {
            this.load();
        }
        return this.value;
    }

    public T get(RegistryAccess registryAccess) {
        if (this.value == null) {
            this.load(registryAccess);
        }
        return this.value;
    }

    public void set(Object value) {
        if (!this.value.getClass().isInstance(value)) {
            throw new ClassCastException(String.format("Cannot cast value of type %s to DynamicHolder of type %s", value.getClass(), this.value.getClass()));
        }
        this.value = value;
    }

    public void load() {
        this.value = this.valueCreator.get(null);
    }

    public void load(RegistryAccess registryAccess) {
        this.value = this.valueCreator.get(registryAccess);
    }

    public CompoundTag encode(RegistryAccess registryAccess) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Tried to encode non-synced DynamicHolder", null));
        }
        try {
            return this.encoder.write(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)SerializationException.serialize(this.value, "Failed to encode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void decode(CompoundTag tag, RegistryAccess registryAccess) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to decode non-synced DynamicHolder", null));
        }
        try {
            this.value = this.decoder.read(tag, registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to decode DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public void save(RegistryAccess registryAccess) {
        if (!this.synced) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Tried to save non-synced DynamicHolder", null));
        }
        try {
            this.saver.save(this.get(registryAccess), registryAccess);
        }
        catch (Exception e) {
            throw (SerializationException)ColdSweat.LOGGER.throwing((Throwable)new SerializationException("Failed to save DynamicHolder for type " + this.value.getClass().getSimpleName(), e));
        }
    }

    public boolean isSynced() {
        return this.synced;
    }

    public boolean requiresRegistries() {
        return this.requireRegistries;
    }

    @FunctionalInterface
    public static interface Getter<T> {
        public T get(RegistryAccess var1);
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public CompoundTag write(T var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        public T read(CompoundTag var1, RegistryAccess var2);
    }

    @FunctionalInterface
    public static interface Saver<T> {
        public void save(T var1, RegistryAccess var2);
    }
}

