/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryHelper {
    @Nullable
    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> registry) {
        return CSMath.getIfNotNull(RegistryHelper.getRegistryAccess(), access -> access.m_175515_(registry), null);
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        Object access = null;
        MinecraftServer server = WorldHelper.getServer();
        if (server != null) {
            ServerLevel level = server.m_129880_(Level.f_46428_);
            access = level != null ? level.m_5962_() : server.m_206579_();
        }
        if (access == null && FMLEnvironment.dist == Dist.CLIENT) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                access = Minecraft.m_91087_().f_91073_.m_5962_();
            } else {
                ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
                if (connection != null) {
                    access = connection.m_105152_();
                }
            }
        }
        return access;
    }

    public static <T> List<T> mapForgeRegistryTagList(IForgeRegistry<T> registry, List<Either<TagKey<T>, T>> eitherList) {
        ArrayList list = new ArrayList();
        for (Either<TagKey<T>, T> either : eitherList) {
            either.ifLeft(tagKey -> list.addAll(registry.tags().getTag(tagKey).stream().toList()));
            either.ifRight(object -> list.add(object));
        }
        return list;
    }

    public static <T> List<T> mapVanillaRegistryTagList(ResourceKey<Registry<T>> registry, List<Either<TagKey<T>, T>> eitherList, @Nullable RegistryAccess registryAccess) {
        Registry reg = registryAccess != null ? registryAccess.m_175515_(registry) : RegistryHelper.getRegistry(registry);
        ArrayList list = new ArrayList();
        if (reg == null) {
            return list;
        }
        for (Either<TagKey<T>, T> either : eitherList) {
            either.ifLeft(tagKey -> {
                Optional tag = reg.m_203431_(tagKey);
                tag.ifPresent(tag1 -> list.addAll(tag1.m_203614_().map(Holder::m_203334_).toList()));
            });
            either.ifRight(list::add);
        }
        return list;
    }

    public static <T> Optional<T> getVanillaRegistryValue(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        try {
            return Optional.ofNullable(RegistryHelper.getRegistry(registry)).map(reg -> reg.m_7745_(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Nullable
    public static Biome getBiome(ResourceLocation biomeId, RegistryAccess registryAccess) {
        return (Biome)registryAccess.m_175515_(Registry.f_122885_).m_7745_(biomeId);
    }

    @Nullable
    public static ResourceLocation getBiomeId(Biome biome, RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registry.f_122885_).m_7981_((Object)biome);
    }

    @Nullable
    public static DimensionType getDimension(ResourceLocation dimensionId, RegistryAccess registryAccess) {
        return (DimensionType)registryAccess.m_175515_(Registry.f_122818_).m_7745_(dimensionId);
    }

    @Nullable
    public static ResourceLocation getDimensionId(DimensionType dimension, RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registry.f_122818_).m_7981_((Object)dimension);
    }

    @Nullable
    public static StructureType<?> getStructure(ResourceLocation structureId, RegistryAccess registryAccess) {
        return (StructureType)registryAccess.m_175515_(Registry.f_235739_).m_7745_(structureId);
    }

    @Nullable
    public static ResourceLocation getStructureId(StructureType<?> structure, RegistryAccess registryAccess) {
        return registryAccess.m_175515_(Registry.f_235739_).m_7981_(structure);
    }
}

