/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configureddefaults.handler;

import fuzs.configureddefaults.ConfiguredDefaults;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Predicate;

public class CopyDefaultsHandler {
    public static final String DEFAULTS_DIRECTORY = "configureddefaults";
    public static final String README_FILE = "README.md";
    private static final String README_CONTENTS = "# %1$s\n\nThis whole directory servers as a synchronized mirror of `.minecraft`. Every sub-directory and / or file placed within will be copied to the main `.minecraft` directory during game launch if the directory / file is not already present.\nThere is no way of overriding an existing file, a copy will only be made when the target destination is empty.\n\nPlease note that due to the way Minecraft handles `options.txt` specifically it is sufficient to include only the options you want to set a preset for. All missing options will be filled in using their internal defaults when the file is read by the game.\n\nExamples:\n- `.minecraft/%2$s/options.txt` will be copied to `.minecraft/options.txt` if not already present\n- `.minecraft/%2$s/config/jei/jei.toml` will be copied to `.minecraft/config/jei/jei.toml` if not already present\n\nNote that this `README.md` file is excluded from being copied to `.minecraft`.\n".formatted("Configured Defaults", "configureddefaults");
    private static boolean initialized;

    public static void initialize(Path gamePath) {
        if (!initialized) {
            initialized = true;
            ConfiguredDefaults.LOGGER.info("Applying default files...");
            Path defaultPresetsPath = gamePath.resolve(DEFAULTS_DIRECTORY);
            Path readmePath = defaultPresetsPath.resolve(README_FILE);
            try {
                CopyDefaultsHandler.trySetupFresh(gamePath, defaultPresetsPath, readmePath);
                Set<Path> blacklistedPaths = Set.of(defaultPresetsPath, readmePath, defaultPresetsPath.resolve(".DS_Store"));
                CopyDefaultsHandler.tryCopyFiles(gamePath, defaultPresetsPath, blacklistedPaths::contains);
            }
            catch (IOException exception) {
                ConfiguredDefaults.LOGGER.error("Failed to setup default files", (Throwable)exception);
            }
        }
    }

    private static void trySetupFresh(Path gamePath, Path defaultPresetsPath, Path readmePath) throws IOException {
        Path gameParentPath = gamePath.getParent();
        if (Files.notExists(defaultPresetsPath, new LinkOption[0])) {
            if (!defaultPresetsPath.toFile().mkdir()) {
                ConfiguredDefaults.LOGGER.info("Failed to create fresh '{}' directory", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, defaultPresetsPath));
                return;
            }
            ConfiguredDefaults.LOGGER.info("Successfully created fresh '{}' directory", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, defaultPresetsPath));
        }
        if (Files.notExists(readmePath, new LinkOption[0])) {
            Files.write(readmePath, README_CONTENTS.getBytes(), new OpenOption[0]);
            ConfiguredDefaults.LOGGER.info("Successfully created fresh '{}' file", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, readmePath));
        }
    }

    private static void tryCopyFiles(Path gamePath, Path defaultPresetsPath, Predicate<Path> filter) throws IOException {
        Path gameParentPath = gamePath.getParent();
        Files.walk(defaultPresetsPath, new FileVisitOption[0]).forEach(sourcePath -> {
            if (!filter.test((Path)sourcePath)) {
                try {
                    Path targetPath = CopyDefaultsHandler.relativizeAndNormalize(gamePath, defaultPresetsPath.relativize((Path)sourcePath));
                    if (sourcePath.toFile().exists() && !targetPath.toFile().exists()) {
                        try {
                            Files.copy(sourcePath, targetPath, new CopyOption[0]);
                            ConfiguredDefaults.LOGGER.info("Successfully copied '{}' to '{}'", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, sourcePath), (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, targetPath));
                        }
                        catch (IOException e) {
                            ConfiguredDefaults.LOGGER.info("Failed to copy '{}' to '{}'", (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, sourcePath), (Object)CopyDefaultsHandler.relativizeAndNormalize(gameParentPath, targetPath));
                        }
                    }
                }
                catch (Throwable throwable) {
                    ConfiguredDefaults.LOGGER.error("Oh no!", throwable);
                }
            }
        });
    }

    private static Path relativizeAndNormalize(Path parentPath, Path path) {
        return parentPath.toAbsolutePath().relativize(path.toAbsolutePath()).normalize();
    }
}

