/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats;

import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.mutable.MutableObject;

public class CCShapes {
    public static final VoxelShaper CASING_1PX = CCShapes.shape(0.0, 15.0, 0.0, 16.0, 16.0, 16.0).forDirectional();
    public static final VoxelShaper CASING_8PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 8.0, 16.0).forAxis();
    public static final VoxelShaper CASING_8PX_TOP = CCShapes.shape(0.0, 8.0, 0.0, 16.0, 16.0, 16.0).forAxis();
    public static final VoxelShaper CASING_8PX_CENTERED = CCShapes.shape(4.0, 0.0, 4.0, 12.0, 16.0, 12.0).forAxis();
    public static final VoxelShaper CASING_8PX_VERTICAL = CCShapes.shape(0.0, 0.0, 0.0, 8.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper EMPTY = CCShapes.shape(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).forDirectional();
    public static final VoxelShaper LAYER_2PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_4PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 4.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_6PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 6.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_8PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 8.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_10PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 10.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_12PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 12.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_14PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 14.0, 16.0).forDirectional();
    public static final VoxelShaper LAYER_16PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).forDirectional();
    public static final VoxelShaper HALF_PANEL_NORTH = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 3.0, 8.0).forOffsetDirectional(Direction.DOWN, Direction.NORTH);
    public static final VoxelShaper HALF_PANEL_SOUTH = CCShapes.shape(0.0, 0.0, 8.0, 16.0, 3.0, 16.0).forOffsetDirectional(Direction.DOWN, Direction.SOUTH);
    public static final VoxelShaper HALF_PANEL_EAST = CCShapes.shape(8.0, 0.0, 0.0, 16.0, 3.0, 16.0).forOffsetDirectional(Direction.DOWN, Direction.EAST);
    public static final VoxelShaper HALF_PANEL_WEST = CCShapes.shape(0.0, 0.0, 0.0, 8.0, 3.0, 16.0).forOffsetDirectional(Direction.DOWN, Direction.WEST);
    public static final VoxelShaper SLICE_BOTTOM_2PX = CCShapes.shape(0.0, 0.0, 14.0, 16.0, 2.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_4PX = CCShapes.shape(0.0, 0.0, 12.0, 16.0, 4.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_6PX = CCShapes.shape(0.0, 0.0, 10.0, 16.0, 6.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_8PX = CCShapes.shape(0.0, 0.0, 8.0, 16.0, 8.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_10PX = CCShapes.shape(0.0, 0.0, 6.0, 16.0, 10.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_12PX = CCShapes.shape(0.0, 0.0, 4.0, 16.0, 12.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_14PX = CCShapes.shape(0.0, 0.0, 2.0, 16.0, 14.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_BOTTOM_16PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_2PX = CCShapes.shape(0.0, 14.0, 14.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_4PX = CCShapes.shape(0.0, 12.0, 12.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_6PX = CCShapes.shape(0.0, 10.0, 10.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_8PX = CCShapes.shape(0.0, 8.0, 8.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_10PX = CCShapes.shape(0.0, 6.0, 6.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_12PX = CCShapes.shape(0.0, 4.0, 4.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_14PX = CCShapes.shape(0.0, 2.0, 2.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_TOP_16PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SLICE_VERTICAL_2PX = CCShapes.shape(0.0, 0.0, 0.0, 2.0, 16.0, 2.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_4PX = CCShapes.shape(0.0, 0.0, 0.0, 4.0, 16.0, 4.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_6PX = CCShapes.shape(0.0, 0.0, 0.0, 6.0, 16.0, 6.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_8PX = CCShapes.shape(0.0, 0.0, 0.0, 8.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_10PX = CCShapes.shape(0.0, 0.0, 0.0, 10.0, 16.0, 10.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_12PX = CCShapes.shape(0.0, 0.0, 0.0, 12.0, 16.0, 12.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_14PX = CCShapes.shape(0.0, 0.0, 0.0, 14.0, 16.0, 14.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper SLICE_VERTICAL_16PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_2PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_4PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 4.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_6PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 6.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_8PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 8.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_10PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 10.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_12PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 12.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_14PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 14.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_BOTTOM_16PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_2PX = CCShapes.shape(0.0, 14.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_4PX = CCShapes.shape(0.0, 12.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_6PX = CCShapes.shape(0.0, 10.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_8PX = CCShapes.shape(0.0, 8.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_10PX = CCShapes.shape(0.0, 6.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_12PX = CCShapes.shape(0.0, 4.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_14PX = CCShapes.shape(0.0, 2.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);
    public static final VoxelShaper HALF_LAYER_TOP_16PX = CCShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 8.0).forHorizontal(Direction.NORTH);

    private static Builder shape(VoxelShape shape) {
        return new Builder(shape);
    }

    private static Builder shape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return CCShapes.shape(CCShapes.cuboid(x1, y1, z1, x2, y2, z2));
    }

    private static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static class Builder {
        private VoxelShape shape;

        public Builder(VoxelShape shape) {
            this.shape = shape;
        }

        public Builder add(VoxelShape shape) {
            this.shape = Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)shape);
            return this;
        }

        public Builder add(double x1, double y1, double z1, double x2, double y2, double z2) {
            return this.add(CCShapes.cuboid(x1, y1, z1, x2, y2, z2));
        }

        public Builder erase(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)CCShapes.cuboid(x1, y1, z1, x2, y2, z2), (BooleanOp)BooleanOp.f_82685_);
            return this;
        }

        public VoxelShape build() {
            return this.shape;
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction, VoxelShaper> factory, Direction direction) {
            return factory.apply(this.shape, direction);
        }

        public VoxelShaper build(TriFunction<VoxelShape, Direction, Direction, VoxelShaper> factory, Direction direction, Direction offset) {
            return (VoxelShaper)((Object)factory.apply((Object)this.shape, (Object)direction, (Object)offset));
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction.Axis, VoxelShaper> factory, Direction.Axis axis) {
            return factory.apply(this.shape, axis);
        }

        public VoxelShaper forDirectional(Direction direction) {
            return this.build(VoxelShaper::forDirectional, direction);
        }

        public VoxelShaper forOffsetDirectional(Direction direction, Direction offset) {
            return this.build((TriFunction<VoxelShape, Direction, Direction, VoxelShaper>)((TriFunction)VoxelShaper::forOffsetDirectional), direction, offset);
        }

        public VoxelShaper forAxis() {
            return this.build(VoxelShaper::forAxis, Direction.Axis.Y);
        }

        public VoxelShaper forHorizontalAxis() {
            return this.build(VoxelShaper::forHorizontalAxis, Direction.Axis.Z);
        }

        public VoxelShaper forHorizontal(Direction direction) {
            return this.build(VoxelShaper::forHorizontal, direction);
        }

        public VoxelShaper forDirectional() {
            return this.forDirectional(Direction.UP);
        }

        public VoxelShaper forOffsetDirectional(Direction offset) {
            return this.forOffsetDirectional(Direction.UP, offset);
        }
    }

    public static class VoxelShaper
    extends com.simibubi.create.foundation.utility.VoxelShaper {
        private Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();

        public VoxelShape get(Direction direction) {
            return this.shapes.get(direction);
        }

        public VoxelShape get(Direction.Axis axis) {
            return this.shapes.get(VoxelShaper.axisAsFace(axis));
        }

        public static VoxelShaper forHorizontal(VoxelShape shape, Direction facing) {
            return VoxelShaper.forDirectionsWithRotation(shape, facing, (Iterable<Direction>)Direction.Plane.HORIZONTAL, new HorizontalRotationValues());
        }

        public static VoxelShaper forHorizontalAxis(VoxelShape shape, Direction.Axis along) {
            return VoxelShaper.forDirectionsWithRotation(shape, VoxelShaper.axisAsFace(along), Arrays.asList(Direction.SOUTH, Direction.EAST), new HorizontalRotationValues());
        }

        public static VoxelShaper forDirectional(VoxelShape shape, Direction facing) {
            return VoxelShaper.forDirectionsWithRotation(shape, facing, Arrays.asList(Iterate.directions), new DefaultRotationValues());
        }

        public static VoxelShaper forOffsetDirectional(VoxelShape shape, Direction facing, Direction offset) {
            return VoxelShaper.forDirectionsWithRotation(shape, facing, Arrays.asList(Iterate.directions), new OffsetRotationValues(offset));
        }

        public static VoxelShaper forAxis(VoxelShape shape, Direction.Axis along) {
            return VoxelShaper.forDirectionsWithRotation(shape, VoxelShaper.axisAsFace(along), Arrays.asList(Direction.SOUTH, Direction.EAST, Direction.UP), new DefaultRotationValues());
        }

        public VoxelShaper withVerticalShapes(VoxelShape upShape) {
            this.shapes.put(Direction.UP, upShape);
            this.shapes.put(Direction.DOWN, VoxelShaper.rotatedCopy(upShape, new Vec3(180.0, 0.0, 0.0)));
            return this;
        }

        public VoxelShaper withShape(VoxelShape shape, Direction facing) {
            this.shapes.put(facing, shape);
            return this;
        }

        public static Direction axisAsFace(Direction.Axis axis) {
            return Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        }

        protected static float horizontalAngleFromDirection(Direction direction) {
            return (Math.max(direction.m_122416_(), 0) & 3) * 90;
        }

        protected static VoxelShaper forDirectionsWithRotation(VoxelShape shape, Direction facing, Iterable<Direction> directions, Function<Direction, Vec3> rotationValues) {
            VoxelShaper voxelShaper = new VoxelShaper();
            for (Direction dir : directions) {
                voxelShaper.shapes.put(dir, VoxelShaper.rotate(shape, facing, dir, rotationValues));
            }
            return voxelShaper;
        }

        protected static VoxelShape rotate(VoxelShape shape, Direction from, Direction to, Function<Direction, Vec3> usingValues) {
            if (from == to) {
                return shape;
            }
            return VoxelShaper.rotatedCopy(shape, usingValues.apply(from).m_82548_().m_82549_(usingValues.apply(to)));
        }

        protected static VoxelShape rotatedCopy(VoxelShape shape, Vec3 rotation) {
            if (rotation.equals((Object)Vec3.f_82478_)) {
                return shape;
            }
            MutableObject result = new MutableObject((Object)Shapes.m_83040_());
            Vec3 center = new Vec3(8.0, 8.0, 8.0);
            shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                Vec3 v1 = new Vec3(x1, y1, z1).m_82490_(16.0).m_82546_(center);
                Vec3 v2 = new Vec3(x2, y2, z2).m_82490_(16.0).m_82546_(center);
                v1 = VecHelper.rotate((Vec3)v1, (double)((float)rotation.f_82479_), (Direction.Axis)Direction.Axis.X);
                v1 = VecHelper.rotate((Vec3)v1, (double)((float)rotation.f_82480_), (Direction.Axis)Direction.Axis.Y);
                v1 = VecHelper.rotate((Vec3)v1, (double)((float)rotation.f_82481_), (Direction.Axis)Direction.Axis.Z).m_82549_(center);
                v2 = VecHelper.rotate((Vec3)v2, (double)((float)rotation.f_82479_), (Direction.Axis)Direction.Axis.X);
                v2 = VecHelper.rotate((Vec3)v2, (double)((float)rotation.f_82480_), (Direction.Axis)Direction.Axis.Y);
                v2 = VecHelper.rotate((Vec3)v2, (double)((float)rotation.f_82481_), (Direction.Axis)Direction.Axis.Z).m_82549_(center);
                VoxelShape rotated = VoxelShaper.blockBox(v1, v2);
                result.setValue((Object)Shapes.m_83110_((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
            });
            return (VoxelShape)result.getValue();
        }

        protected static VoxelShape blockBox(Vec3 v1, Vec3 v2) {
            return Block.m_49796_((double)Math.min(v1.f_82479_, v2.f_82479_), (double)Math.min(v1.f_82480_, v2.f_82480_), (double)Math.min(v1.f_82481_, v2.f_82481_), (double)Math.max(v1.f_82479_, v2.f_82479_), (double)Math.max(v1.f_82480_, v2.f_82480_), (double)Math.max(v1.f_82481_, v2.f_82481_));
        }

        protected static class HorizontalRotationValues
        implements Function<Direction, Vec3> {
            protected HorizontalRotationValues() {
            }

            @Override
            public Vec3 apply(Direction direction) {
                return new Vec3(0.0, (double)(-VoxelShaper.horizontalAngleFromDirection(direction)), 0.0);
            }
        }

        protected static class DefaultRotationValues
        implements Function<Direction, Vec3> {
            protected DefaultRotationValues() {
            }

            @Override
            public Vec3 apply(Direction direction) {
                return new Vec3(direction == Direction.UP ? 0.0 : (double)(Direction.Plane.VERTICAL.test(direction) ? 180 : 90), (double)(-VoxelShaper.horizontalAngleFromDirection(direction)), 0.0);
            }
        }

        protected static class OffsetRotationValues
        implements Function<Direction, Vec3> {
            private final Direction offset;

            public OffsetRotationValues(Direction offset) {
                this.offset = offset;
            }

            @Override
            public Vec3 apply(Direction direction) {
                boolean positive;
                boolean bl = positive = direction.m_122421_() == Direction.AxisDirection.POSITIVE;
                if (direction.m_122434_() != this.offset.m_122434_()) {
                    return switch (direction.m_122434_()) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> new Vec3(0.0, 0.0, positive ? -90.0 : 90.0);
                        case Direction.Axis.Y -> {
                            if (this.offset.m_122434_() == Direction.Axis.X) {
                                yield new Vec3(0.0, positive ? 0.0 : 180.0, positive ? 0.0 : 180.0);
                            }
                            yield new Vec3(positive ? 0.0 : 180.0, positive ? 0.0 : 180.0, 0.0);
                        }
                        case Direction.Axis.Z -> new Vec3(positive ? 90.0 : -90.0, 0.0, 0.0);
                    };
                }
                return switch (direction.m_122434_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> new Vec3(0.0, direction.m_122421_() == Direction.AxisDirection.POSITIVE ? 180.0 : 0.0, positive ? -90.0 : 90.0);
                    case Direction.Axis.Y -> new Vec3(positive ? 0.0 : 180.0, positive ? 0.0 : 180.0, 0.0);
                    case Direction.Axis.Z -> new Vec3(positive ? -90.0 : 90.0, 0.0, direction.m_122421_() == Direction.AxisDirection.POSITIVE ? 180.0 : 0.0);
                };
            }
        }
    }
}

