/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.bytes;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.MathHelper;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.google.common.collect.ImmutableMap;
import com.mojang.math.OctahedralGroup;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatByteBlock
extends CTWaterloggedCopycatBlock
implements ISpecialBlockItemRequirement {
    public static BooleanProperty TOP_NE = BooleanProperty.m_61465_((String)"top_northeast");
    public static BooleanProperty TOP_NW = BooleanProperty.m_61465_((String)"top_northwest");
    public static BooleanProperty TOP_SE = BooleanProperty.m_61465_((String)"top_southeast");
    public static BooleanProperty TOP_SW = BooleanProperty.m_61465_((String)"top_southwest");
    public static BooleanProperty BOTTOM_NE = BooleanProperty.m_61465_((String)"bottom_northeast");
    public static BooleanProperty BOTTOM_NW = BooleanProperty.m_61465_((String)"bottom_northwest");
    public static BooleanProperty BOTTOM_SE = BooleanProperty.m_61465_((String)"bottom_southeast");
    public static BooleanProperty BOTTOM_SW = BooleanProperty.m_61465_((String)"bottom_southwest");
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    public static final List<Byte> allBytes = new ArrayList<Byte>(8);

    public CopycatByteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP_NE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_NW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_SE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_SW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_NE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_NW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_SE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM_SW, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.m_152458_(CopycatByteBlock::calculateMultiFaceShape);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{TOP_NE, TOP_NW, TOP_SE, TOP_SW, BOTTOM_NE, BOTTOM_NW, BOTTOM_SE, BOTTOM_SW}));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        return false;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return false;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return true;
    }

    private static VoxelShape calculateMultiFaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        for (Byte bite : allBytes) {
            if (!((Boolean)pState.m_61143_((Property)CopycatByteBlock.byByte(bite))).booleanValue()) continue;
            int offsetX = bite.x ? 8 : 0;
            int offsetY = bite.y ? 8 : 0;
            int offsetZ = bite.z ? 8 : 0;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)offsetX, (double)offsetY, (double)offsetZ, (double)(offsetX + 8), (double)(offsetY + 8), (double)(offsetZ + 8)));
        }
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> true;
            default -> false;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        Vec3 bias = Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625);
        Vec3 biasedLocation = context.m_43720_().m_82549_(bias);
        if (!MathHelper.blockPosContaining((Position)biasedLocation).equals((Object)context.m_8083_())) {
            biasedLocation = CopycatByteBlock.clampToBlockPos(biasedLocation, context.m_8083_());
        }
        Byte bite = CopycatByteBlock.getByteFromVec(biasedLocation, context.m_8083_());
        if (state.m_60713_((Block)this)) {
            if (!((Boolean)state.m_61143_((Property)CopycatByteBlock.byByte(bite))).booleanValue()) {
                return (BlockState)state.m_61124_((Property)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)state.m_61143_((Property)CopycatByteBlock.byByte(bite = bite.relative(context.m_43719_())))).booleanValue()) {
                return (BlockState)state.m_61124_((Property)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true));
            }
            Copycats.LOGGER.warn("Can't figure out where to place a byte! Please file an issue if you see this.");
            return state;
        }
        return (BlockState)stateForPlacement.m_61124_((Property)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        Byte bite;
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        Vec3 bias = Vec3.m_82528_((Vec3i)pUseContext.m_43719_().m_122436_()).m_82490_(0.0625);
        Vec3 biasedLocation = pUseContext.m_43720_().m_82549_(bias);
        if (!MathHelper.blockPosContaining((Position)biasedLocation).equals((Object)pUseContext.m_8083_())) {
            biasedLocation = CopycatByteBlock.clampToBlockPos(biasedLocation, pUseContext.m_8083_());
        }
        return (Boolean)pState.m_61143_((Property)CopycatByteBlock.byByte(bite = CopycatByteBlock.getByteFromVec(biasedLocation, pUseContext.m_8083_()))) == false;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        int byteCount = 0;
        for (Byte bite : allBytes) {
            if (!((Boolean)state.m_61143_((Property)CopycatByteBlock.byByte(bite))).booleanValue()) continue;
            ++byteCount;
        }
        if (byteCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Vec3 bias = Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(-0.0625);
        Byte bite = CopycatByteBlock.getByteFromVec(context.m_43720_().m_82549_(bias), context.m_8083_());
        if (world instanceof ServerLevel) {
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true))), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(false))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)this.m_5456_(), (int)allBytes.stream().filter(b -> (Boolean)state.m_61143_((Property)CopycatByteBlock.byByte(b))).count()));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, @NotNull Rotation pRotation) {
        if (pRotation == Rotation.CLOCKWISE_90) {
            return this.mapBytes(pState, bite -> CopycatByteBlock.bite(!bite.z, bite.y, bite.x));
        }
        if (pRotation == Rotation.CLOCKWISE_180) {
            return this.mapBytes(pState, bite -> CopycatByteBlock.bite(!bite.x, bite.y, !bite.z));
        }
        if (pRotation == Rotation.COUNTERCLOCKWISE_90) {
            return this.mapBytes(pState, bite -> CopycatByteBlock.bite(bite.z, bite.y, !bite.x));
        }
        return pState;
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, Mirror pMirror) {
        boolean invertX = pMirror.m_54842_() == OctahedralGroup.INVERT_X;
        boolean invertZ = pMirror.m_54842_() == OctahedralGroup.INVERT_Z;
        return this.mapBytes(pState, bite -> CopycatByteBlock.bite(invertX != bite.x, bite.y, invertZ != bite.z));
    }

    public static Vec3 clampToBlockPos(Vec3 vec, BlockPos pos) {
        return new Vec3(Mth.m_14008_((double)vec.f_82479_, (double)pos.m_123341_(), (double)(pos.m_123341_() + 1)), Mth.m_14008_((double)vec.f_82480_, (double)pos.m_123342_(), (double)(pos.m_123342_() + 1)), Mth.m_14008_((double)vec.f_82481_, (double)pos.m_123343_(), (double)(pos.m_123343_() + 1)));
    }

    public static Byte getByteFromVec(Vec3 vec, BlockPos pos) {
        vec = vec.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return CopycatByteBlock.bite(vec.f_82479_ > 0.5, vec.f_82480_ > 0.5, vec.f_82481_ > 0.5);
    }

    private BlockState mapBytes(BlockState state, Function<Byte, Byte> mapper) {
        BlockState blockstate = state;
        for (Byte bite : allBytes) {
            blockstate = (BlockState)blockstate.m_61124_((Property)CopycatByteBlock.byByte(mapper.apply(bite)), (Comparable)((Boolean)state.m_61143_((Property)CopycatByteBlock.byByte(bite))));
        }
        return blockstate;
    }

    public static Byte bite(boolean x, boolean y, boolean z) {
        return new Byte(x, y, z);
    }

    public static BooleanProperty byByte(Byte bite) {
        return CopycatByteBlock.byByte(bite.x, bite.y, bite.z);
    }

    public static BooleanProperty byByte(boolean x, boolean y, boolean z) {
        if (y) {
            if (x) {
                if (z) {
                    return TOP_SE;
                }
                return TOP_NE;
            }
            if (z) {
                return TOP_SW;
            }
            return TOP_NW;
        }
        if (x) {
            if (z) {
                return BOTTOM_SE;
            }
            return BOTTOM_NE;
        }
        if (z) {
            return BOTTOM_SW;
        }
        return BOTTOM_NW;
    }

    static {
        for (boolean x : Iterate.falseAndTrue) {
            for (boolean y : Iterate.falseAndTrue) {
                for (boolean z : Iterate.falseAndTrue) {
                    allBytes.add(CopycatByteBlock.bite(x, y, z));
                }
            }
        }
    }

    public record Byte(boolean x, boolean y, boolean z) {
        public Byte copy() {
            return new Byte(this.x, this.y, this.z);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Byte) {
                Byte other = (Byte)obj;
                return this.x == other.x && this.y == other.y && this.z == other.z;
            }
            return false;
        }

        public Byte set(Direction.Axis axis, boolean value) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> new Byte(value, this.y, this.z);
                case Direction.Axis.Y -> new Byte(this.x, value, this.z);
                case Direction.Axis.Z -> new Byte(this.x, this.y, value);
            };
        }

        public boolean get(Direction.Axis axis) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> this.x;
                case Direction.Axis.Y -> this.y;
                case Direction.Axis.Z -> this.z;
            };
        }

        public Byte relative(Direction direction) {
            return this.set(direction.m_122434_(), !this.get(direction.m_122434_()));
        }

        @Override
        public int hashCode() {
            return Byte.i(this.x) + Byte.i(this.y) << 1 + Byte.i(this.z) << 2;
        }

        private static int i(boolean b) {
            return b ? 1 : 0;
        }

        @Override
        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }
}

