/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.half_layer;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.content.copycat.MathHelper;
import com.copycatsplus.copycats.content.copycat.base.CTWaterloggedCopycatBlock;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatHalfLayerBlock
extends CTWaterloggedCopycatBlock
implements ISpecialBlockItemRequirement {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final IntegerProperty POSITIVE_LAYERS = IntegerProperty.m_61631_((String)"positive_layers", (int)0, (int)8);
    public static final IntegerProperty NEGATIVE_LAYERS = IntegerProperty.m_61631_((String)"negative_layers", (int)0, (int)8);
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private static final VoxelShaper[] TOP_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.HALF_LAYER_TOP_2PX, CCShapes.HALF_LAYER_TOP_4PX, CCShapes.HALF_LAYER_TOP_6PX, CCShapes.HALF_LAYER_TOP_8PX, CCShapes.HALF_LAYER_TOP_10PX, CCShapes.HALF_LAYER_TOP_12PX, CCShapes.HALF_LAYER_TOP_14PX, CCShapes.HALF_LAYER_TOP_16PX};
    private static final VoxelShaper[] BOTTOM_BY_LAYER = new VoxelShaper[]{CCShapes.EMPTY, CCShapes.HALF_LAYER_BOTTOM_2PX, CCShapes.HALF_LAYER_BOTTOM_4PX, CCShapes.HALF_LAYER_BOTTOM_6PX, CCShapes.HALF_LAYER_BOTTOM_8PX, CCShapes.HALF_LAYER_BOTTOM_10PX, CCShapes.HALF_LAYER_BOTTOM_12PX, CCShapes.HALF_LAYER_BOTTOM_14PX, CCShapes.HALF_LAYER_BOTTOM_16PX};

    public CopycatHalfLayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0)));
        this.shapesCache = this.m_152458_(CopycatHalfLayerBlock::calculateMultiFaceShape);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            Vec3 clickPosition = context.m_43720_().m_82549_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
            IntegerProperty targetProp = ((Direction.Axis)state.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
            if ((Integer)state.m_61143_((Property)targetProp) < 8) {
                return (BlockState)state.m_61122_((Property)targetProp);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a step layer! Please file an issue if you see this.");
            return state;
        }
        Direction.Axis axis = context.m_8125_().m_122434_();
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
        return (BlockState)((BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(HALF, (Comparable)(clickPosition.f_82480_ > 0.5 ? Half.TOP : Half.BOTTOM))).m_61124_((Property)(axis.m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) > 0.5 ? POSITIVE_LAYERS : NEGATIVE_LAYERS), (Comparable)Integer.valueOf(1));
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        Direction clickFace = pUseContext.m_43719_();
        if (clickFace.m_122434_().m_122478_() && pState.m_61143_(HALF) == Half.TOP == (clickFace == Direction.UP)) {
            return false;
        }
        Vec3 clickPosition = pUseContext.m_43720_().m_82549_(Vec3.m_82528_((Vec3i)pUseContext.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)pUseContext.m_8083_()));
        IntegerProperty targetProp = ((Direction.Axis)pState.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
        return (Integer)pState.m_61143_((Property)targetProp) != 8;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)POSITIVE_LAYERS) + (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)pos));
        IntegerProperty targetProp = ((Direction.Axis)state.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)targetProp, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)targetProp, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)targetProp) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)this.m_5456_(), (Integer)state.m_61143_((Property)POSITIVE_LAYERS) + (Integer)state.m_61143_((Property)NEGATIVE_LAYERS)));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            Half half = (Half)state.m_61143_(HALF);
            int positiveLayers = (Integer)state.m_61143_((Property)POSITIVE_LAYERS);
            int negativeLayers = (Integer)state.m_61143_((Property)NEGATIVE_LAYERS);
            return toState.m_61143_(AXIS) != axis || toState.m_61143_(HALF) != half || (Integer)toState.m_61143_((Property)POSITIVE_LAYERS) != positiveLayers || (Integer)toState.m_61143_((Property)NEGATIVE_LAYERS) != negativeLayers;
        }
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = MathHelper.DirectionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        Half half = (Half)state.m_61143_(HALF);
        int positiveLayers = (Integer)state.m_61143_((Property)POSITIVE_LAYERS);
        int negativeLayers = (Integer)state.m_61143_((Property)NEGATIVE_LAYERS);
        if (toState.m_60713_((Block)this)) {
            try {
                return toState.m_61143_(AXIS) == axis && toState.m_61143_(HALF) == half && (Integer)toState.m_61143_((Property)POSITIVE_LAYERS) == positiveLayers && (Integer)toState.m_61143_((Property)NEGATIVE_LAYERS) == negativeLayers && face.m_122427_().m_122434_() == axis;
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return false;
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        Function<Direction.Axis, Direction.Axis> swap = axis -> axis == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z;
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> state;
            case Rotation.CLOCKWISE_90 -> {
                Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
                if (axis == Direction.Axis.X) {
                    yield (BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis));
                }
                yield (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis))).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
            }
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)state.m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
            case Rotation.COUNTERCLOCKWISE_90 -> {
                Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
                if (axis == Direction.Axis.Z) {
                    yield (BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis));
                }
                yield (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis))).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
            }
        };
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)))));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{AXIS, HALF, POSITIVE_LAYERS, NEGATIVE_LAYERS}));
    }

    private static VoxelShape calculateMultiFaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)(pState.m_61143_(HALF) == Half.TOP ? TOP_BY_LAYER : BOTTOM_BY_LAYER)[(Integer)pState.m_61143_((Property)POSITIVE_LAYERS)].get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)pState.m_61143_(AXIS)))));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)(pState.m_61143_(HALF) == Half.TOP ? TOP_BY_LAYER : BOTTOM_BY_LAYER)[(Integer)pState.m_61143_((Property)NEGATIVE_LAYERS)].get(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)pState.m_61143_(AXIS)))));
        return shape;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        if (face.m_122434_().m_122478_() && state.m_61143_(HALF) == Half.TOP == (face == Direction.DOWN)) {
            return (Integer)state.m_61143_((Property)POSITIVE_LAYERS) < 8 || (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) < 8;
        }
        return super.shouldFaceAlwaysRender(state, face);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return false;
    }
}

