/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.IConfigured;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class DelightfulKnifeItem
extends KnifeItem
implements IConfigured {
    private final TagKey<Item> tag;

    public DelightfulKnifeItem(TagKey<Item> tag, Tier tier, Item.Properties properties) {
        super(tier, 0.5f, -2.0f, properties);
        this.tag = tag;
    }

    public boolean m_6832_(@NotNull ItemStack pToRepair, @NotNull ItemStack pRepair) {
        return super.m_6832_(pToRepair, pRepair);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> tool, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, tool, pIsAdvanced);
        if (!this.config()) {
            tool.add((Component)Component.m_237115_((String)"tooltip.config_disabled").m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.isTag() && this.getTag() != null) {
            tool.add((Component)Component.m_237115_((String)"tooltip.requires_tag"));
            tool.add((Component)Component.m_237113_((String)this.getTag().f_203868_().toString()).m_130940_(ChatFormatting.UNDERLINE));
        }
    }

    @Nullable
    public TagKey<Item> getTag() {
        return this.tag;
    }

    public boolean isTag() {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        TagKey<Item> tag = this.getTag();
        return tag != null && tags != null && tags.isKnownTagName(tag);
    }

    public boolean config() {
        return Util.enabled((Item)this);
    }

    @Override
    public boolean isEnabled() {
        return this.config() && this.isTag();
    }

    public Ingredient getRod() {
        return Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN);
    }

    public Supplier<Ingredient> getSmithingBase() {
        return () -> Ingredient.f_43901_;
    }

    @Nullable
    public RecipeType<?> getRecipeType() {
        return this.getSmithingBase().get().m_43947_() ? RecipeType.f_44107_ : RecipeType.f_44113_;
    }

    public boolean hasCustomName() {
        return false;
    }

    public List<Component> getTools() {
        return List.of();
    }

    protected boolean m_220152_(@NotNull CreativeModeTab cat) {
        return ImmutableList.of((Object)CreativeModeTab.f_40754_, (Object)FarmersDelight.CREATIVE_TAB).contains((Object)cat) && this.config();
    }
}

