/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Protection {
    public static final Protection EDIT_BLOCK = (player, pos, hand, chunk, entity) -> {
        BlockState blockState = player.f_19853_.m_8055_(pos);
        if (blockState.m_204336_(FTBChunksAPI.EDIT_WHITELIST_TAG)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.BLOCK_EDIT_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        return ProtectionOverride.CHECK;
    };
    public static final Protection INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        BlockState blockState = player.f_19853_.m_8055_(pos);
        if (blockState.m_204336_(FTBChunksAPI.INTERACT_WHITELIST_TAG)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.BLOCK_INTERACT_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        return ProtectionOverride.CHECK;
    };
    public static final Protection RIGHT_CLICK_ITEM = (player, pos, hand, chunk, entity) -> {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41614_() || FTBCUtils.isBeneficialPotion(stack) || stack.m_204117_(FTBChunksAPI.RIGHT_CLICK_WHITELIST_TAG)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.BLOCK_INTERACT_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && stack.m_204117_(FTBChunksAPI.RIGHT_CLICK_BLACKLIST_TAG)) {
            return ProtectionOverride.CHECK;
        }
        return ProtectionOverride.ALLOW;
    };
    public static final Protection EDIT_FLUID = (player, pos, hand, chunk, entity) -> {
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.BLOCK_EDIT_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        return ProtectionOverride.CHECK;
    };
    public static final Protection INTERACT_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.m_6095_().m_204039_(FTBChunksAPI.ENTITY_INTERACT_WHITELIST_TAG)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.ENTITY_INTERACT_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        return ProtectionOverride.CHECK;
    };
    public static final Protection ATTACK_NONLIVING_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.m_6095_().m_204039_(FTBChunksAPI.NONLIVING_ENTITY_ATTACK_WHITELIST_TAG)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.NONLIVING_ENTITY_ATTACK_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        return ProtectionOverride.CHECK;
    };
    public static final Protection EDIT_AND_INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        BlockState blockState = player.f_19853_.m_8055_(pos);
        if (blockState.m_204336_(FTBChunksAPI.INTERACT_WHITELIST_TAG)) {
            return ProtectionOverride.ALLOW;
        }
        if (chunk != null && chunk.teamData.canUse(player, FTBChunksTeamData.BLOCK_EDIT_AND_INTERACT_MODE)) {
            return ProtectionOverride.ALLOW;
        }
        return ProtectionOverride.CHECK;
    };

    public ProtectionOverride override(ServerPlayer var1, BlockPos var2, InteractionHand var3, @Nullable ClaimedChunk var4, @Nullable Entity var5);
}

